// 
// Exercise 2 in part 2 of the C#/.NET tutorial
// Example client written in C# by Michael Stal in 2001
// used to test the StockTicker class 
//

using System;
using Shares;

namespace StockTickerClient
{
	/// <summary>
	/// Just to test sour StockTicker server
	/// </summary>
	class TestDriver {
		// StockTicker instance to use
		private StockTicker m_StockTicker;

		/// <summary>
		/// Initialize Test
		/// </summary>
		public TestDriver() 
		{
			// create new StockTicker
			m_StockTicker = new StockTicker();
			//  and initialize it with some example shares
			Share share1 = new Share("MSFT", "Microsoft", "www.microsoft.com", 63);
			Share share2 = new Share("INTL", "Intel", "www.intel.com", 22);
			Share share3 = new Share("IBM",  "IBM", "www.ibm.com", 120);
			m_StockTicker["MSFT"] = share1;
			m_StockTicker["INTL"] = share2;
			m_StockTicker["IBM"] = share3;
		}

		/// <summary>
		/// here we test what happens when share values change
		/// </summary>
		public void Test() 
		{
			// create new adapter to be notified
			new StockTickerEventAdapter(m_StockTicker, "MSFT", new ChangeEvent(OnChange));
			// new let's change the share values
			m_StockTicker.ChangeValue("IBM", 125);
			m_StockTicker.ChangeValue("INTL", 25);
			m_StockTicker.ChangeValue("MSFT", 71);
			Console.Write("Press any key ...");
			Console.ReadLine();
		}

		/// <summary>
		/// OnChange is used to be notified on changes
		/// </summary>
		/// <param name="src"> who was the originator </param>
		/// <param name="e"> details about event </param>
		private void OnChange(object src, ChangeEventArgs e) 
		{
			Console.WriteLine("Share {0} changed from {1} to {2}",
				e.ShortName,
				e.OldValue,
				e.NewValue
			);
		}
	}

	/// <summary>
	/// Our sample client
	/// </summary>
	class Client
	{
		static void Main(string[] args)
		{
			// test it
			new TestDriver().Test();
		}
	}
}
