// 
// Exercise in part 3 of the C#/.NET tutorial
// Client accessing Webservices written in C# by Michael Stal in 2001
//

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace StockTickerClient
{
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button QueryButton;
		private System.Windows.Forms.Label ConditionLabel;
		private System.Windows.Forms.RichTextBox ConditionText;
		localhost.StockInfo WebServiceStockInfo;
		localhost1.EuroDM WebServiceEuroDMConverter;
		private System.Windows.Forms.Button ExitButton;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label StatusLabel;
		private System.Windows.Forms.Button AsynchronousQueryButton;
		private System.Windows.Forms.TextBox EuroBox;
		private System.Windows.Forms.TextBox DMBox;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.DataGrid dataGridShares;
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.WebServiceStockInfo = new localhost.StockInfo();
			this.WebServiceEuroDMConverter = new localhost1.EuroDM();
			this.AsynchronousQueryButton = new System.Windows.Forms.Button();
			this.QueryButton = new System.Windows.Forms.Button();
			this.label3 = new System.Windows.Forms.Label();
			this.ExitButton = new System.Windows.Forms.Button();
			this.label2 = new System.Windows.Forms.Label();
			this.dataGridShares = new System.Windows.Forms.DataGrid();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.DMBox = new System.Windows.Forms.TextBox();
			this.ConditionLabel = new System.Windows.Forms.Label();
			this.button1 = new System.Windows.Forms.Button();
			this.ConditionText = new System.Windows.Forms.RichTextBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.StatusLabel = new System.Windows.Forms.Label();
			this.EuroBox = new System.Windows.Forms.TextBox();
			((System.ComponentModel.ISupportInitialize)(this.dataGridShares)).BeginInit();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// AsynchronousQueryButton
			// 
			this.AsynchronousQueryButton.Location = new System.Drawing.Point(272, 48);
			this.AsynchronousQueryButton.Name = "AsynchronousQueryButton";
			this.AsynchronousQueryButton.Size = new System.Drawing.Size(128, 24);
			this.AsynchronousQueryButton.TabIndex = 9;
			this.AsynchronousQueryButton.Text = "Asynchronous Query";
			this.AsynchronousQueryButton.Click += new System.EventHandler(this.AsynchronousQueryButton_Click);
			// 
			// QueryButton
			// 
			this.QueryButton.Location = new System.Drawing.Point(152, 48);
			this.QueryButton.Name = "QueryButton";
			this.QueryButton.Size = new System.Drawing.Size(64, 24);
			this.QueryButton.TabIndex = 0;
			this.QueryButton.Text = "Query";
			this.QueryButton.Click += new System.EventHandler(this.QueryButton_Click);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(200, 291);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(32, 16);
			this.label3.TabIndex = 13;
			this.label3.Text = "DM";
			// 
			// ExitButton
			// 
			this.ExitButton.Location = new System.Drawing.Point(336, 328);
			this.ExitButton.Name = "ExitButton";
			this.ExitButton.Size = new System.Drawing.Size(80, 24);
			this.ExitButton.TabIndex = 4;
			this.ExitButton.Text = "Exit";
			this.ExitButton.Click += new System.EventHandler(this.button1_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(33, 291);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(32, 24);
			this.label2.TabIndex = 12;
			this.label2.Text = "Euro";
			// 
			// dataGridShares
			// 
			this.dataGridShares.CaptionText = "List of Shares Returned";
			this.dataGridShares.DataMember = "";
			this.dataGridShares.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGridShares.Location = new System.Drawing.Point(24, 104);
			this.dataGridShares.Name = "dataGridShares";
			this.dataGridShares.PreferredColumnWidth = 170;
			this.dataGridShares.ReadOnly = true;
			this.dataGridShares.Size = new System.Drawing.Size(376, 136);
			this.dataGridShares.TabIndex = 15;
			this.dataGridShares.Visible = false;
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem2});
			this.menuItem1.Text = "Help";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.Text = "About";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// DMBox
			// 
			this.DMBox.Location = new System.Drawing.Point(232, 288);
			this.DMBox.Name = "DMBox";
			this.DMBox.ReadOnly = true;
			this.DMBox.Size = new System.Drawing.Size(120, 20);
			this.DMBox.TabIndex = 11;
			this.DMBox.Text = "0";
			// 
			// ConditionLabel
			// 
			this.ConditionLabel.Location = new System.Drawing.Point(24, 24);
			this.ConditionLabel.Name = "ConditionLabel";
			this.ConditionLabel.Size = new System.Drawing.Size(104, 16);
			this.ConditionLabel.TabIndex = 1;
			this.ConditionLabel.Text = "Where Clause";
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(73, 314);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(48, 24);
			this.button1.TabIndex = 14;
			this.button1.Text = "to DM";
			this.button1.Click += new System.EventHandler(this.button1_Click_1);
			// 
			// ConditionText
			// 
			this.ConditionText.Location = new System.Drawing.Point(152, 16);
			this.ConditionText.Name = "ConditionText";
			this.ConditionText.Size = new System.Drawing.Size(248, 24);
			this.ConditionText.TabIndex = 2;
			this.ConditionText.Text = "";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.StatusLabel});
			this.groupBox1.Location = new System.Drawing.Point(0, 352);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(424, 40);
			this.groupBox1.TabIndex = 8;
			this.groupBox1.TabStop = false;
			// 
			// StatusLabel
			// 
			this.StatusLabel.Location = new System.Drawing.Point(8, 16);
			this.StatusLabel.Name = "StatusLabel";
			this.StatusLabel.Size = new System.Drawing.Size(408, 16);
			this.StatusLabel.TabIndex = 0;
			this.StatusLabel.Text = "Ready";
			// 
			// EuroBox
			// 
			this.EuroBox.Location = new System.Drawing.Point(72, 288);
			this.EuroBox.Name = "EuroBox";
			this.EuroBox.Size = new System.Drawing.Size(120, 20);
			this.EuroBox.TabIndex = 10;
			this.EuroBox.Text = "0";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(432, 398);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.dataGridShares,
																		  this.button1,
																		  this.label3,
																		  this.label2,
																		  this.DMBox,
																		  this.EuroBox,
																		  this.AsynchronousQueryButton,
																		  this.groupBox1,
																		  this.ExitButton,
																		  this.ConditionText,
																		  this.ConditionLabel,
																		  this.QueryButton});
			this.Menu = this.mainMenu1;
			this.Name = "Form1";
			this.Text = "Stock Ticker Client";
			((System.ComponentModel.ISupportInitialize)(this.dataGridShares)).EndInit();
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}



		private void button1_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show(this, "Demo Program \nWeb Services in .NET\n(c) 2001, Michael Stal", "About");
		}

		
	

		private void QueryButton_Click(object sender, System.EventArgs e)
		{
			DataSet ds = new DataSet();
			try 
			{
				StatusLabel.Text = "Connecting to Web Service ...";
				ds = WebServiceStockInfo.GetStockInfo(ConditionText.Text);
				dataGridShares.SetDataBinding(ds,"Stocks");
				this.dataGridShares.Visible = true;
				StatusLabel.Text = "Ready";
			}
			catch (Exception exc) 
			{
				StatusLabel.Text = "Command failed";
				MessageBox.Show(this, exc.Message + "\n" + exc.StackTrace, "Error calling Web Service");
			}
			
			
		}
		private void AsynchronousQueryButton_Click(object sender, System.EventArgs e) {
			DataSet ds = new DataSet();
			try {
				long counter = 0;
				StatusLabel.Text = "Connecting to Web Service asynchronously ...";
				IAsyncResult asyncResult = WebServiceStockInfo.BeginGetStockInfo(ConditionText.Text, null,null);
				while(!asyncResult.IsCompleted) { 
						counter++; 
						StatusLabel.Text = "while loops waited " + counter.ToString();
				}
				MessageBox.Show(this, "Asynchronous invocation finished", "Status");
				ds = WebServiceStockInfo.EndGetStockInfo(asyncResult);
				dataGridShares.SetDataBinding(ds,"Stocks");
				this.dataGridShares.Visible = true;
				StatusLabel.Text = "Ready";
			}		
			catch (Exception exc) 
			{
				StatusLabel.Text = "Command failed";
				MessageBox.Show(this, exc.Message + "\n" + exc.StackTrace, "Error calling Web Service");
			}		
		}


		private void button1_Click_1(object sender, System.EventArgs e)
		{
			try 
			{
				DMBox.Text = WebServiceEuroDMConverter.Euro_to_DM(double.Parse(EuroBox.Text)).ToString();
			}
			catch (Exception exc) 
			{
				MessageBox.Show(this, "EURO TO DM failed: " + exc.Message, "Error");
			}
		}

		
		
	}
}
