using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Diagnostics;
using System.Web;
using System.Web.Services;

namespace StockTicker {
	public class StockInfo : System.Web.Services.WebService {
		string src = @"Provider=SQLOLEDB.1;Integrated Security=SSPI;Persist Security Info=True;Initial Catalog=Stocks;Data Source=PENTAGON\NETSDK;Use Procedure for Prepare=1;Auto Translate=True;Packet Size=4096;Workstation ID=PENTAGON;Use Encryption for Data=False;Tag with column collation when possible=False";
		string cmd = "SELECT * FROM StockTable";
		OleDbConnection con;

		public StockInfo() {
			//CODEGEN: This call is required by the ASP.NET Web Services Designer
			InitializeComponent();
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
			con = new OleDbConnection(src); // open connection
		}
		#endregion

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing ) {
			con.Close(); // close connection
		}

		[WebMethod]
		public DataSet GetStockInfo(string condition) {
			string wherePart = "";
			if (condition == null)
				throw new ArgumentException("Null Argument");
			if (!condition.Equals(""))
				wherePart = " WHERE " + condition;
			OleDbDataAdapter da = new OleDbDataAdapter(cmd + wherePart,con);
			DataSet ds = new DataSet();
			da.Fill(ds, "Stocks");
			return ds;
		}
	}
}
