import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public aspect Aktualisierung implements ActionListener
{

// Pointcuts
	pointcut konstruktorPC(Suchmaschine sm):
		target(sm) &&
		execution(new());
	
	pointcut initPC():
		target (Suchmaschine) &&
		execution(public void init());
		
// Advice		
	after(Suchmaschine _sm) returning(): konstruktorPC(_sm)
	{
		sm = _sm;
	}

	// der Button wird samt AktionListener in die GUI eingebettet
	before(): initPC()
	{
		JButton refreshButton = new JButton("Aktualisierung");
		refreshButton.setActionCommand("Aktualisierung");
   	refreshButton.addActionListener(this);
   	sm.buttonPanel.add(refreshButton);
	}

// Javacode
	private Suchmaschine sm;

	public void actionPerformed(ActionEvent event)
   {
   	// bei Drcken des Buttons wird die erfasse()-Methode aufgerufen
   	String buttonLabel = event.getActionCommand();
    	if (buttonLabel.compareTo("Aktualisierung") == 0)
    	{
    		sm.erfasse();
    		return;
		}
	}
}