import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public aspect GUI implements ActionListener
		dominates *
{
	declare parents: Suchmaschine extends JFrame;
	declare parents: Suchmaschine implements WindowListener;

	public JPanel Suchmaschine.buttonPanel;
  	public JPanel Suchmaschine.textfieldPanel;
  	public JPanel Suchmaschine.textareaPanel;

	public final static int Suchmaschine.anzahlReihen = 20;
	public final static int Suchmaschine.anzahlSpalten = 30;
	public final static int Suchmaschine.hoeheFenster = 700;
	public final static int Suchmaschine.breiteFenster = 600;
	public final static int Suchmaschine.xAbstand = 10;
	public final static int Suchmaschine.yAbstand = 10;
	public final static int Suchmaschine.hoeheKomponente = 50;
	public int Suchmaschine.anzahlKomponenten = 1;

	// die Methoden des Interfaces WindowListener
	public void Suchmaschine.windowClosing(WindowEvent event)
	{
		System.exit(0);
	}
  	public void Suchmaschine.windowClosed(WindowEvent event)
	{
		System.exit(0);
	}
  	public void Suchmaschine.windowIconified(WindowEvent event) {}
	public void Suchmaschine.windowDeiconified(WindowEvent event) {}
	public void Suchmaschine.windowActivated(WindowEvent event) {}
	public void Suchmaschine.windowDeactivated(WindowEvent event) {}
  	public void Suchmaschine.windowOpened(WindowEvent event) {}

// Pointcuts
	pointcut konstruktorPC(Suchmaschine sm):
		target(sm) &&
		execution(new());

	pointcut initPC():
		target (Suchmaschine) &&
		execution(public void init());
			
// Advice		
	after(Suchmaschine _sm) returning(): konstruktorPC(_sm)
	{
		sm = _sm;
		sm.init();
	}

	void around(): initPC()
	{
		initJFrame();
		proceed();
	}

	after() returning(): initPC()
	{
		sm.textfieldPanel.setBounds(
				sm.xAbstand,
				sm.yAbstand,
				sm.breiteFenster - 2 * sm.yAbstand,
				sm.anzahlKomponenten * sm.yAbstand +
				sm.anzahlKomponenten * sm.hoeheKomponente );
		
		sm.buttonPanel.setBounds(
				sm.xAbstand,
				(sm.anzahlKomponenten + 1) * sm.yAbstand +
				sm.anzahlKomponenten * sm.hoeheKomponente,
				sm.breiteFenster - 2 * sm.yAbstand, sm.hoeheKomponente);
				
		sm.textareaPanel.setBounds(
				sm.xAbstand,
				(sm.anzahlKomponenten + 2) * sm.yAbstand +
				(sm.anzahlKomponenten + 1) * sm.hoeheKomponente,
				sm.breiteFenster - 2 * sm.yAbstand,
				sm.hoeheFenster -
				((sm.anzahlKomponenten + 5) * sm.yAbstand +
				(sm.anzahlKomponenten + 1) * sm.hoeheKomponente) );

		sm.setVisible(true);
	}
	
	private JTextField suchAbfrage;
	private Container contentPane;

  	private Suchmaschine sm;

   private void initJFrame()
	{
		// Definieren des JFrame
		sm.setTitle("Suchmaschine");
   	sm.setSize(sm.breiteFenster, sm.hoeheFenster);
   	sm.addWindowListener(sm);
   	sm.setResizable(false);

		java.awt.Dimension dim = sm.getToolkit().getScreenSize();
      java.awt.Rectangle abounds = sm.getBounds();
      sm.setLocation((dim.width-abounds.width)/2,(dim.height-    
      			abounds.height)/2);

   	// Erstellen des Content-Panes
		contentPane= sm.getContentPane();
	 	contentPane.setBackground(Color.lightGray);
   	contentPane.setLayout(null);

   	// Die verschiedenen Panels der Suchmaschine
   	sm.buttonPanel = new JPanel();
    	sm.textfieldPanel = new JPanel();
    	sm.textareaPanel = new JPanel();

    	// Die Layouts  der verschiedenen Panels
		sm.textfieldPanel.setLayout(null);
		sm.buttonPanel.setLayout(new GridLayout(1,0));
   	sm.textareaPanel.setLayout(new GridLayout());

		// Die Inhalte der Panels
	   	// Das Textfield-Panel
   		suchAbfrage = new JTextField();
   		suchAbfrage.setColumns(sm.anzahlSpalten);
		   JPanel queryPanel = new JPanel();
			queryPanel.setLayout(new GridLayout(0, 1));
			queryPanel.setBorder(new TitledBorder
						(new LineBorder(Color.black,1,true), "Abfrage",
						TitledBorder.LEFT, TitledBorder.TOP));
			queryPanel.setBounds(0,0,sm.breiteFenster-2*sm.yAbstand,
							sm.hoeheKomponente);
			queryPanel.add(suchAbfrage);

			sm.textfieldPanel.add(queryPanel);

	   	// Das Button-Panel
	   	JButton searchButton = new JButton("Suchen");
	   	searchButton.setActionCommand("Suchen");
			searchButton.setPreferredSize(
						new java.awt.Dimension(100,sm.hoeheKomponente/2));
	   	searchButton.addActionListener(this);

	   	JButton exitButton = new JButton("Ende");
			exitButton.setActionCommand("Ende");
			exitButton.setPreferredSize(
						new java.awt.Dimension(100, sm.hoeheKomponente/2));
   		exitButton.addActionListener(this);

   		sm.buttonPanel.add(searchButton);
   		sm.buttonPanel.add(exitButton);
			TitledBorder buttonBorder = new TitledBorder
						(new LineBorder(Color.black,1,true), "Funktionen",
						TitledBorder.LEFT, TitledBorder.TOP);
			sm.buttonPanel.setBorder(buttonBorder);

   		// Das Textarea-Panel
		   sm.textareaPanel.setBorder(new TitledBorder
		   			(new LineBorder(Color.black,1,true),
						"Suchergebnisse",
		   			TitledBorder.LEFT, TitledBorder.TOP));

   		// Einfgen der Panels in den Frame
   		contentPane.add(sm.textfieldPanel);
   		contentPane.add(sm.buttonPanel);
   		contentPane.add(sm.textareaPanel);
	}
	// ActionListener fr die 2 Buttons
	public void actionPerformed(ActionEvent event)
   {
   	String buttonLabel = event.getActionCommand();
   	if (buttonLabel.compareTo("Ende") == 0)
   	{
    		System.exit(0);
    		return;
		}
		if (buttonLabel.compareTo("Suchen") == 0)
   	{
   		String abfrage = suchAbfrage.getText();
   		suchAbfrage.setText("");

			sm.update(sm.getGraphics());
			
			sm.abfrageAusfuehren(abfrage);
    		return;
		}
	}
}