import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.JScrollPane;

public aspect PraesentationHTML
{
// Introduction
	public JTextPane Suchmaschine.suchErgebnisse;

// Pointcuts
	pointcut praesentierePC(Suchmaschine sm, Vector abfrageErgebnisse):	
		target(sm) &&
		args(abfrageErgebnisse) &&
		execution(public void praesentiere(Vector));

	pointcut initPC(Suchmaschine sm):
		target (sm) &&
		execution(public void init());

// Advices
	void around(Suchmaschine sm, Vector abfrageErgebnisse):		
		praesentierePC(sm, abfrageErgebnisse)
	{
		sm.suchErgebnisse.setText(present(abfrageErgebnisse));
		sm.suchErgebnisse.update(sm.suchErgebnisse.getGraphics());
	}
	
	before(Suchmaschine sm): initPC(sm)
	{
		// Das Textarea-Panel
		sm.textareaPanel.setPreferredSize(
											new java.awt.Dimension(330, 400));

		sm.suchErgebnisse = new JTextPane();
	   sm.suchErgebnisse.setEditable(false);
		sm.suchErgebnisse.setPreferredSize(
											new java.awt.Dimension(330, 400));
		sm.suchErgebnisse.setContentType("text/html");

		JScrollPane areaScrollPane = new JScrollPane(sm.suchErgebnisse);
		sm.textareaPanel.add(areaScrollPane);
	}

// Javacode
	private String present(Vector abfrageErgebnisse)
	{
		String result = "<html><body>\n"
			+ "<table width='100%'>\n"
			+ "<tr>\n"
			+ "<th align='left' bgcolor='#6495ED'>\n"
			+ "<font color='white'>Relevante Dokumente</font>\n"
			+ "</th>\n"
			+ "</tr>\n";

		for (int i=0; i<abfrageErgebnisse.size(); i++)
			result += "<tr>\n <td>\n"
					+ abfrageErgebnisse.get(i).toString() + "\n"
					+ "</td>\n </tr>\n";
		
		result += "</body>\n </html>\n";

		return result;
	}
}