import java.util.Vector;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;

public aspect PraesentationXML
{
// Introduction
	public JTextArea Suchmaschine.suchErgebnisse;
	
// Pointcuts
	pointcut praesentierePC(Suchmaschine sm, Vector abfrageErgebnisse):
		target(sm) &&
		args(abfrageErgebnisse) &&
		execution(public void praesentiere(Vector));
	
	pointcut initPC(Suchmaschine sm):
		target (sm) &&
		execution(public void init());
		
// Advices
	void around(Suchmaschine sm, Vector abfrageErgebnisse):
		praesentierePC(sm, abfrageErgebnisse)
	{
		sm.suchErgebnisse.setText(present(abfrageErgebnisse));
		sm.suchErgebnisse.update(sm.suchErgebnisse.getGraphics());
	}
	
	before(Suchmaschine sm): initPC(sm)
	{
		sm.suchErgebnisse = new JTextArea();
	 	sm.suchErgebnisse.setRows(sm.anzahlReihen);
	 	sm.suchErgebnisse.setColumns(sm.anzahlSpalten);
	 	sm.suchErgebnisse.setEditable(false);

		JScrollPane areaScrollPane = new JScrollPane(sm.suchErgebnisse);
		sm.textareaPanel.add(areaScrollPane);	
	}

// Javacode
	private String present(Vector abfrageErgebnisse)
	{
		String result = "<XML>\n";
		
		for (int i=0; i<abfrageErgebnisse.size(); i++)
		{
			result += "   <Dokument>\n"
				+ "      <Name>"
				+ abfrageErgebnisse.get(i).toString() 
				+ "</Name>\n"
				+ "   </Dokument>\n";
		}
		result += "</XML>\n";
		
		return result;
	}
}