#include "Funktionen.h"

//////////////////////////////////////////////////////////////////////
// Implementierung der Klasse CRFCAddServer
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CRFCAddServer::CRFCAddServer(CSTR strFuncName) : CRfcServerFunc(strFuncName)
{
	try
	{
		InitialMembers();
		CreateRFCParameters();
	}
	catch(const char* pException)
	{
		FreeMemory();
		throw pException;
	}	
}

CRFCAddServer::~CRFCAddServer()
{
	FreeMemory();
}


//////////////////////////////////////////////////////////////////////
// Implementierung der brigen Methoden
//////////////////////////////////////////////////////////////////////
void CRFCAddServer::InitialMembers(void)
{
	m_pValue1	 = NULL;
	m_pValue2	 = NULL;
	m_pResult	 = NULL;
	m_pException = NULL;    
}

void CRFCAddServer::FreeMemory(void)
{
	if(m_pValue1)    delete m_pValue1;
	if(m_pValue1)    delete m_pValue2;
	if(m_pValue1)    delete m_pResult;
	if(m_pException) delete m_pException;
	InitialMembers();
}

void CRFCAddServer::CreateRFCParameters(void)
{
	
// Parameterklassen anlegen
	m_pValue1    = new CRfcSimpleParam("VALUE1", TYPINT, sizeof(RFC_INT));
	m_pValue2    = new CRfcSimpleParam("VALUE2", TYPINT, sizeof(RFC_INT));
	m_pResult    = new CRfcSimpleParam("RESULT", TYPINT, sizeof(RFC_INT));
	m_pException = new CRfcSimpleParam("EXCEPTION", TYPC, 256);  
// Parameters dem Server hinzufgen
    AddImportParam(*m_pValue1);
    AddImportParam(*m_pValue2);
    AddExportParam(*m_pResult);
	AddExportParam(*m_pException);
}
	
void CRFCAddServer::Process()
{
	try
	{
		int Operand1 = m_pValue1->Value(),
			Operand2 = m_pValue2->Value();
		m_pResult->Value() = Operand1 + Operand2;
	}
	catch(const char* pException)
	{
		m_pException->Value() = pException;
	}
}

//////////////////////////////////////////////////////////////////////
// Implementierung der Klasse CRFCSubServer
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CRFCSubServer::CRFCSubServer(CSTR strFuncName) : CRfcServerFunc(strFuncName)
{
	try
	{
		InitialMembers();
		CreateRFCParameters();
	}
	catch(const char* pException)
	{
		FreeMemory();
		throw pException;
	}
}

CRFCSubServer::~CRFCSubServer()
{
	FreeMemory();
}

//////////////////////////////////////////////////////////////////////
// Implementierung der brigen Methoden
//////////////////////////////////////////////////////////////////////
void CRFCSubServer::InitialMembers(void)
{
	m_pValue1    = NULL;
	m_pValue2    = NULL;
	m_pResult    = NULL;
	m_pException = NULL;
}

void CRFCSubServer::FreeMemory(void)
{
	if(m_pValue1)    delete m_pValue1;
	if(m_pValue1)    delete m_pValue2;
	if(m_pValue1)    delete m_pResult;
	if(m_pException) delete m_pException;
	InitialMembers();
}

void CRFCSubServer::CreateRFCParameters(void)
{
// Parameterklassen anlegen
	m_pValue1 = new CRfcSimpleParam("VALUE1", TYPINT, sizeof(RFC_INT));
	m_pValue2 = new CRfcSimpleParam("VALUE2", TYPINT, sizeof(RFC_INT));
	m_pResult = new CRfcSimpleParam("RESULT", TYPINT, sizeof(RFC_INT));
	m_pException = new CRfcSimpleParam("EXCEPTION", TYPC, 256);  
// Parameters dem Server hinzufgen
    AddImportParam(*m_pValue1);
    AddImportParam(*m_pValue2);
    AddExportParam(*m_pResult);
	AddExportParam(*m_pException);
}
	
void CRFCSubServer::Process()
{
	try
	{
		int Operand1 = m_pValue1->Value(),
			Operand2 = m_pValue2->Value();
		m_pResult->Value() = Operand1 - Operand2;
	}
	catch(const char* pException)
	{
// Fehler bei der Berechnung an R/3 zurckmelden
		m_pException->Value() = pException;
	}
}


