Imports System.Data
Imports System.Data.OleDb
Imports System.Globalization
Imports System.IO

Module Samples_ADONET_XML

  ' === Ausgabe eines DatSet als XML
  Sub ADONET_DSXML1()
    Dim DS As System.Data.DataSet
    Dim Com As System.Data.OleDb.OleDbCommand
    Dim SQL As String

    outtitle("Ausgabe eines DatSet als XML")

    ' --- DataSet erzeugen
    DS = New System.Data.DataSet()

    ' --- Tabelle einlesen
    SQL = "SELECT * FROM Produkte where name like 'Amiga%'"
    Dim DA As System.Data.OleDb.OleDbDataAdapter
    DA = New System.Data.OleDb.OleDbDataAdapter(SQL, CONNSTRING)
    DA.Fill(DS, "EDV-Antik")

    ' --- XML ausgeben
    out("--- Schema:")
    out(DS.GetXmlSchema)
    out("--- Daten:")
    out(DS.GetXml)

  End Sub

  ' === Vernderung eines DataSets via XML
  Sub ADONET_DSXML2()
    Dim DS As System.Data.DataSet
    Dim Com As System.Data.OleDb.OleDbCommand
    Dim SQL As String

    outtitle("Vernderung eines DataSets via XML")

    ' --- DataSet erzeugen
    DS = New System.Data.DataSet()

    ' --- Tabelle einlesen
    SQL = "SELECT * FROM Produkte where name like 'Amiga%'"
    Dim DA As System.Data.OleDb.OleDbDataAdapter
    DA = New System.Data.OleDb.OleDbDataAdapter(SQL, CONNSTRING)
    DA.Fill(DS, "EDV-Antik")

    ' --- DataDocument erzeugen
    Dim DD As System.Xml.XmlDataDocument
    DD = New System.Xml.XmlDataDocument(DS)

    ' --- XML-Baum ausgeben
    out(DD.OuterXml)

    ' --- bestimmtes Element finden
    Dim XN As System.Xml.XmlNode
    XN = DD.SelectSingleNode("*//EDV-Antik[Name='Amiga 500']/Preis")

    ' --- nderungen zulassen
    DS.EnforceConstraints = False

    ' --- alten Wert auslesen
    Dim alterpreis As Double
    alterpreis = CType(XN.InnerText, Double)

    ' --- Neuen Wert ermitteln
    Dim neuerpreis As Double
    neuerpreis = alterpreis * 1.5

    ' --- Neuen Wert setzen
    XN.InnerText = neuerpreis.ToString

    ' --- Ausgabe der nderung
    out("Preis wurde von " _
    & alterpreis & "  auf " _
    & neuerpreis & "  erhht!")

    ' --- Kontrollausgabe des DataSets
    out("--- DataSet nach nderung:")
    out(DS.GetXml)

    ' --- Speicherung vorbereiten
    Dim CB As System.Data.OleDb.OleDbCommandBuilder
    CB = New OleDbCommandBuilder(DA)

    ' --- Speicherung des DataSets
    DA.Update(DS, "EDV-Antik")
    out("nderungen gespeichert!")

  End Sub

  ' === Einlesen von XML in ein DataSet
  Sub ADONET_DSXML3()

    Dim DS As New System.Data.DataSet()
    Dim fs As FileStream
    Dim sr As StreamReader
    Dim DR As DataRow
    Dim DT As DataTable
    Dim REL As DataRelation

    ' --- Datei ffnen
    fs = New FileStream("..\_DATEN\xml\hs.xml", _
    FileMode.Open, FileAccess.Read)
    ' --- Datei einlesen
    sr = New StreamReader(fs)
    ' --- Stream in DataSet einlesen
    DS.ReadXml(sr)

    ' --- Schleife ber alle Tabellen
    out("Tabellen:")
    For Each DT In DS.Tables
      out(DT.TableName)
      For Each REL In DT.ChildRelations
        out(" - " & REL.ChildTable.TableName)
      Next
    Next

    ' --- Zugriff auf einzelne Tabelle
    DT = DS.Tables("buch")
    ' --- Anzahl der Datenstze ausgeben
    out("Anzahl: " & DT.Rows.Count)

    ' --- Schleife ber alle Datenstze
    For Each DR In DT.Rows
      out(DR("Titel").ToString & " erschienen in " & DR("Jahr").ToString)
    Next

    ' --- Ausgabe in ein DataGrid
    Dim f As New FORM_Buchliste()
    f.DataGrid1.DataSource = DT
    f.Show()
  End Sub
End Module
