' !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
' Ablaufumgebung fr Beispiele aus dem Buch
' "Programmieren mit der .NET-Klassenbibliothek
' Addison-Wesley 2002
' ISBN 3-8273-1905-6
' (C) Holger@Schwichtenberg.de
' !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


Imports System.Globalization
Imports System.Threading
Imports System.Reflection


Module _main
  Const SAMPLENAME = "FCL_Buch.Samples_"
  ' ////////////////////////// Hauptprogramm

  Dim o As New _output()
  Dim liste As ArrayList
  Public stack As String

  Public Sub main()

    o.Show()
    Application.DoEvents()
    o.C_FehlerDetails.Enabled = False
    outnn("SAMPLE-VIEWER Version 1.5")
    outnn("(C) Holger@Schwichtenberg.de, http://www.IT-Visions.de/default.asp?source=ixadonet")
    outnn("")
    outnn("Auszug der Beispiele aus dem Buch")
    outnn("Holger Schwichtenberg, Frank Eller:")
    outnn("'Programmieren mit der .NET-Klassenbibliothek'")
    outnn("Addison-Wesley 2002")
    outnn("Weitere Informationen: http://www.it-visionen.de/buecher/AW1905_BCL/default.asp?P_ID=140&source=ixadonet")
    outnn("ISBN 3-8273-1905-6")
    outnn("Bitte beachten Sie, dass einige Beispiele erst nach der Anpassung an Ihre Umgebung lauffhig sind!")
    ModulListeEinlesen()
    outnn("")

    Do While Not o.ende
      Application.DoEvents()
    Loop
    End
  End Sub


  ' //////////////////////////// Selbsterforschung der Assembly

  ' ### Liste alle Module auf, die mit SAMPLENAME beginnen
  Function ModulListeEinlesen() As Int64
    Dim a As System.Reflection.Assembly
    a = a.GetExecutingAssembly
    Dim c As Int64

    Dim t As Type
    liste = New ArrayList() ' zuerst in Array zum sortieren!

    For Each t In a.GetTypes

      If t.Name.StartsWith("Samples_") And t.IsClass Then
        liste.Add(t.FullName.Replace(SAMPLENAME, ""))
        c += BeispieleCount(t.FullName.Replace(SAMPLENAME, ""))
      End If
    Next
    liste.Sort() 'sortieren
    o.C_Module.DataSource = liste
    o.C_Module.DisplayMember = "ToString"
    outnn("Anzahl Beispiele: " & c)
  End Function

  ' ### Liste alle parameterlosen Methoden in einem Modul auf
  Sub BeispieleEinlesen(ByVal typename As String)
    Dim a As System.Reflection.Assembly
    a = a.GetExecutingAssembly
    Dim t As Type = a.GetType(SAMPLENAME & typename)
    Dim m As MethodInfo


    o.C_Beispiel.Items.Clear()
    For Each m In t.GetMethods
      If m.GetParameters.Length = 0 And m.Name <> "ToString" And m.Name <> "GetType" And m.Name <> "GetHashCode" Then o.C_Beispiel.Items.Add(m.Name)
    Next

  End Sub

  ' ### Liste alle parameterlosen Methoden in einem Modul auf
  Function BeispieleCount(ByVal typename As String) As Int64
    Dim a As System.Reflection.Assembly
    a = a.GetExecutingAssembly
    Dim t As Type = a.GetType(SAMPLENAME & typename)
    Dim m As MethodInfo
    Dim c As Int64

    o.C_Beispiel.Items.Clear()
    For Each m In t.GetMethods
      If m.GetParameters.Length = 0 And m.Name <> "ToString" And m.Name <> "GetType" And m.Name <> "GetHashCode" Then c += 1
    Next
    Return c
  End Function

  ' ### Starte ein Beispiel
  Sub BeispielStarten(ByVal typename As String, ByVal methodenname As String)
    Dim a As System.Reflection.Assembly
    a = a.GetExecutingAssembly
    Dim mname As String = SAMPLENAME & typename & "." & methodenname
    o.C_FehlerDetails.Enabled = False
    Dim t As Type = a.GetType(SAMPLENAME & typename)
    Dim m As MethodInfo
    outnn("##### Beispiel: " & mname)
    Try
      t.InvokeMember(methodenname, BindingFlags.Public Or _
         BindingFlags.InvokeMethod Or BindingFlags.Static, Nothing, Nothing, _
         New Object() {})
    Catch e As TargetInvocationException
      outnn("FEHLER BEI DER AUSFHRUNG VON " & mname & ":")

      outnn("Quelle: " & e.InnerException.Source)
      outnn("Fehlertext: " & e.InnerException.Message)
      MsgBox(e.InnerException.Message, MsgBoxStyle.Critical, "Sample-Viewer: FEHLER IM AUFGERUFENEN BEISPIEL")
      stack = e.InnerException.StackTrace

      o.C_FehlerDetails.Enabled = True
    Finally
      outnn("##### ENDE DES BEISPIELS")
    End Try
  End Sub

  ' ////////////////////////// Ausgaberoutinen

  Public counter As Long
  Sub out(ByVal s As Object)
    counter += 1
    If o.F_Zeilennummern.Checked Then s = counter & vbTab & s
    outnn(s)
  End Sub

  Sub outnn(ByVal s As Object)
    Console.WriteLine(s)
    o.F_Output.Text &= s & Chr(13)
    Application.DoEvents()
  End Sub

  Sub outtitle(ByVal s As Object)
    outnn("---------------")
    outnn(s)
    counter = 0
    outnn("---------------")
  End Sub

  Sub say(ByVal s As Object)
    out(s)
  End Sub

  ' ////////////////////////// Zeitmesser

  Class _hstimer
    Public anzahl As Long
    Public summe As Double
  End Class

  Public startzeit As DateTime
  Public timername As String
  Public timers As New Hashtable()

  ' === Zeitnahme beginnen
  Public Sub ts(ByVal name As String)
    timername = name
    startzeit = DateTime.Now
  End Sub

  ' === Zeitnahme beenden
  Public Sub te()
    Dim zeit As Long
    zeit = Int(DateTime.Now.Subtract(startzeit).TotalMilliseconds)
    out(timername & ":" & zeit)

    If timers.ContainsKey(timername) Then  ' bestehender Timer
      timers.Item(timername).summe += zeit
      timers.Item(timername).anzahl += 1
    Else ' Neuer Timer
      Dim t As New _hstimer()
      t.anzahl = 1
      t.summe = zeit
      timers.Add(timername, t)
    End If
  End Sub

  ' === Zeitauswertung
  Public Sub ta()
    Dim timername As String
    out("Auswertung (Durchschnittswerte):")
    For Each timername In timers.Keys
      Dim t As _hstimer = timers(timername)
      out(timername & " = " & t.summe / t.anzahl & _
      " (" & t.anzahl & ")")
    Next
  End Sub

End Module
