// Beispielprogramm, generiert am 21.4.2002, 12:8h
 
#include <iostream>
#include <cassert>
using namespace std;
 
// Schwebende Deklarationen
 
class KontoGER;
class KontoSUI_USD;
 
// Funktionsprototypen
 
double umtauschEURnachUSD(const double& betrag);
double umtauschUSDnachCHF(const double& betrag);
double umtauschUSDnachEUR(const double& betrag);
 
// Typen
 
class KontoGER {
public:
   KontoGER():stand_(0.0) {
   }
   void stand() const {
      cout << "Der Kontostand ist " << stand_ << " EUR" << endl;
   }
   void buchen(const double& betrag) {
       stand_ += betrag;
   }
   void ueberweisenVonKontoGERNachKontoSUI_USD(KontoSUI_USD& empfaengerKonto, const double& betrag);
   void ueberweisen(KontoGER& empfaengerKonto, const double& betrag);
   void einzahlen(const double& betrag) {
      assert(betrag > 0.0);
      stand_ += betrag;
   }
private:
   double stand_;
   // Kontoinhaber entfaellt zwecks Vereinfachung
};
 
class KontoSUI_USD {
public:
   KontoSUI_USD():stand_(0.0) {
   }
   void stand() const {
      cout << "Der Kontostand ist " << stand_ << " USD" << endl;
      cout << "Dies entspricht " << umtauschUSDnachCHF(stand_) << " CHF" << endl;
   }
   void buchen(const double& betrag) {
       stand_ += betrag;
   }
   void ueberweisenVonKontoSUI_USDNachKontoGER(KontoGER& empfaengerKonto, const double& betrag);
   void einzahlenEUR(const double& betrag) {
      assert(betrag > 0.0);
      stand_ += umtauschUSDnachEUR(betrag);
   }
private:
   double stand_;
   // Kontoinhaber entfaellt zwecks Vereinfachung
};
 
int main() {
   cout << "5 EUR entsprechen " << umtauschEURnachUSD(5) << " USD" << endl;
   KontoGER k1,k3;
   KontoSUI_USD k2;
   k1.stand();
   k2.stand();
   k1.einzahlen(500.0);
   k1.stand();
   k2.einzahlenEUR(250.0);
   k2.stand();
   k1.ueberweisen(k3,50.0);
   k1.stand();
   k3.stand();
   k1.ueberweisenVonKontoGERNachKontoSUI_USD(k2,25.0);
   k1.stand();
   k2.stand();
   k2.ueberweisenVonKontoSUI_USDNachKontoGER(k1,50.0);
   k1.stand();
   k2.stand();
   return 0;
}
 
// Funktionsimplementierungen
 
double umtauschEURnachUSD(const double& betrag) {
   return betrag * 0.833;
}
 
double umtauschUSDnachCHF(const double& betrag) {
   return betrag * 1.8;
}
 
double umtauschUSDnachEUR(const double& betrag) {
   return betrag * 1.2;
}
 
void KontoGER::ueberweisenVonKontoGERNachKontoSUI_USD(KontoSUI_USD& empfaengerKonto, const double& betrag) {
   cout << "Behoerdliche Meldung: Ueberweisung von EUR "
        << betrag << " von KontoGER auf KontoSUI_USD." << endl;
   empfaengerKonto.buchen(umtauschEURnachUSD(betrag));
}
 
void KontoSUI_USD::ueberweisenVonKontoSUI_USDNachKontoGER(KontoGER& empfaengerKonto, const double& betrag) {
   cout << "Behoerdliche Meldung: Ueberweisung von USD "
        << betrag << " von KontoSUI_USD auf KontoGER." << endl;
   empfaengerKonto.buchen(umtauschUSDnachEUR(betrag));
}
 
void KontoGER::ueberweisen(KontoGER& empfaengerKonto, const double& betrag) {
   empfaengerKonto.buchen(betrag);
}
 
