/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.uddi.ProtoCallbackHandler;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.registry.Connection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionImpl
implements Connection {
    static final String QUERY_URL_PROP = "javax.xml.registry.queryManagerURL";
    static final String LIFE_CYCLE_URL_PROP = "javax.xml.registry.lifeCycleManagerURL";
    static final String SEMANTIC_EQ_PROP = "javax.xml.registry.semanticEquivalences";
    static final String AUTH_METHOD_PROP = "javax.xml.registry.security.authenticationMethod";
    static final String MAX_ROWS = "javax.xml.registry.uddi.maxRows";
    static final String POSTAL_SCHEME_PROP = "javax.xml.registry.postalAddressScheme";
    static final String HTTP_PROXY_HOST = "com.sun.xml.registry.http.proxyHost";
    static final String HTTP_PROXY_PORT = "com.sun.xml.registry.http.proxyPort";
    static final String HTTPS_PROXY_HOST = "com.sun.xml.registry.https.proxyHost";
    static final String HTTPS_PROXY_PORT = "com.sun.xml.registry.https.proxyPort";
    static final String PROXY_USER_NAME = "com.sun.xml.registry.http.proxyUserName";
    static final String PROXY_PASSWORD = "com.sun.xml.registry.http.proxyPassword";
    static final String USE_SOAP = "com.sun.xml.registry.useSOAP";
    static final String USE_CACHE = "com.sun.xml.registry.useCache";
    public static final String USER_DEF_TAXONOMIES = "com.sun.xml.registry.userTaxonomyFilenames";
    Log log = LogFactory.getLog((String)"com.sun.xml.registry");
    String connectionId;
    char[] authToken;
    private LoginContext lc;
    private Subject subject;
    private String queryManagerURLString;
    private String lifeCycleManagerURLString;
    private String semanticEquivalences;
    private String authenticationMethod;
    private String maxRows;
    private String httpProxyHost;
    private String httpProxyPort;
    private String httpsProxyHost;
    private String httpsProxyPort;
    private String proxyUserName;
    private String proxyPassword;
    private String defaultPostalAddressScheme;
    private boolean useSOAP = false;
    private boolean useCache = true;
    private RegistryServiceImpl service;
    private HashMap equivalences;
    private boolean synchronous = true;
    private Locale locale;
    boolean isClosed = false;

    ConnectionImpl() {
        this.connectionId = Utility.generateUUID();
    }

    ConnectionImpl(Properties properties) throws JAXRException {
        String string;
        this.queryManagerURLString = (String)((Hashtable)properties).get(QUERY_URL_PROP);
        this.lifeCycleManagerURLString = (String)((Hashtable)properties).get(LIFE_CYCLE_URL_PROP);
        if (this.queryManagerURLString == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Missing_connection_property_") + QUERY_URL_PROP);
        }
        if (this.lifeCycleManagerURLString == null) {
            this.log.debug((Object)"making lifeCycleUrl to queryManagerUrl");
            this.lifeCycleManagerURLString = this.queryManagerURLString;
        }
        this.semanticEquivalences = (String)((Hashtable)properties).get(SEMANTIC_EQ_PROP);
        this.authenticationMethod = (String)((Hashtable)properties).get(AUTH_METHOD_PROP);
        this.log.debug((Object)("authentication method=" + this.authenticationMethod));
        if (this.authenticationMethod != null && !this.authenticationMethod.equals("UDDI_GET_AUTHTOKEN")) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_only_supports_UDDI_GET_AUTHTOKEN_authentication"));
        }
        this.maxRows = (String)((Hashtable)properties).get(MAX_ROWS);
        this.httpProxyHost = (String)((Hashtable)properties).get(HTTP_PROXY_HOST);
        this.httpProxyPort = (String)((Hashtable)properties).get(HTTP_PROXY_PORT);
        this.httpsProxyHost = (String)((Hashtable)properties).get(HTTPS_PROXY_HOST);
        this.httpsProxyPort = (String)((Hashtable)properties).get(HTTPS_PROXY_PORT);
        this.proxyUserName = (String)((Hashtable)properties).get(PROXY_USER_NAME);
        this.proxyPassword = (String)((Hashtable)properties).get(PROXY_PASSWORD);
        if (this.httpProxyHost != null) {
            System.setProperty("http.proxyHost", this.httpProxyHost);
        }
        if (this.httpProxyPort != null) {
            System.setProperty("http.proxyPort", this.httpProxyPort);
        }
        if (this.httpsProxyHost != null) {
            System.setProperty("https.proxyHost", this.httpsProxyHost);
        }
        if (this.httpsProxyPort != null) {
            System.setProperty("https.proxyPort", this.httpsProxyPort);
        }
        this.defaultPostalAddressScheme = System.getProperty(POSTAL_SCHEME_PROP);
        this.defaultPostalAddressScheme = (String)((Hashtable)properties).get(POSTAL_SCHEME_PROP);
        String string2 = (String)((Hashtable)properties).get(USE_SOAP);
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            this.useSOAP = true;
        }
        if ((string = (String)((Hashtable)properties).get(USE_CACHE)) != null && string.equalsIgnoreCase("false")) {
            this.useCache = false;
        }
        this.subject = new Subject();
        this.service = new RegistryServiceImpl(this);
        this.connectionId = Utility.generateUUID();
    }

    public RegistryService getRegistryService() throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed) {
                if (this.service == null) {
                    this.service = new RegistryServiceImpl(this);
                }
            } else {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
            }
            RegistryServiceImpl registryServiceImpl = this.service;
            return registryServiceImpl;
        }
    }

    public void close() throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Closing UDDI connection" + this));
                }
                this.service = null;
                this.isClosed = true;
            }
        }
    }

    public boolean isClosed() {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            boolean bl = this.isClosed;
            return bl;
        }
    }

    String getQueryManagerURL() throws JAXRException {
        if (!this.isClosed) {
            return this.queryManagerURLString;
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_Closed"));
    }

    String getLifeCycleManagerURL() throws JAXRException {
        if (!this.isClosed) {
            return this.lifeCycleManagerURLString;
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
    }

    HashMap getSemanticEquivalences() {
        if (this.semanticEquivalences == null) {
            return null;
        }
        if (this.equivalences == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Parsing semantic equivalences");
            }
            String string = " ";
            String string2 = ",";
            String string3 = "urn:";
            String string4 = "|";
            StringBuffer stringBuffer = new StringBuffer();
            this.equivalences = new HashMap();
            this.log.debug((Object)this.semanticEquivalences);
            StringTokenizer stringTokenizer = new StringTokenizer(this.semanticEquivalences, string);
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            this.semanticEquivalences = stringBuffer.toString();
            this.log.debug((Object)this.semanticEquivalences);
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.semanticEquivalences, string4);
            while (stringTokenizer2.hasMoreElements()) {
                String string5 = stringTokenizer2.nextToken();
                String string6 = string5.substring(string5.indexOf(string3) + string3.length(), string5.indexOf(string2));
                String string7 = string5.substring(string5.lastIndexOf(string3) + string3.length());
                this.log.debug((Object)(string6 + "->" + string7));
                this.equivalences.put(string6, string7);
            }
        }
        return this.equivalences;
    }

    String getDefaultPostalAddressScheme() {
        return this.defaultPostalAddressScheme;
    }

    String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    String getMaxRows() {
        return this.maxRows;
    }

    public boolean isSynchronous() throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.isClosed) {
                boolean bl = this.synchronous;
                return bl;
            }
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_Closed"));
        }
    }

    public void setSynchronous(boolean bl) throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.isClosed) {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
            }
            this.synchronous = bl;
        }
    }

    Locale getLocale() throws JAXRException {
        if (!this.isClosed) {
            if (this.locale == null) {
                return Locale.getDefault();
            }
            return this.locale;
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
    }

    void setLocale(Locale locale) throws JAXRException {
        if (this.isClosed) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
        }
        this.locale = locale;
    }

    public void setCredentials(Set set) throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            Set<Object> set2 = this.subject.getPrivateCredentials();
            if (!this.isClosed) {
                if (!set2.isEmpty()) {
                    Iterator<Object> iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        set2.remove(iterator.next());
                    }
                }
            } else {
                throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
            }
            this.authToken = this.service.getUDDIMapper().getAuthorizationToken(set).toCharArray();
        }
    }

    public Set getCredentials() throws JAXRException {
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            HashSet<Object> hashSet = new HashSet<Object>();
            if (!this.isClosed) {
                Object object;
                Iterator<Object> iterator = this.subject.getPrivateCredentials().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!(object instanceof PasswordAuthentication)) continue;
                    hashSet.add(object);
                }
                object = hashSet;
                return object;
            }
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
        }
    }

    String getAuthToken() throws JAXRException {
        if (!this.isClosed) {
            return new String(this.authToken);
        }
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConnectionImpl:Connection_is_closed"));
    }

    private LoginContext getLoginContext() throws JAXRException {
        if (this.lc == null) {
            try {
                this.lc = new LoginContext("Prototype", this.subject, new ProtoCallbackHandler(this.service.getUDDIMapper()));
            }
            catch (LoginException loginException) {
                throw new JAXRException((Throwable)loginException);
            }
        }
        return this.lc;
    }

    void login() throws JAXRException {
        try {
            this.getLoginContext().login();
        }
        catch (LoginException loginException) {
            throw new JAXRException((Throwable)loginException);
        }
    }

    String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    String getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    String getProxyUserName() {
        return this.proxyUserName;
    }

    String getProxyPassword() {
        return this.proxyPassword;
    }

    boolean useSOAP() {
        return this.useSOAP;
    }

    public boolean useCache() {
        return this.useCache;
    }
}

