/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIObjectManager;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.RegistryObject;

public class UDDIObjectCache {
    private Hashtable cache = new Hashtable();
    private LinkedList list = new LinkedList();
    private UDDIObjectManager uddiManager;
    private static final int MAX_CACHE_SIZE = 150;

    UDDIObjectCache(UDDIObjectManager uDDIObjectManager) {
        this.uddiManager = uDDIObjectManager;
    }

    void addObjectToCache(RegistryObjectImpl registryObjectImpl, String string) throws JAXRException {
        if (registryObjectImpl.getServiceId() == null) {
            registryObjectImpl.setServiceId(string);
        }
        this.add(registryObjectImpl);
    }

    void addObjectsToCache(Collection collection, String string) throws JAXRException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof RegistryObjectImpl)) continue;
            RegistryObjectImpl registryObjectImpl = (RegistryObjectImpl)e;
            if (registryObjectImpl.getServiceId() == null) {
                registryObjectImpl.setServiceId(string);
            }
            if (registryObjectImpl.getServiceId() == null) {
                registryObjectImpl.setServiceId(string);
            }
            this.add(registryObjectImpl);
        }
    }

    RegistryObject fetchObjectFromCache(String string) throws JAXRException {
        return (RegistryObject)this.cache.get(string);
    }

    public void fetchObject(RegistryObjectImpl registryObjectImpl, String string) throws JAXRException {
        Object var3_3 = null;
        Object var4_4 = null;
        if (registryObjectImpl != null) {
            RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)registryObjectImpl.getRegistryService();
            if (registryServiceImpl.getConnection().useCache() && registryObjectImpl.isLoaded()) {
                return;
            }
            registryServiceImpl.getUDDIMapper().getRegistryObject(registryObjectImpl);
            if (registryServiceImpl.getConnection().useCache()) {
                this.add(registryObjectImpl);
            }
            registryObjectImpl.setStatusFlags(true, true, false);
        }
        if (registryObjectImpl != null) {
            registryObjectImpl.setStatusFlags(true, true, false);
        }
    }

    void removeObjectFromCache(String string) {
        RegistryObjectImpl registryObjectImpl;
        if (this.list.size() > 0) {
            this.list.remove(string);
        }
        if ((registryObjectImpl = (RegistryObjectImpl)this.cache.remove(string)) != null) {
            registryObjectImpl.setIsDeleted(true);
        }
    }

    private void add(RegistryObjectImpl registryObjectImpl) throws JAXRException {
        Object object;
        String string = registryObjectImpl.getKey().getId();
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.remove(string);
            this.list.addFirst(string);
        }
        if (this.cache.size() >= 150) {
            object = null;
            LinkedList linkedList2 = this.list;
            synchronized (linkedList2) {
                object = (String)this.list.removeLast();
            }
            RegistryObjectImpl registryObjectImpl2 = (RegistryObjectImpl)this.cache.remove(object);
        }
        object = this;
        synchronized (object) {
            this.cache.put(string, registryObjectImpl);
        }
    }

    public void fetchAssociations(RegistryObjectImpl registryObjectImpl, String string) throws JAXRException {
        Object object;
        Object object2;
        if (this.uddiManager == null) {
            this.uddiManager = UDDIObjectManager.getInstance();
        }
        BulkResponse bulkResponse = null;
        if (registryObjectImpl != null) {
            if (registryObjectImpl.areAssociationsLoaded()) {
                return;
            }
            object2 = registryObjectImpl.getServiceId();
            object = this.uddiManager.getService((String)object2);
            bulkResponse = ((RegistryServiceImpl)object).getUDDIMapper().findAssociations(null, registryObjectImpl.getKey().getId(), null, null);
        }
        if (bulkResponse.getExceptions() == null) {
            object2 = bulkResponse.getCollection();
            object = object2.iterator();
            while (object.hasNext()) {
                RegistryObjectImpl registryObjectImpl2 = (RegistryObjectImpl)object.next();
                this.add(registryObjectImpl2);
                registryObjectImpl2.setAssociationsLoaded(true);
            }
        }
    }

    void flushCache() {
        UDDIObjectCache uDDIObjectCache = this;
        synchronized (uDDIObjectCache) {
            this.cache.clear();
        }
    }
}

