/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.infomodel.URIValidator;

public class URIValidatorImpl
implements URIValidator,
Serializable {
    private boolean validateURI = true;

    public boolean getValidateURI() {
        return this.validateURI;
    }

    public void setValidateURI(boolean bl) {
        this.validateURI = bl;
    }

    void validate(String string) throws InvalidRequestException {
        if (!this.validateURI) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Malformed_URL_Exception:_") + string, (Throwable)malformedURLException);
        }
        if (uRL.getProtocol().equalsIgnoreCase("http")) {
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                int n = httpURLConnection.getResponseCode();
                if (n < 200 || n > 299) {
                    throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Received_response_code_") + n + ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:_for_uri_") + string);
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Make_sure_your_proxies_are_set._Received_error:_") + unknownHostException, (Throwable)unknownHostException);
            }
            catch (Exception exception) {
                throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Could_not_validate_") + string + ":" + exception, (Throwable)exception);
            }
        }
    }
}

