/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.soaprp;

import com.sun.xml.messaging.jaxm.soaprp.SOAPRPMessageFactoryImpl;
import com.sun.xml.messaging.jaxm.util.ProfileMessage;
import com.sun.xml.messaging.jaxm.util.SerializableMessage;
import com.sun.xml.messaging.jaxm.util.UUID;
import com.sun.xml.messaging.jaxm.util.UUIDFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.messaging.Endpoint;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class SOAPRPMessageImpl
extends ProfileMessage {
    private Endpoint to;
    private Endpoint from;
    private Endpoint action;
    private String MsgId;
    private String relatesTo;
    private static final String NS_URI = "http://schemas.xmlsoap.org/rp";
    private static final String NS_PREFIX = "m";
    private SOAPPart sp;
    private SOAPEnvelope envelope;
    private SOAPHeader header;
    private SOAPRPMessageFactoryImpl factory = new SOAPRPMessageFactoryImpl();
    private Vector fwdMsgPath = new Vector();
    private Vector revMsgPath = new Vector();
    private String faultCode;
    private String faultReason;
    private String faultDescription;
    static /* synthetic */ Class class$com$sun$xml$messaging$jaxm$soaprp$SOAPRPMessageFactoryImpl;

    public SOAPRPMessageImpl() throws SOAPException {
        this.newMessageId();
        this.sp = this.getSOAPPart();
        this.envelope = this.sp.getEnvelope();
        this.header = this.envelope.getHeader();
    }

    public SOAPRPMessageImpl(MimeHeaders headers, InputStream in) throws SOAPException, IOException {
        super(headers, in);
        this.fillInHeaders();
    }

    public SOAPRPMessageImpl(SOAPMessage message) throws SOAPException, IOException {
        super(message);
        this.fillInHeaders();
    }

    public Endpoint getFrom() {
        return this.getSOAPRPSender();
    }

    public Endpoint getTo() {
        return this.getSOAPRPReceiver();
    }

    public Endpoint getSOAPRPReceiver() {
        return this.to;
    }

    public Endpoint getSOAPRPSender() {
        return this.from;
    }

    public Endpoint getSOAPRPAction() {
        return this.action;
    }

    public Vector getSOAPRPFwdMessagePath() {
        return this.fwdMsgPath;
    }

    public Vector getSOAPRPRevMessagePath() {
        return this.revMsgPath;
    }

    public String getSOAPRPMessageId() {
        return this.MsgId;
    }

    public String getRelatesTo() {
        return this.relatesTo;
    }

    public void setFrom(Endpoint from) {
        this.from = from;
    }

    public void setTo(Endpoint to) {
        this.to = to;
    }

    public void setAction(Endpoint action) {
        this.action = action;
    }

    public void setRelatesTo(String id) {
        this.relatesTo = id;
    }

    public void newMessageId() {
        UUIDFactory factory = new UUIDFactory();
        UUID uuid = factory.newUUID();
        this.MsgId = uuid.toString();
    }

    public void updateFwdMessagePath(Endpoint uri, int position) {
        this.fwdMsgPath.add(position, uri);
    }

    public void updateRevMessagePath(Endpoint uri) {
        this.revMsgPath.add(0, uri);
    }

    private void fillInHeaders() {
        try {
            SOAPPart sp = this.getSOAPPart();
            SOAPEnvelope env = sp.getEnvelope();
            SOAPHeader hdr = env.getHeader();
            Object endPoint = null;
            Iterator it = hdr.getChildElements();
            Name name = null;
            while (it.hasNext()) {
                SOAPHeaderElement elem = (SOAPHeaderElement)it.next();
                name = elem.getElementName();
                if (!this.compare(name, "path")) continue;
                SOAPElement elem2 = null;
                Iterator it2 = elem.getChildElements();
                Endpoint endPoint2 = null;
                Name name2 = null;
                while (it2.hasNext()) {
                    elem2 = (SOAPElement)it2.next();
                    name2 = elem2.getElementName();
                    if (name2.getQualifiedName().equals("m:action")) {
                        this.action = endPoint2 = new Endpoint(elem2.getValue());
                    }
                    if (name2.getQualifiedName().equals("m:to")) {
                        this.to = endPoint2 = new Endpoint(elem2.getValue());
                    }
                    if (name2.getQualifiedName().equals("m:from")) {
                        this.from = endPoint2 = new Endpoint(elem2.getValue());
                    }
                    if (name2.getQualifiedName().equals("m:id")) {
                        endPoint2 = new Endpoint(elem2.getValue());
                        this.MsgId = endPoint2.toString();
                    }
                    if (name2.getQualifiedName().equals("m:relatesTo")) {
                        endPoint2 = new Endpoint(elem2.getValue());
                        this.relatesTo = endPoint2.toString();
                    }
                    if (name2.getQualifiedName().equals("m:fwd")) {
                        this.fwdMsgPath = this.getMsgPath(elem2);
                    }
                    if (name2.getQualifiedName().equals("m:rev")) {
                        this.revMsgPath = this.getMsgPath(elem2);
                    }
                    if (!name2.getQualifiedName().equals("m:fault")) continue;
                    this.getFault(elem2);
                }
            }
        }
        catch (SOAPException se) {
            se.printStackTrace();
        }
    }

    private Vector getMsgPath(SOAPElement element) {
        Iterator it = element.getChildElements();
        SOAPElement elem = null;
        Endpoint endPoint = null;
        Name name = null;
        Vector<Endpoint> path = new Vector<Endpoint>();
        while (it.hasNext()) {
            elem = (SOAPElement)it.next();
            name = elem.getElementName();
            if (!name.getQualifiedName().equals("m:via")) continue;
            endPoint = new Endpoint(elem.getValue());
            path.addElement(endPoint);
        }
        return path;
    }

    private void getFault(SOAPElement element) {
        Iterator it = element.getChildElements();
        SOAPElement elem = null;
        Name name = null;
        Vector path = new Vector();
        while (it.hasNext()) {
            String reason;
            elem = (SOAPElement)it.next();
            name = elem.getElementName();
            if (name.getQualifiedName().equals("m:code")) {
                String code;
                this.faultCode = code = elem.getValue();
            }
            if (!name.getQualifiedName().equals("m:reason")) continue;
            this.faultReason = reason = elem.getValue().toString();
        }
    }

    public synchronized void saveChanges() throws SOAPException {
        this.addHeaders();
        super.saveChanges();
    }

    public MessageFactory getMessageFactory() {
        return this.factory;
    }

    public SerializableMessage getSerializableMessage() {
        return new SerializableMessage((SOAPMessage)this, class$com$sun$xml$messaging$jaxm$soaprp$SOAPRPMessageFactoryImpl == null ? (class$com$sun$xml$messaging$jaxm$soaprp$SOAPRPMessageFactoryImpl = SOAPRPMessageImpl.class$("com.sun.xml.messaging.jaxm.soaprp.SOAPRPMessageFactoryImpl")) : class$com$sun$xml$messaging$jaxm$soaprp$SOAPRPMessageFactoryImpl);
    }

    public void addHeaders() throws SOAPException {
        SOAPElement viaElement;
        SOAPPart sp = this.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPHeader header = envelope.getHeader();
        Iterator i = header.getChildElements();
        Name name = null;
        Vector<Object> v = new Vector<Object>();
        while (i.hasNext()) {
            SOAPHeaderElement e = (SOAPHeaderElement)i.next();
            name = e.getElementName();
            if (!this.compare(name, "path")) continue;
            v.add(e);
            SOAPElement elem2 = null;
            Iterator it2 = e.getChildElements();
            Object endPoint2 = null;
            Name name2 = null;
            while (it2.hasNext()) {
                elem2 = (SOAPElement)it2.next();
                name2 = elem2.getElementName();
                if (!name2.getQualifiedName().equals("m:action") && !name2.getQualifiedName().equals("m:to") && !name2.getQualifiedName().equals("m:from") && !name2.getQualifiedName().equals("m:id") && !name2.getQualifiedName().equals("m:relatesTo") && !name2.getQualifiedName().equals("m:fwd") && !name2.getQualifiedName().equals("m:rev") && !name2.getQualifiedName().equals("m:fault")) continue;
                v.add(elem2);
            }
        }
        int j = 0;
        while (j < v.size()) {
            SOAPElement e = (SOAPElement)v.elementAt(j);
            e.detachNode();
            ++j;
        }
        SOAPHeaderElement soapRPHeader = header.addHeaderElement(envelope.createName("path", NS_PREFIX, NS_URI));
        if (this.from != null) {
            SOAPElement fromElement = soapRPHeader.addChildElement("from", NS_PREFIX);
            fromElement.addTextNode(this.from.toString());
        }
        if (this.to != null) {
            SOAPElement toElement = soapRPHeader.addChildElement("to", NS_PREFIX);
            toElement.addTextNode(this.to.toString());
        }
        if (this.action != null) {
            SOAPElement actionElement = soapRPHeader.addChildElement("action", NS_PREFIX);
            actionElement.addTextNode(this.action.toString());
        }
        if (this.MsgId != null) {
            SOAPElement MsgIdElement = soapRPHeader.addChildElement("id", NS_PREFIX);
            MsgIdElement.addTextNode(this.MsgId.toString());
        }
        if (this.relatesTo != null) {
            SOAPElement relatesToElement = soapRPHeader.addChildElement("relatesTo", NS_PREFIX);
            relatesToElement.addTextNode(this.relatesTo.toString());
        }
        if (this.faultCode != null && this.faultReason != null) {
            SOAPElement faultElement = soapRPHeader.addChildElement("fault", NS_PREFIX);
            SOAPElement faultCodeElement = faultElement.addChildElement("code", NS_PREFIX);
            faultCodeElement.addTextNode(this.faultCode.toString());
            SOAPElement faultReasonElement = faultElement.addChildElement("reason", NS_PREFIX);
            faultReasonElement.addTextNode(this.faultReason.toString());
        }
        if (this.fwdMsgPath != null) {
            SOAPElement fwdMsgPathElement = soapRPHeader.addChildElement("fwd", NS_PREFIX);
            int j2 = 0;
            while (j2 < this.fwdMsgPath.size()) {
                viaElement = fwdMsgPathElement.addChildElement("via", NS_PREFIX);
                viaElement.addTextNode(this.fwdMsgPath.elementAt(j2).toString());
                ++j2;
            }
        }
        if (this.revMsgPath != null) {
            SOAPElement revMsgPathElement = soapRPHeader.addChildElement("rev", NS_PREFIX);
            int j3 = 0;
            while (j3 < this.revMsgPath.size()) {
                viaElement = revMsgPathElement.addChildElement("via", NS_PREFIX);
                viaElement.addTextNode(this.revMsgPath.elementAt(j3).toString());
                ++j3;
            }
        }
    }

    private final boolean compare(Name got, String localName) {
        return got.getLocalName().equalsIgnoreCase(localName) && got.getURI().equalsIgnoreCase(NS_URI);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

