/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.util;

import com.sun.xml.messaging.jaxm.util.JAXMNameParser;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class JAXMContext
implements Context {
    private Hashtable myEnv;
    private Hashtable bindings = new Hashtable();
    private static NameParser myParser = new JAXMNameParser();

    public JAXMContext(Hashtable myEnv) {
        this.myEnv = myEnv;
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new JAXMContext(this.myEnv);
        }
        Object answer = this.bindings.get(name);
        if (answer == null) {
            throw new NameNotFoundException(name + " not found");
        }
        return answer;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (this.bindings.get(name) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(name, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Empty name");
        }
        this.bindings.put(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Empty name");
        }
        this.bindings.remove(name);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new JNDINames(this.bindings.keys());
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new JNDIBindings(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException("Operation not supported");
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
        this.myEnv = null;
        this.bindings = null;
    }

    class JNDIBindings
    implements NamingEnumeration {
        Enumeration names;

        JNDIBindings(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            return new Binding(name, JAXMContext.this.bindings.get(name));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }

    class JNDINames
    implements NamingEnumeration {
        Enumeration names;

        JNDINames(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            String className = JAXMContext.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }
}

