/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.util;

import com.sun.xml.messaging.jaxm.client.remote.ProviderConnectionFactoryImpl;
import com.sun.xml.messaging.jaxm.config.client.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIHelper {
    private Context jndiCtxt = null;
    private String clientConfPath = null;
    private String jndiConfigPath = "jndi.properties";
    private static final Log logger = LogFactory.getFactory().getInstance("JNDIHelper");

    public JNDIHelper() {
    }

    public JNDIHelper(String jndiConfigPath) {
        this.jndiConfigPath = jndiConfigPath;
    }

    public JNDIHelper(String jndiConfigPath, String clientConfPath) {
        this.jndiConfigPath = jndiConfigPath;
        this.clientConfPath = clientConfPath;
    }

    public Context InitialContext() throws SOAPException {
        this.setInitialContext();
        try {
            this.jndiCtxt = new InitialContext();
            if (this.clientConfPath == null) {
                this.clientConfPath = System.getProperties().getProperty("jaxm.clientConfPath");
            }
            if (this.clientConfPath == null) {
                System.err.println("Please set jaxm.clientConfPath in System properties OR in your jndi.properties file to client.xml path OR use JNDIHelper c'tor that takes the client.xml file path as argument");
                throw new SOAPException("JNDI client Conf Path not set");
            }
            FileInputStream fis = new FileInputStream(this.clientConfPath);
            Config config = new Config(fis);
            ProviderConnectionFactoryImpl connectionFactory = new ProviderConnectionFactoryImpl();
            config.configure(connectionFactory);
            this.jndiCtxt.bind(connectionFactory.getProviderURI(), (Object)connectionFactory);
        }
        catch (NamingException e) {
            throw new SOAPException("Unable to create new InitialContext");
        }
        catch (IOException ioe) {
            throw new SOAPException("Unable to create new InitialContext");
        }
        return this.jndiCtxt;
    }

    public void setInitialContext() {
        logger.info((Object)("Using \"" + this.jndiConfigPath + "\" as the JNDI resources file"));
        Properties sysProps = System.getProperties();
        boolean createFactory = ((Hashtable)sysProps).get("java.naming.factory.initial") == null;
        Properties props = new Properties();
        File f = new File(this.jndiConfigPath);
        if (f.exists()) {
            try {
                props.load(new FileInputStream(this.jndiConfigPath));
            }
            catch (IOException e) {
                logger.info((Object)("Error while loading" + this.jndiConfigPath));
                logger.info((Object)e.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            props.setProperty("java.naming.factory.initial", "com.sun.xml.messaging.client.local.JAXMContextFactory");
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            if (prop.equals("jndi.initial.naming.factory") && !createFactory) continue;
            sysProps.setProperty(prop, props.getProperty(prop));
        }
    }
}

