/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.client.dii.OperationInfo;
import com.sun.xml.rpc.client.dii.PortInfo;
import com.sun.xml.rpc.client.dii.ServiceInfo;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.util.ClientProcessorEnvironment;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

public class ServiceInfoBuilder {
    protected WSDLModelInfo modelInfo;
    protected QName serviceName;
    static /* synthetic */ Class class$javax$xml$soap$SOAPMessage;

    public ServiceInfoBuilder(String wsdlLocation, QName serviceName) {
        ClientProcessorEnvironment env = new ClientProcessorEnvironment(new ByteArrayOutputStream(), "", null);
        Configuration config = new Configuration(env);
        this.modelInfo = new WSDLModelInfo();
        config.setModelInfo(this.modelInfo);
        this.modelInfo.setParent(config);
        this.modelInfo.setLocation(wsdlLocation);
        this.serviceName = serviceName;
        this.modelInfo.setName(serviceName.getLocalPart());
    }

    public void setPackage(String packageName) {
        this.modelInfo.setJavaPackageName(packageName);
    }

    public ServiceInfo buildServiceInfo() {
        Model wsdlModel = this.getModel();
        Service serviceModel = wsdlModel.getServiceByName(this.serviceName);
        if (serviceModel == null) {
            String knownServiceNames = "";
            Iterator eachService = wsdlModel.getServices();
            while (eachService.hasNext()) {
                Service service = (Service)eachService.next();
                knownServiceNames = knownServiceNames + service.getName().toString();
                if (!eachService.hasNext()) continue;
                knownServiceNames = knownServiceNames + "\n";
            }
            throw new DynamicInvocationException("dii.wsdl.service.unknown", new Object[]{this.serviceName, knownServiceNames});
        }
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setDefaultNamespace(wsdlModel.getTargetNamespaceURI());
        Iterator eachPort = serviceModel.getPorts();
        while (eachPort.hasNext()) {
            Port portModel = (Port)eachPort.next();
            PortInfo portInfo = serviceInfo.getPortInfo((QName)portModel.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName"));
            portInfo.setPortTypeName((QName)portModel.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName"));
            this.buildPortInfo(portInfo, portModel);
        }
        return serviceInfo;
    }

    protected Model getModel() {
        Properties options = new Properties();
        ((Hashtable)options).put("validationWSDL", new Boolean(false));
        ((Hashtable)options).put("explicitServiceContext", new Boolean(false));
        return this.modelInfo.buildModel(options);
    }

    protected void buildPortInfo(PortInfo portInfo, Port portModel) {
        portInfo.setTargetEndpoint(portModel.getAddress());
        Iterator eachOperation = portModel.getOperations();
        while (eachOperation.hasNext()) {
            Operation operationModel = (Operation)eachOperation.next();
            OperationInfo operationInfo = portInfo.createOperationForName(operationModel.getName().getLocalPart());
            this.buildOperationInfo(operationInfo, operationModel);
        }
    }

    protected void buildOperationInfo(OperationInfo operationInfo, Operation operationModel) {
        if (operationModel.getStyle() == SOAPStyle.DOCUMENT) {
            this.buildDocumentOperation(operationInfo, operationModel);
        } else {
            this.buildRpcOperation(operationInfo, operationModel);
        }
    }

    protected void buildRpcOperation(OperationInfo operationInfo, Operation operationModel) {
        SOAPStructureMember currentWsdlParameter;
        Parameter currentParameter;
        JavaMethod methodModel = operationModel.getJavaMethod();
        Request requestModel = operationModel.getRequest();
        Response responseModel = operationModel.getResponse();
        Block requestWsdlModel = (Block)requestModel.getBodyBlocks().next();
        Block responseWsdlModel = (Block)responseModel.getBodyBlocks().next();
        RPCRequestUnorderedStructureType requestType = (RPCRequestUnorderedStructureType)requestWsdlModel.getType();
        RPCResponseStructureType responseType = (RPCResponseStructureType)responseWsdlModel.getType();
        Iterator eachRequestParameter = requestModel.getParameters();
        Iterator eachResponseParameter = responseModel.getParameters();
        Iterator eachRequestWsdlParameter = requestType.getMembers();
        Iterator eachResponseWsdlParameter = responseType.getMembers();
        JavaType returnJavaTypeModel = methodModel.getReturnType();
        if (!"void".equals(returnJavaTypeModel.getName())) {
            Parameter returnParameter = (Parameter)eachResponseParameter.next();
            SOAPStructureMember returnWsdlParameter = (SOAPStructureMember)eachResponseWsdlParameter.next();
            QName returnXmlType = returnParameter.getType().getName();
            Class returnJavaType = this.getJavaClassFor(returnParameter.getType());
            operationInfo.setReturnType(returnXmlType, returnJavaType);
        }
        while (eachRequestParameter.hasNext()) {
            currentParameter = (Parameter)eachRequestParameter.next();
            currentWsdlParameter = (SOAPStructureMember)eachRequestWsdlParameter.next();
            ParameterMode mode = ParameterMode.IN;
            if (currentParameter.getLinkedParameter() != null) {
                mode = ParameterMode.INOUT;
            }
            this.addParameterTo(operationInfo, currentWsdlParameter, mode);
        }
        while (eachResponseParameter.hasNext()) {
            currentParameter = (Parameter)eachResponseParameter.next();
            currentWsdlParameter = (SOAPStructureMember)eachResponseWsdlParameter.next();
            if (currentParameter.getLinkedParameter() != null) continue;
            this.addParameterTo(operationInfo, currentWsdlParameter, ParameterMode.OUT);
        }
        operationInfo.setProperty("javax.xml.rpc.soap.operation.style", "rpc");
        operationInfo.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", "http://schemas.xmlsoap.org/soap/encoding/");
    }

    protected void buildDocumentOperation(OperationInfo operationInfo, Operation operationModel) {
        JavaMethod methodModel = operationModel.getJavaMethod();
        Request requestModel = operationModel.getRequest();
        Response responseModel = operationModel.getResponse();
        Block requestWsdlModel = (Block)requestModel.getBodyBlocks().next();
        Block responseWsdlModel = (Block)responseModel.getBodyBlocks().next();
        operationInfo.addParameter(requestWsdlModel.getName().getLocalPart(), requestWsdlModel.getType().getName(), class$javax$xml$soap$SOAPMessage == null ? (class$javax$xml$soap$SOAPMessage = ServiceInfoBuilder.class$("javax.xml.soap.SOAPMessage")) : class$javax$xml$soap$SOAPMessage, ParameterMode.IN);
        operationInfo.setReturnType(responseWsdlModel.getType().getName(), class$javax$xml$soap$SOAPMessage == null ? (class$javax$xml$soap$SOAPMessage = ServiceInfoBuilder.class$("javax.xml.soap.SOAPMessage")) : class$javax$xml$soap$SOAPMessage);
        operationInfo.setProperty("javax.xml.rpc.soap.operation.style", "document");
        operationInfo.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", "");
    }

    protected void addParameterTo(OperationInfo operationInfo, SOAPStructureMember currentParameter, ParameterMode mode) {
        String parameterName = currentParameter.getName().getLocalPart();
        QName parameterXmlType = currentParameter.getType().getName();
        Class parameterJavaType = this.getJavaClassFor(currentParameter.getType());
        operationInfo.addParameter(parameterName, parameterXmlType, parameterJavaType, mode);
    }

    protected Class getJavaClassFor(AbstractType parameterType) {
        JavaType javaType = parameterType.getJavaType();
        String parameterJavaTypeName = javaType.getRealName();
        Class<?> parameterJavaType = null;
        try {
            parameterJavaType = Class.forName(parameterJavaTypeName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return parameterJavaType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

