/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import javax.xml.namespace.QName;

public class DynamicSerializer
extends SerializerBase
implements SchemaConstants,
Initializable {
    InternalTypeMappingRegistry registry = null;

    public DynamicSerializer(QName xmlType, boolean encodeType, boolean isNullable, String encodingStyle) {
        super(xmlType, encodeType, isNullable, encodingStyle);
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.registry = registry;
    }

    public void serialize(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        if (obj == null) {
            this.serializeNull(name, writer);
            return;
        }
        JAXRPCSerializer serializer = this.getSerializerForObject(obj);
        if (serializer != null) {
            serializer.serialize(obj, name, callback, writer, context);
        }
    }

    protected JAXRPCSerializer getSerializerForObject(Object obj) {
        JAXRPCSerializer serializer = null;
        try {
            serializer = (JAXRPCSerializer)this.registry.getSerializer("http://schemas.xmlsoap.org/soap/encoding/", obj.getClass());
            if (serializer instanceof DynamicSerializer) {
                throw new SerializationException("typemapping.serializer.is.dynamic", new Object[]{obj.getClass()});
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
        }
        return serializer;
    }

    protected void serializeNull(QName name, XMLWriter writer) {
        try {
            writer.startElement(name != null ? name : SchemaConstants.QNAME_ANY);
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttribute(XSDConstants.QNAME_XSI_TYPE, attrVal);
            writer.writeAttribute(XSDConstants.QNAME_XSI_NIL, "1");
            writer.endElement();
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException("nestedSerializationError", e);
        }
    }

    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        try {
            JAXRPCDeserializer deserializer = this.getDeserializerForElement(reader, context);
            if (deserializer == null) {
                return null;
            }
            return deserializer.deserialize(name, reader, context);
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException("nestedDeserializationError", new LocalizableExceptionAdapter(e));
        }
    }

    protected JAXRPCDeserializer getDeserializerForElement(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        if (SerializerBase.getNullStatus(reader)) {
            this.skipEmptyContent(reader);
            return null;
        }
        QName objectXMLType = SerializerBase.getType(reader);
        return (JAXRPCDeserializer)this.registry.getDeserializer("http://schemas.xmlsoap.org/soap/encoding/", objectXMLType);
    }
}

