/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public abstract class InterfaceSerializerBase
extends SerializerBase {
    protected InterfaceSerializerBase(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        super(type, encodeType, isNullable, encodingStyle);
    }

    protected abstract Object doDeserialize(QName var1, XMLReader var2, SOAPDeserializationContext var3) throws Exception;

    protected abstract void doSerializeInstance(Object var1, QName var2, SerializerCallback var3, XMLWriter var4, SOAPSerializationContext var5) throws Exception;

    public void serialize(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        try {
            if (obj == null) {
                if (!this.isNullable) {
                    throw new SerializationException("soap.unexpectedNull");
                }
                this.serializeNull(name, writer, context);
            } else {
                this.doSerializeInstance(obj, name, callback, writer, context);
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException(e);
        }
        catch (Exception e) {
            throw new SerializationException(new LocalizableExceptionAdapter(e));
        }
    }

    protected void serializeNull(QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        writer.startElement(name != null ? name : this.type);
        boolean pushedEncodingStyle = false;
        if (this.encodingStyle != null) {
            pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
        }
        if (this.encodeType) {
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttribute(XSDConstants.QNAME_XSI_TYPE, attrVal);
        }
        writer.writeAttribute(XSDConstants.QNAME_XSI_NIL, "1");
        writer.endElement();
        if (pushedEncodingStyle) {
            context.popEncodingStyle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        SOAPDeserializationState state;
        boolean pushedEncodingStyle = false;
        try {
            try {
                boolean isNull = SerializerBase.getNullStatus(reader);
                if (!isNull) {
                    Object object = this.doDeserialize(name, reader, context);
                    Object var9_10 = null;
                    if (!pushedEncodingStyle) return object;
                    context.popEncodingStyle();
                    return object;
                }
                if (!this.isNullable) {
                    throw new DeserializationException("soap.unexpectedNull");
                }
                String id = this.getID(reader);
                this.skipEmptyContent(reader);
                if (id != null) {
                    state = context.getStateFor(id);
                    state.setDeserializer(this);
                    state.setInstance(null);
                    state.doneReading();
                }
                state = null;
            }
            catch (DeserializationException e) {
                throw e;
            }
            catch (JAXRPCExceptionBase e) {
                throw new DeserializationException(e);
            }
            catch (Exception e) {
                throw new DeserializationException(new LocalizableExceptionAdapter(e));
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!pushedEncodingStyle) throw throwable;
            context.popEncodingStyle();
            throw throwable;
        }
        Object var9_11 = null;
        if (!pushedEncodingStyle) return state;
        context.popEncodingStyle();
        return state;
    }
}

