/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.soap.SOAPMessage;

public class SOAPDeserializationContext {
    protected Stack encodingStyleContext = new Stack();
    protected String curEncodingStyle = null;
    protected boolean isSOAPEncodingStyle = false;
    protected List encodingStyleURIs = null;
    protected SOAPMessage message;
    protected Map stateIds = new HashMap();

    public SOAPDeserializationContext() {
        this.pushEncodingStyle("");
    }

    public SOAPDeserializationState getStateFor(String id) {
        if (id == null) {
            return null;
        }
        SOAPDeserializationState elementState = (SOAPDeserializationState)this.stateIds.get(id);
        if (elementState == null) {
            elementState = new SOAPDeserializationState();
            this.stateIds.put(id, elementState);
        }
        return elementState;
    }

    public void deserializeMultiRefObjects(XMLReader reader) {
        try {
            while (reader.nextElementContent() == 1) {
                String id = reader.getAttributes().getValue("", "id");
                if (id == null) {
                    throw new DeserializationException("soap.missingTrailingBlockID");
                }
                SOAPDeserializationState elementState = this.getStateFor(id);
                elementState.deserialize(null, reader, this);
            }
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public void doneDeserializing() {
        Iterator iter = this.stateIds.values().iterator();
        while (iter.hasNext()) {
            SOAPDeserializationState state = (SOAPDeserializationState)iter.next();
            state.promoteToCompleteOrFail();
        }
    }

    public void setMessage(SOAPMessage m) {
        this.message = m;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public void pushEncodingStyle(String newEncodingStyle) {
        this.encodingStyleContext.push(newEncodingStyle);
        this.initEncodingStyleInfo();
    }

    public void popEncodingStyle() {
        this.encodingStyleContext.pop();
        this.initEncodingStyleInfo();
    }

    public String getEncodingStyle() {
        return this.curEncodingStyle;
    }

    public boolean processEncodingStyle(XMLReader reader) throws Exception {
        Attributes attrs = reader.getAttributes();
        String newEncodingStyle = attrs.getValue("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        if (newEncodingStyle == null) {
            return false;
        }
        this.pushEncodingStyle(newEncodingStyle);
        return true;
    }

    public void verifyEncodingStyle(String expectedEncodingStyle) {
        if (expectedEncodingStyle == null) {
            return;
        }
        if (expectedEncodingStyle == "http://schemas.xmlsoap.org/soap/encoding/" || expectedEncodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            if (this.isSOAPEncodingStyle) {
                return;
            }
        } else if (this.encodingStyleURIs == null) {
            if (this.curEncodingStyle.startsWith(expectedEncodingStyle)) {
                return;
            }
        } else {
            int i = 0;
            while (i < this.encodingStyleURIs.size()) {
                String uri = (String)this.encodingStyleURIs.get(i);
                if (uri.startsWith(expectedEncodingStyle)) {
                    return;
                }
                ++i;
            }
        }
        throw new DeserializationException("soap.unexpectedEncodingStyle", new Object[]{expectedEncodingStyle, this.curEncodingStyle});
    }

    private void initEncodingStyleInfo() {
        this.curEncodingStyle = (String)this.encodingStyleContext.peek();
        if (this.curEncodingStyle.indexOf(32) == -1) {
            this.encodingStyleURIs = null;
            this.isSOAPEncodingStyle = this.curEncodingStyle.startsWith("http://schemas.xmlsoap.org/soap/encoding/");
        } else {
            this.encodingStyleURIs = XmlUtil.parseTokenList(this.curEncodingStyle);
            this.isSOAPEncodingStyle = false;
            int i = 0;
            while (i < this.encodingStyleURIs.size()) {
                String uri = (String)this.encodingStyleURIs.get(i);
                if (uri.startsWith("http://schemas.xmlsoap.org/soap/encoding/")) {
                    this.isSOAPEncodingStyle = true;
                    break;
                }
                ++i;
            }
        }
    }
}

