/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.literal.LiteralObjectSerializerBase;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public class DetailFragmentDeserializer
extends LiteralObjectSerializerBase {
    protected SOAPFactory soapFactory;
    private static final String FIRST_PREFIX = "ns";

    public DetailFragmentDeserializer(QName type, String encodingStyle) {
        super(type, false, encodingStyle);
        try {
            this.soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    protected void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    protected Object internalDeserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        boolean pushedEncodingStyle = context.processEncodingStyle(reader);
        try {
            QName actualName;
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null && !(actualName = reader.getName()).equals(name)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
            }
            Attributes attrs = reader.getAttributes();
            String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
            Object obj = null;
            if (isNull) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
                reader.next();
            } else {
                obj = this.doDeserialize(reader, context);
            }
            XMLReaderUtil.verifyReaderState(reader, 2);
            Object object = obj;
            Object var11_10 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
            return object;
        }
        catch (Throwable throwable) {
            block7: {
                Object var11_11 = null;
                if (!pushedEncodingStyle) break block7;
                context.popEncodingStyle();
            }
            throw throwable;
        }
    }

    protected Object deserializeElement(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        boolean pushedEncodingStyle = context.processEncodingStyle(reader);
        try {
            QName actualName;
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null && !(actualName = reader.getName()).equals(name)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
            }
            Attributes attrs = reader.getAttributes();
            String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
            Object obj = null;
            if (isNull) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
                reader.next();
            } else {
                obj = this.doDeserializeElement(reader, context);
            }
            XMLReaderUtil.verifyReaderState(reader, 2);
            Object object = obj;
            Object var11_10 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
            return object;
        }
        catch (Throwable throwable) {
            block7: {
                Object var11_11 = null;
                if (!pushedEncodingStyle) break block7;
                context.popEncodingStyle();
            }
            throw throwable;
        }
    }

    protected Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Detail detail = this.soapFactory.createDetail();
        SOAPElement child = (SOAPElement)this.doDeserializeElement(reader, context);
        detail.addChildElement(child);
        return detail;
    }

    protected Object doDeserializeElement(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        String elementURI = reader.getURI();
        SOAPElement element = elementURI == null || elementURI.equals("") ? this.soapFactory.createElement(reader.getLocalName()) : this.soapFactory.createElement(reader.getLocalName(), FIRST_PREFIX, reader.getURI());
        String defaultURI = reader.getURI("");
        if (defaultURI != null) {
            element.addNamespaceDeclaration("", defaultURI);
        }
        Iterator iter = reader.getPrefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = reader.getURI(prefix);
            element.addNamespaceDeclaration(prefix, uri);
        }
        Attributes attributes = reader.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            if (!attributes.isNamespaceDeclaration(i)) {
                Name name;
                String uri = attributes.getURI(i);
                if (uri == null) {
                    name = this.soapFactory.createName(attributes.getLocalName(i));
                } else {
                    String prefix = attributes.getPrefix(i);
                    name = this.soapFactory.createName(attributes.getLocalName(i), prefix, uri);
                }
                element.addAttribute(name, attributes.getValue(i));
            }
            ++i;
        }
        reader.next();
        while (reader.getState() != 2) {
            int state = reader.getState();
            if (state == 1) {
                SOAPElement child = (SOAPElement)this.deserializeElement(null, reader, context);
                element.addChildElement(child);
            } else if (state == 3) {
                element.addTextNode(reader.getValue());
            }
            reader.next();
        }
        return element;
    }

    protected void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    protected void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }
}

