/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class XSDDateTimeDateEncoder
implements SimpleTypeEncoder {
    private static final SimpleTypeEncoder encoder = new XSDDateTimeDateEncoder();
    protected static final SimpleDateFormat timeZoneFormatter = new SimpleDateFormat("HH:mm");
    protected static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    protected XSDDateTimeDateEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            String string = dateFormatter.format((Date)obj);
            return string;
        }
    }

    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        return XSDDateTimeDateEncoder.decodeDateUtil(str, null);
    }

    public static void validateDateStr(String dateStr) throws Exception {
        if (dateStr.length() < 19) {
            throw new DeserializationException("xsd.invalid.date", dateStr);
        }
    }

    protected static String getDateFormatPattern(String xsdDateTime) {
        String formatPattern = "yyyy";
        int idx = xsdDateTime.indexOf(45, 4);
        int i = 4;
        while (i < idx) {
            formatPattern = formatPattern + "y";
            ++i;
        }
        formatPattern = formatPattern + "-MM-dd'T'HH:mm:ss";
        int i2 = idx = xsdDateTime.indexOf(46);
        while (i2 < xsdDateTime.length() - 1 && i2 < idx + 3) {
            if (!Character.isDigit(xsdDateTime.charAt(i2 + 1))) break;
            if (i2 == idx) {
                formatPattern = formatPattern + ".";
            }
            formatPattern = formatPattern + "S";
            ++i2;
        }
        return formatPattern;
    }

    protected static Date decodeDateUtil(String str, StringBuffer zone) throws Exception {
        if (str == null) {
            return null;
        }
        str = EncoderUtils.collapseWhitespace(str);
        XSDDateTimeDateEncoder.validateDateStr(str);
        StringBuffer strBuf = new StringBuffer(30);
        int dateLen = XSDDateTimeDateEncoder.getDateFormatPattern(str, strBuf);
        String pattern = strBuf.toString();
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(gmtTimeZone);
        String tmp = str.substring(0, dateLen);
        Date date = df.parse(str.substring(0, dateLen));
        if (dateLen < str.length()) {
            int start = dateLen;
            if (Character.isDigit(str.charAt(start))) {
                int end = start;
                while (end < str.length() && Character.isDigit(str.charAt(end))) {
                    ++end;
                }
                String tmp2 = str.substring(start, start + 1);
                int fractmilli = Integer.parseInt(str.substring(start, start + 1));
                if (fractmilli >= 5) {
                    date.setTime(date.getTime() + 1L);
                }
                start = end;
            }
            if (start < str.length() && str.charAt(start) != 'Z') {
                if (zone != null) {
                    zone.append(str.substring(start));
                }
                SimpleDateFormat simpleDateFormat = timeZoneFormatter;
                synchronized (simpleDateFormat) {
                    tmp = str.substring(start + 1);
                    Date tzOffset = timeZoneFormatter.parse(str.substring(start + 1));
                    long millis = str.charAt(start) == '+' ? -tzOffset.getTime() : tzOffset.getTime();
                    date.setTime(date.getTime() + millis);
                }
            }
        }
        return date;
    }

    protected static int getDateFormatPattern(String dateStr, StringBuffer strBuf) {
        String formatPattern = "yyyy";
        strBuf.append(formatPattern);
        int idx = dateStr.indexOf(45, 4);
        int i = 4;
        while (i < idx) {
            strBuf.append('y');
            ++i;
        }
        strBuf.append("-MM-dd'T'HH:mm:ss");
        int i2 = idx = dateStr.indexOf(46);
        while (idx > 0 && i2 < dateStr.length() - 1 && i2 < idx + 3) {
            if (!Character.isDigit(dateStr.charAt(i2 + 1))) break;
            if (i2 == idx) {
                strBuf.append('.');
            }
            strBuf.append('S');
            ++i2;
        }
        return strBuf.length() - 2;
    }

    public void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    static {
        dateFormatter.setTimeZone(gmtTimeZone);
        timeZoneFormatter.setTimeZone(gmtTimeZone);
    }
}

