/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CustomClassGenerator
extends GeneratorBase {
    private Set types;

    public CustomClassGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new CustomClassGenerator(model, config, properties);
    }

    private CustomClassGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void visitFault(Fault fault) throws Exception {
        JavaException exception = fault.getJavaException();
        Iterator members = exception.getMembers();
        while (members.hasNext()) {
            SOAPType type = ((SOAPStructureMember)((JavaStructureMember)members.next()).getOwner()).getType();
            type.accept(this);
        }
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    public void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (!type.getJavaType().isPresent()) {
            this.generateJavaClass(type);
        }
    }

    public void preVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (!type.getJavaType().isPresent()) {
            this.generateJavaClass(type);
        }
    }

    public void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        if (!type.getJavaType().isPresent()) {
            this.generateJavaClass(type);
        }
    }

    private boolean isRegistered(AbstractType type) {
        return this.types.contains(type);
    }

    private void registerType(AbstractType type) {
        this.types.add(type);
    }

    private void generateJavaClass(SOAPStructureType type) {
        if (type.getJavaType() instanceof JavaException) {
            return;
        }
        this.log("generating JavaClass for: " + type.getName().getLocalPart());
        try {
            JavaType javaType;
            JavaStructureMember member;
            String className = this.env.getNames().customJavaTypeClassName(type);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            out.pln();
            JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
            this.writeClassDecl(out, className, javaStructure);
            Iterator members = javaStructure.getMembers();
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                if (member.isInherited() && javaStructure.getSuperclass() != null) continue;
                javaType = member.getType();
                String typeName = member.getType().getRealName();
                if (member.isPublic()) {
                    out.pln("public " + typeName + " " + member.getName() + ";");
                    continue;
                }
                out.pln("private " + typeName + " " + member.getName() + ";");
            }
            out.pln();
            this.writeClassConstructor(out, className, javaStructure);
            members = javaStructure.getMembers();
            while (members.hasNext()) {
                out.pln();
                member = (JavaStructureMember)members.next();
                javaType = member.getType();
                out.plnI("public " + member.getType().getRealName() + " get" + StringUtils.capitalize(member.getName()) + "() {");
                out.pln("return " + member.getName() + ";");
                out.pOln("}");
                out.pln();
                out.plnI("public void set" + StringUtils.capitalize(member.getName()) + "(" + member.getType().getRealName() + " " + member.getName() + ") {");
                out.pln("this." + member.getName() + " = " + member.getName() + ";");
                out.pOln("}");
            }
            out.pOln("}");
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void generateJavaClass(LiteralStructuredType type) {
        this.log("generating JavaClass for: " + type.getName().getLocalPart());
        try {
            JavaType javaType;
            JavaStructureMember member;
            String className = this.env.getNames().customJavaTypeClassName(type);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            out.pln();
            JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
            this.writeClassDecl(out, className, javaStructure);
            Iterator members = javaStructure.getMembers();
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                javaType = member.getType();
                String typeName = member.getType().getRealName();
                if (member.isPublic()) {
                    out.pln("public " + typeName + " " + member.getName() + ";");
                    continue;
                }
                out.pln("private " + typeName + " " + member.getName() + ";");
            }
            out.pln();
            this.writeClassConstructor(out, className, javaStructure);
            members = javaStructure.getMembers();
            while (members.hasNext()) {
                out.pln();
                member = (JavaStructureMember)members.next();
                javaType = member.getType();
                out.plnI("public " + member.getType().getRealName() + " get" + StringUtils.capitalize(member.getName()) + "() {");
                out.pln("return " + member.getName() + ";");
                out.pOln("}");
                out.pln();
                out.plnI("public void set" + StringUtils.capitalize(member.getName()) + "(" + member.getType().getRealName() + " " + member.getName() + ") {");
                out.pln("this." + member.getName() + " = " + member.getName() + ";");
                out.pOln("}");
            }
            out.pOln("}");
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void writeClassDecl(IndentingWriter p, String className, JavaStructureType javaStruct) throws IOException {
        JavaStructureType superclass = javaStruct.getSuperclass();
        if (superclass != null) {
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" extends ").append(superclass.getRealName()).append(" {").toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" {").toString());
        }
    }

    private void writeClassConstructor(IndentingWriter p, String className, JavaStructureType javaStructure) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.pln(stringBuffer.append(Names.mangleClass(className)).append("() {").toString());
        p.pln("}");
        Iterator members = javaStructure.getMembers();
        if (members.hasNext()) {
            JavaType javaType;
            JavaStructureMember member;
            p.pln();
            StringBuffer stringBuffer2 = new StringBuffer().append("public ");
            this.env.getNames();
            p.p(stringBuffer2.append(Names.mangleClass(className)).append("(").toString());
            int i = 0;
            while (members.hasNext()) {
                if (i != 0) {
                    p.p(", ");
                }
                member = (JavaStructureMember)members.next();
                javaType = member.getType();
                p.p(member.getType().getRealName() + " " + member.getName());
                ++i;
            }
            p.plnI(") {");
            members = javaStructure.getMembers();
            int i2 = 0;
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                javaType = member.getType();
                p.pln("this." + member.getName() + " = " + member.getName() + ";");
                ++i2;
            }
            p.pOln("}");
        }
    }
}

