/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.LiteralEncoding;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class LiteralObjectSerializerGenerator
extends GeneratorBase {
    private Set visitedTypes;

    public LiteralObjectSerializerGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new LiteralObjectSerializerGenerator(model, config, properties);
    }

    private LiteralObjectSerializerGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.visitedTypes = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.visitedTypes = null;
    }

    protected void preVisitLiteralSimpleType(LiteralSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        Iterator attributes = type.getAttributeMembers();
        while (attributes.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)attributes.next();
            attribute.getType().accept(this);
        }
        Iterator elements = type.getElementMembers();
        while (elements.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)elements.next();
            element.getType().accept(this);
        }
        try {
            this.generateObjectSerializerForType(type);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", type.getName().getLocalPart());
        }
    }

    protected void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        Iterator attributes = type.getAttributeMembers();
        while (attributes.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)attributes.next();
            attribute.getType().accept(this);
        }
        Iterator elements = type.getElementMembers();
        while (elements.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)elements.next();
            element.getType().accept(this);
        }
        try {
            this.generateObjectSerializerForType(type);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", type.getName().getLocalPart());
        }
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    private boolean haveVisited(AbstractType type) {
        return this.visitedTypes.contains(type);
    }

    private void typeVisited(AbstractType type) {
        this.visitedTypes.add(type);
    }

    private void generateObjectSerializerForType(LiteralStructuredType type) throws IOException {
        this.writeObjectSerializerForType(type);
    }

    private void writeObjectSerializerForType(LiteralStructuredType type) throws IOException {
        JavaType javaType = type.getJavaType();
        if (javaType == null) {
            GeneratorBase.fail("generator.invalid.model.state.no.javatype", type.getName().getLocalPart());
        }
        String className = this.env.getNames().typeObjectSerializerClassName(type);
        File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        try {
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writeObjectSerializerCode(out, type);
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", classFile.toString());
        }
    }

    private void writeObjectSerializerCode(IndentingWriter p, LiteralStructuredType type) throws IOException {
        this.log("writing  serializer/deserializer for: " + type.getName().getLocalPart());
        String className = this.env.getNames().typeObjectSerializerClassName(type);
        GeneratorBase.writePackage(p, className);
        this.writeImports(p);
        p.pln();
        this.writeClassDecl(p, className);
        this.writeMembers(p, type);
        p.pln();
        this.writeConstructor(p, className);
        p.pln();
        this.writeInitialize(p, type);
        p.pln();
        this.writeDoDeserializeMethod(p, type);
        p.pln();
        this.writeDoSerializeAttributesMethod(p, type);
        this.writeDoSerializeMethod(p, type);
        p.pOln("}");
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.literal.*;");
        p.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
        p.pln("import java.util.List;");
        p.pln("import java.util.ArrayList;");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" extends LiteralObjectSerializerBase implements Initializable {").toString());
    }

    private void writeMembers(IndentingWriter p, LiteralStructuredType type) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        HashSet processedTypes = new HashSet();
        Iterator iter = type.getAttributeMembers();
        while (iter.hasNext()) {
            LiteralAttributeMember member = (LiteralAttributeMember)iter.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            GeneratorUtil.writeQNameDeclaration(p, member.getName(), this.env.getNames());
        }
        Iterator iter2 = type.getElementMembers();
        while (iter2.hasNext()) {
            LiteralElementMember member = (LiteralElementMember)iter2.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            GeneratorUtil.writeQNameDeclaration(p, member.getName(), this.env.getNames());
            LiteralEncoding.writeStaticSerializer(p, member.getType(), processedTypes, this.writerFactory, this.env.getNames());
        }
    }

    private void writeConstructor(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(className)).append("(QName type, String encodingStyle) {").toString());
        p.pln("super(type, true, encodingStyle);");
        p.pOln("}");
    }

    private void writeInitialize(IndentingWriter p, LiteralStructuredType type) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        HashSet<String> processedTypes = new HashSet<String>();
        p.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        Iterator iter = type.getElementMembers();
        while (iter.hasNext()) {
            LiteralElementMember member = (LiteralElementMember)iter.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            LiteralType memType = member.getType();
            if (processedTypes.contains(memType.getName() + ";" + memType.getJavaType().getRealName())) continue;
            SerializerWriter writer = this.writerFactory.createWriter(memType);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(memType.getName()), "registry");
            processedTypes.add(member.getType().getName() + ";" + memType.getJavaType().getRealName());
        }
        p.pOln("}");
    }

    private void writeDoDeserializeMethod(IndentingWriter p, LiteralStructuredType type) throws IOException {
        this.env.getNames();
        String unqualifiedClassName = Names.stripQualifier(type.getJavaType().getRealName());
        p.plnI("public Object doDeserialize(XMLReader reader,");
        p.pln("SOAPDeserializationContext context) throws Exception {");
        p.pln(unqualifiedClassName + " instance = new " + unqualifiedClassName + "();");
        p.pln("Object member;");
        p.pln("QName elementName;");
        p.pln("List values;");
        p.pln("Object value;");
        p.pln();
        if (type.getAttributeMembersCount() > 0) {
            this.writeDeserializeAttributes(p, type, "reader");
            p.pln();
        }
        p.pln("reader.nextElementContent();");
        if (type.getElementMembersCount() > 0) {
            this.writeDeserializeElements(p, type, "reader");
            p.pln();
        }
        p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
        p.pln("return (Object)instance;");
        p.pOln("}");
    }

    private void writeDeserializeAttributes(IndentingWriter p, LiteralStructuredType type, String reader) throws IOException {
        p.pln("Attributes attributes = reader.getAttributes();");
        p.pln("String attribute = null;");
        Iterator iterator = type.getAttributeMembers();
        while (iterator.hasNext()) {
            String valueStr;
            LiteralAttributeMember member = (LiteralAttributeMember)iterator.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            String memberConstName = member.getName().getLocalPart().toUpperCase();
            String memberQName = this.env.getNames().getQNameName(member.getName());
            p.pln("attribute = attributes.getValue(" + memberQName + ");");
            p.plnI("if (attribute != null) {");
            String encoder = SimpleTypeSerializerWriter.getTypeEncoder(member.getType());
            p.pln("member = " + encoder + ".getInstance().stringToObject(attribute, reader);");
            String javaName = javaMember.getType().getRealName();
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")member", javaName);
            } else {
                valueStr = "(" + javaName + ")member";
            }
            if (javaMember.isPublic()) {
                p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
            } else {
                p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
            }
            p.pOln("}");
            if (!member.isRequired()) continue;
            p.plnI("else {");
            p.pln("throw new DeserializationException(\"literal.missinRequiredAttribute\", new Object[] {" + memberQName + "});");
            p.pOln("}");
        }
    }

    private void writeDeserializeElements(IndentingWriter p, LiteralStructuredType type, String reader) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        if (type instanceof LiteralSequenceType) {
            Iterator iterator = type.getElementMembers();
            while (iterator.hasNext()) {
                LiteralElementMember elementMember = (LiteralElementMember)iterator.next();
                p.pln("elementName = " + reader + ".getName();");
                if (elementMember.isRepeated()) {
                    this.writeArrayElementMemberDeserializer(p, type, elementMember, reader, false);
                    continue;
                }
                this.writeScalarElementMemberDeserializer(p, type, elementMember, reader, false);
            }
        } else if (type.getElementMembersCount() > 0) {
            p.pln("elementName = " + reader + ".getName();");
            p.plnI("while (reader.getState() == XMLReader.START) {");
            Iterator iterator = type.getElementMembers();
            boolean gotOne = false;
            while (iterator.hasNext()) {
                LiteralElementMember elementMember;
                if (gotOne) {
                    p.p("else ");
                }
                if ((elementMember = (LiteralElementMember)iterator.next()).isRepeated()) {
                    this.writeArrayElementMemberDeserializer(p, type, elementMember, reader, true);
                } else {
                    this.writeScalarElementMemberDeserializer(p, type, elementMember, reader, true);
                }
                gotOne = true;
            }
            p.plnI("else {");
            p.pln("throw new DeserializationException(\"literal.unexpectedElementName\", new Object[] { elementName });");
            p.pOln("}");
            p.pOln("}");
        }
    }

    private void writeScalarElementMemberDeserializer(IndentingWriter p, LiteralStructuredType type, LiteralElementMember member, String reader, boolean isAllType) throws IOException {
        JavaStructureMember javaMember = member.getJavaStructureMember();
        String memberConstName = this.env.getNames().memberName(member.getName().getLocalPart().toUpperCase());
        String memberQName = this.env.getNames().getQNameName(member.getName());
        if (!isAllType) {
            p.plnI("if (" + reader + ".getState() == XMLReader.START) {");
        }
        p.plnI("if (elementName.equals(" + memberQName + ")) {");
        SerializerWriter writer = this.writerFactory.createWriter(member.getType());
        String serializer = writer.deserializerMemberName();
        p.pln("member = " + serializer + ".deserialize(" + memberQName + ", " + reader + ", context);");
        if (!member.isNillable()) {
            p.plnI("if (member == null) {");
            p.pln("throw new DeserializationException(\"literal.unexpectedNull\");");
            p.pOln("}");
        }
        String valueStr = null;
        String javaName = javaMember.getType().getRealName();
        if (SimpleToBoxedUtil.isPrimitive(javaName)) {
            String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
            valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")member", javaName);
        } else {
            valueStr = "(" + javaName + ")member";
        }
        if (javaMember.isPublic()) {
            p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
        } else {
            p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
        }
        p.pln(reader + ".nextElementContent();");
        p.pO("}");
        if (!isAllType && member.isRequired()) {
            p.plnI(" else {");
            p.pln("throw new DeserializationException(\"literal.unexpectedElementName\", new Object[] { " + memberQName + " });");
            p.pOln("}");
        } else {
            p.pln();
        }
        if (!isAllType) {
            p.pOln("}");
            if (member.isRequired()) {
                p.plnI("else {");
                p.pln("throw new DeserializationException(\"literal.expectedElementName\", " + reader + ".getName().toString());");
                p.pOln("}");
            }
        }
    }

    private void writeArrayElementMemberDeserializer(IndentingWriter p, LiteralStructuredType type, LiteralElementMember member, String reader, boolean isAllType) throws IOException {
        JavaStructureMember javaMember = member.getJavaStructureMember();
        String memberConstName = this.env.getNames().memberName(member.getName().getLocalPart().toUpperCase());
        String memberQName = this.env.getNames().getQNameName(member.getName());
        p.plnI("if ((" + reader + ".getState() == XMLReader.START) && (elementName.equals(" + memberQName + "))) {");
        p.pln("values = new ArrayList();");
        p.plnI("for(;;) {");
        p.plnI("if ((" + reader + ".getState() == XMLReader.START) && (elementName.equals(" + memberQName + "))) {");
        SerializerWriter writer = this.writerFactory.createWriter(member.getType());
        String serializer = writer.deserializerMemberName();
        p.pln("value = " + serializer + ".deserialize(" + memberQName + ", " + reader + ", context);");
        if (!member.isNillable()) {
            p.plnI("if (value == null) {");
            p.pln("throw new DeserializationException(\"literal.unexpectedNull\");");
            p.pOln("}");
        }
        p.pln("values.add(value);");
        String valueStr = null;
        String javaName = member.getType().getJavaType().getRealName();
        p.pln(reader + ".nextElementContent();");
        p.pO("}");
        p.plnI(" else {");
        p.pln("break;");
        p.pOln("}");
        p.pOln("}");
        p.pln("member = new " + javaName + "[values.size()];");
        if (SimpleToBoxedUtil.isPrimitive(javaName)) {
            String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
            p.plnI("for (int i = 0; i < values.size(); ++i) {");
            p.pln("((" + javaName + "[]) member)[i] = " + SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")(values.get(i))", javaName) + ";");
            p.pOln("}");
        } else {
            p.pln("member = values.toArray((Object[]) member);");
        }
        valueStr = "(" + javaName + "[])member";
        if (javaMember.isPublic()) {
            p.pln("instance." + javaMember.getName() + " = " + valueStr + ";");
        } else {
            p.pln("instance." + javaMember.getWriteMethod() + "(" + valueStr + ");");
        }
        p.pOln("}");
        if (member.isRequired()) {
            p.plnI("else {");
            p.pln("throw new DeserializationException(\"literal.expectedElementName\", " + reader + ".getName().toString());");
            p.pOln("}");
        }
    }

    private void writeDoSerializeAttributesMethod(IndentingWriter p, LiteralStructuredType type) throws IOException {
        p.plnI("public void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        p.pln(type.getJavaType().getRealName() + " instance = (" + type.getJavaType().getRealName() + ")obj;");
        p.pln();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = type.getAttributeMembers();
        while (iterator.hasNext()) {
            LiteralAttributeMember member = (LiteralAttributeMember)iterator.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            String memberConstName = member.getName().getLocalPart().toUpperCase();
            String memberQName = this.env.getNames().getQNameName(member.getName());
            SerializerWriter writer = this.writerFactory.createWriter(member.getType());
            String serializer = writer.serializerMemberName();
            String valueStr = null;
            String javaName = javaMember.getType().getRealName();
            if (javaMember.isPublic()) {
                valueStr = "instance." + javaMember.getName();
            } else {
                String methName = javaMember.getReadMethod();
                valueStr = "instance." + methName + "()";
            }
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, javaName);
            }
            String encoder = SimpleTypeSerializerWriter.getTypeEncoder(member.getType());
            p.pln("writer.writeAttribute(" + memberQName + ", " + encoder + ".getInstance().objectToString(" + valueStr + ", writer));");
        }
        p.pOln("}");
    }

    private void writeDoSerializeMethod(IndentingWriter p, LiteralStructuredType type) throws IOException {
        p.plnI("public void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        p.pln(type.getJavaType().getRealName() + " instance = (" + type.getJavaType().getRealName() + ")obj;");
        p.pln();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = type.getElementMembers();
        while (iterator.hasNext()) {
            LiteralElementMember member = (LiteralElementMember)iterator.next();
            JavaStructureMember javaMember = member.getJavaStructureMember();
            String memberConstName = member.getName().getLocalPart().toUpperCase();
            String memberQName = this.env.getNames().getQNameName(member.getName());
            SerializerWriter writer = this.writerFactory.createWriter(member.getType());
            String serializer = writer.serializerMemberName();
            String valueStr = null;
            String javaName = javaMember.getType().getRealName();
            if (javaMember.isPublic()) {
                valueStr = "instance." + javaMember.getName();
            } else {
                String methName = javaMember.getReadMethod();
                valueStr = "instance." + methName + "()";
            }
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, javaName);
            }
            if (member.isRepeated()) {
                String javaElementName = member.getType().getJavaType().getRealName();
                p.plnI("if (" + valueStr + " != null) {");
                p.plnI("for (int i = 0; i < " + valueStr + ".length; ++i) {");
                if (SimpleToBoxedUtil.isPrimitive(javaElementName)) {
                    p.pln(serializer + ".serialize(" + SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr + "[i]", javaElementName) + ", " + memberQName + ", null, writer, context);");
                } else {
                    p.pln(serializer + ".serialize(" + valueStr + "[i], " + memberQName + ", null, writer, context);");
                }
                p.pOln("}");
                p.pOln("}");
                continue;
            }
            p.pln(serializer + ".serialize(" + valueStr + ", " + memberQName + ", null, writer, context);");
        }
        p.pOln("}");
    }
}

