/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

public class SOAPFaultSerializerGenerator
extends GeneratorBase {
    private Port port;

    public SOAPFaultSerializerGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new SOAPFaultSerializerGenerator(model, config, properties);
    }

    private SOAPFaultSerializerGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitPort(Port port) throws Exception {
        this.port = port;
    }

    protected void postVisitPort(Port port) throws Exception {
        this.port = null;
    }

    protected void postVisitOperation(Operation operation) throws Exception {
        if (this.needsFaultSerializer(operation)) {
            this.generateFaultSerializer(operation);
        }
    }

    protected void visitFault(Fault fault) throws Exception {
        AbstractType type = fault.getBlock().getType();
        if (type.isSOAPType()) {
            ((SOAPType)type).accept(this);
        }
    }

    private boolean needsFaultSerializer(Operation operation) {
        Iterator faults = operation.getAllFaults();
        boolean needsFaultSerializer = false;
        if (faults != null) {
            while (!needsFaultSerializer && faults.hasNext()) {
                Fault fault = (Fault)faults.next();
                needsFaultSerializer = fault.getBlock().getType().isSOAPType();
            }
        }
        return needsFaultSerializer;
    }

    private void generateFaultSerializer(Operation operation) {
        this.log("generating FaultHandler for: " + operation.getUniqueName());
        try {
            String className = this.env.getNames().faultSerializerClassName(this.port, operation);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            out.pln();
            this.writeImports(out);
            out.pln();
            this.writeClassDecl(out, className);
            this.writeMembers(out, operation);
            out.pln();
            this.writeClassConstructor(out, className);
            out.pln();
            this.writeInitialize(out, operation);
            out.pln();
            this.writeDeserializeDetail(out, operation);
            out.pln();
            this.writeSerializeDetail(out, operation);
            out.pOln("}");
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.soap.message.SOAPFaultInfo;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" extends SOAPFaultInfoSerializer {").toString());
    }

    private void writeMembers(IndentingWriter p, Operation operation) throws IOException, GeneratorException {
        Fault fault;
        HashSet<String> processedTypes = new HashSet<String>();
        Iterator faults = operation.getAllFaults();
        while (faults.hasNext()) {
            fault = (Fault)faults.next();
            if (!fault.getBlock().getType().isSOAPType()) continue;
            GeneratorUtil.writeQNameDeclaration(p, fault.getBlock().getName(), this.env.getNames());
            SOAPEncoding.writeStaticSerializer(p, (SOAPType)fault.getBlock().getType(), processedTypes, this.writerFactory, this.env.getNames());
            SerializerWriter writer = this.writerFactory.createWriter(fault.getBlock().getType());
            if (processedTypes.contains(fault.getBlock().getType().getName() + writer.serializerMemberName() + "_Serializer")) continue;
            p.pln("private " + GeneratorConstants.BASE_SERIALIZER_NAME + " " + writer.serializerMemberName() + "_Serializer;");
            processedTypes.add(fault.getBlock().getType().getName() + writer.serializerMemberName() + "_Serializer");
        }
        faults = operation.getAllFaults();
        int i = 0;
        while (faults.hasNext()) {
            fault = (Fault)faults.next();
            p.pln("private static final int " + fault.getJavaException().getRealName().toUpperCase().replace('.', '_') + "_INDEX = " + i++ + ";");
        }
    }

    private void writeClassConstructor(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(className)).append("(boolean encodeType, ").append("boolean isNullable) {").toString());
        p.pln("super(encodeType, isNullable);");
        p.pOln("}");
    }

    private void writeInitialize(IndentingWriter p, Operation operation) throws IOException {
        Iterator faults = operation.getAllFaults();
        HashSet<AbstractType> processedTypes = new HashSet<AbstractType>();
        p.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        p.pln("super.initialize(registry);");
        while (faults.hasNext()) {
            Fault fault = (Fault)faults.next();
            AbstractType type = fault.getBlock().getType();
            if (!type.isSOAPType() || processedTypes.contains(type)) continue;
            SerializerWriter writer = this.writerFactory.createWriter(type);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(type.getName()), "registry");
            p.pln(writer.serializerMemberName() + "_Serializer = " + writer.serializerMemberName() + ".getInnermostSerializer();");
            processedTypes.add(type);
        }
        p.pOln("}");
    }

    private void writeDeserializeDetail(IndentingWriter p, Operation operation) throws IOException {
        TreeSet faultsSet = new TreeSet(new GeneratorUtil.FaultComparator());
        faultsSet.addAll(operation.getAllFaultsSet());
        Iterator faults = faultsSet.iterator();
        String detailNames = "";
        p.plnI("protected Object deserializeDetail(SOAPDeserializationState state, XMLReader reader,");
        p.pln("SOAPDeserializationContext context, SOAPFaultInfo instance) throws Exception {");
        p.pln("boolean isComplete = true;");
        p.pln("QName elementName;");
        p.pln("QName elementType = null;");
        p.pln("SOAPInstanceBuilder builder = null;");
        p.pln("Object detail = null;");
        p.pln("Object obj = null;");
        p.pln();
        p.pln("reader.nextElementContent();");
        p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.START);");
        p.pln("elementName = reader.getName();");
        p.pln("elementType = getType(reader);");
        while (faults.hasNext()) {
            Fault fault = (Fault)faults.next();
            this.writeFaultDeserializer(p, fault, operation, "reader", faults.hasNext());
        }
        p.plnI("throw new DeserializationException(\"xsd.unexpectedElementName\", ");
        p.pln("new Object[] {\"" + detailNames + "\", elementName.toString()});");
        p.pO();
        p.pOln("}");
    }

    private void writeSerializeDetail(IndentingWriter p, Operation operation) throws IOException {
        TreeSet faultsSet = new TreeSet(new GeneratorUtil.FaultComparator());
        faultsSet.addAll(operation.getAllFaultsSet());
        Iterator faults = faultsSet.iterator();
        String detailNames = "";
        p.plnI("protected void serializeDetail(Object detail, XMLWriter writer, SOAPSerializationContext context)");
        p.pln("throws Exception {");
        p.plnI("if (detail == null) {");
        p.pln("throw new SerializationException(\"soap.unexpectedNull\");");
        p.pOln("}");
        p.pln("writer.startElement(DETAIL_QNAME);");
        p.pln();
        p.pln("boolean pushedEncodingStyle = false;");
        p.plnI("if (encodingStyle != null) {");
        p.pln("context.pushEncodingStyle(encodingStyle, writer);");
        p.pOln("}");
        while (faults.hasNext()) {
            Fault fault = (Fault)faults.next();
            this.writeFaultSerializer(p, fault, "writer", faults.hasNext());
        }
        p.pln("writer.endElement();");
        p.plnI("if (pushedEncodingStyle) {");
        p.pln("context.popEncodingStyle();");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeFaultDeserializer(IndentingWriter p, Fault fault, Operation operation, String reader, boolean hasNext) throws IOException {
        Block block = fault.getBlock();
        String memberConstName = "0";
        String memberQName = this.env.getNames().getQNameName(block.getName());
        SOAPType type = (SOAPType)block.getType();
        SerializerWriter writer = this.writerFactory.createWriter(type);
        String serializer = writer.deserializerMemberName();
        boolean referenceable = type.isReferenceable();
        p.plnI("if (elementName.equals(" + memberQName + ") && ");
        p.pln("(elementType == null || (elementType != null && ");
        p.pln("elementType.equals(" + serializer + ".getXmlType()))) ) {");
        p.pln("obj = " + serializer + ".deserialize(" + memberQName + ", " + reader + ", context);");
        if (referenceable) {
            p.plnI("if (obj instanceof SOAPDeserializationState) {");
            JavaException javaException = fault.getJavaException();
            String index = javaException.getRealName().toUpperCase() + "_INDEX";
            p.pln("builder = new " + this.env.getNames().faultBuilderClassName(this.port, operation) + "();");
            p.plnI("state = registerWithMemberState(instance, state, obj,");
            p.pln(index.replace('.', '_') + ", builder);");
            p.pO();
            p.pln("isComplete = false;");
            p.pOlnI("} else {");
            if (SOAPObjectSerializerGenerator.deserializeToDetail((SOAPStructureType)type)) {
                p.pln("detail = (javax.xml.soap.Detail)obj;");
            } else if (javaException.getMembersCount() == 1 && fault.getSubfaults() == null) {
                Iterator members = fault.getJavaException().getMembers();
                JavaStructureMember member = (JavaStructureMember)members.next();
                String valueStr = "(" + member.getType().getRealName() + ")obj";
                p.pln("detail = new " + this.env.getNames().customExceptionClassName(fault) + "(" + valueStr + ");");
            } else {
                String valueStr = "(" + type.getJavaType().getRealName() + ")obj";
                p.pln("detail = " + valueStr + ";");
            }
            p.pOln("}");
            p.pln("reader.nextElementContent();");
            p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
            p.pln("return (isComplete ? (Object)detail : (Object)state);");
        } else {
            String valueStr = null;
            String javaName = type.getJavaType().getRealName();
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")obj", javaName);
            } else {
                valueStr = "(" + javaName + ")obj";
            }
            p.pln("detail = new " + this.env.getNames().customExceptionClassName(fault) + "(" + valueStr + ");");
            p.pln("reader.nextElementContent();");
            p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
            p.pln("return detail;");
        }
        if (hasNext) {
            p.pO("} else ");
        } else {
            p.pOln("}");
        }
    }

    private void writeFaultSerializer(IndentingWriter p, Fault fault, String writer, boolean hasNext) throws IOException {
        Block block = fault.getBlock();
        String memberQName = this.env.getNames().getQNameName(block.getName());
        SOAPType type = (SOAPType)block.getType();
        String faultExceptionName = this.env.getNames().customExceptionClassName(fault);
        p.plnI("if (detail instanceof " + faultExceptionName + ") {");
        SerializerWriter sWriter = this.writerFactory.createWriter(type);
        String serializer = sWriter.deserializerMemberName() + "_Serializer";
        String detailStr = "detail";
        JavaException exception = fault.getJavaException();
        if (exception.getMembersCount() == 1 && fault.getSubfaults() == null) {
            Iterator members = exception.getMembers();
            JavaStructureMember javaMember = (JavaStructureMember)members.next();
            detailStr = "((" + faultExceptionName + ")" + detailStr + ")." + javaMember.getReadMethod() + "()";
        }
        p.pln(serializer + ".serialize(" + detailStr + ", " + memberQName + ", null, " + writer + ", context);");
        if (hasNext) {
            p.pO("} else ");
        } else {
            p.pOln("}");
        }
    }
}

