/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.StubTieGeneratorBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class TieGenerator
extends StubTieGeneratorBase {
    private Set operationNames;
    private Set soapActionValues;
    private boolean hasUniqueOperationNames;
    private boolean hasUniqueSoapActions;

    public TieGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new TieGenerator(model, config, properties);
    }

    private TieGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected String getClassName() {
        return this.env.getNames().tieFor(this.port.getJavaInterface());
    }

    protected String getStateType() {
        return "StreamingHandlerState";
    }

    protected Message getMessageToDeserialize(Operation operation) {
        Request message = operation.getRequest();
        if (message.getBodyBlockCount() != 1) {
            GeneratorBase.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
        }
        return message;
    }

    protected String getStateGetRequestResponseString() {
        return "getRequest";
    }

    protected String getInitializeAccess() {
        return "private";
    }

    protected boolean superClassHasInitialize() {
        return false;
    }

    protected void writeImports(IndentingWriter p) throws IOException {
        super.writeImports(p);
        p.pln("import com.sun.xml.rpc.server.*;");
        p.pln("import javax.xml.rpc.handler.HandlerInfo;");
        p.pln("import com.sun.xml.rpc.client.HandlerChainImpl;");
    }

    protected void preVisitPort(Port port) throws Exception {
        super.preVisitPort(port);
        this.operationNames = new HashSet();
        this.soapActionValues = new HashSet();
        this.hasUniqueOperationNames = true;
        this.hasUniqueSoapActions = true;
    }

    protected void postVisitPort(Port port) throws Exception {
        this.operationNames = null;
        this.soapActionValues = null;
        super.postVisitPort(port);
    }

    protected void preVisitOperation(Operation operation) throws Exception {
        String name = operation.getName().getLocalPart();
        if (this.operationNames.contains(name)) {
            this.hasUniqueOperationNames = false;
        }
        this.operationNames.add(name);
        if (operation.getSOAPAction() != null) {
            if (this.soapActionValues.contains(operation.getSOAPAction())) {
                this.hasUniqueSoapActions = false;
            }
            this.soapActionValues.add(operation.getSOAPAction());
        } else {
            this.hasUniqueSoapActions = false;
        }
    }

    protected void writeClassDecl(IndentingWriter p, String tieClassName) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(tieClassName)).toString());
        p.pln("extends com.sun.xml.rpc.server.TieBase implements SerializerConstants {");
        p.pln();
    }

    protected void writeConstructor(IndentingWriter p, String tieClassName) throws IOException {
        JavaInterface intf = this.service.getJavaInterface();
        String serializerRegistryName = this.env.getNames().serializerRegistryClassName(intf);
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(tieClassName)).append("() throws Exception {").toString());
        p.pln("super(new " + serializerRegistryName + "().getRegistry());");
        p.pln("initialize(internalTypeMappingRegistry);");
        HandlerChainInfo portServiceHandlers = this.port.getServerHandlerChainInfo();
        Iterator eachHandler = portServiceHandlers.getHandlers();
        if (eachHandler.hasNext()) {
            p.pln();
            p.plnI("{");
            p.pln("java.util.List handlerInfos = new java.util.Vector();");
            while (eachHandler.hasNext()) {
                Object[] headers;
                HandlerInfo currentHandler = (HandlerInfo)eachHandler.next();
                Map properties = currentHandler.getProperties();
                String propertiesName = "null";
                p.plnI("{");
                if (properties.size() > 0) {
                    propertiesName = "props";
                    p.pln("java.util.Map " + propertiesName + " = new java.util.HashMap();");
                    Iterator entries = properties.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        p.pln(propertiesName + ".put(\"" + (String)entry.getKey() + "\", \"" + (String)entry.getValue() + "\");");
                    }
                }
                if ((headers = currentHandler.getHeaderNames().toArray()) != null && headers.length > 0) {
                    p.plnI("QName[] headers = {");
                    int i = 0;
                    while (i < headers.length) {
                        QName hdr = (QName)headers[i];
                        p.pln("new QName(\"" + hdr.getNamespaceURI() + "\"" + ", " + "\"" + hdr.getLocalPart() + "\"" + ")" + (i != headers.length - 1 ? "," : ""));
                        ++i;
                    }
                    p.pOln("};");
                } else {
                    p.pln("QName[] headers = null;");
                }
                p.pln("HandlerInfo handlerInfo = new HandlerInfo(" + currentHandler.getHandlerClassName() + ".class" + ", " + propertiesName + ", headers);");
                p.pln("handlerInfos.add(handlerInfo);");
                p.pOln("}");
            }
            Set roles = this.port.getServerHandlerChainInfo().getRoles();
            p.p("String[] roles = new String[] {");
            boolean first = true;
            Iterator i = roles.iterator();
            while (i.hasNext()) {
                if (!first) {
                    p.p(", ");
                } else {
                    first = false;
                }
                p.p("\"" + i.next() + "\"");
            }
            p.pln("};");
            p.pln("handlerChain = new HandlerChainImpl(handlerInfos);");
            p.pln("handlerChain.setRoles(roles);");
            p.pln("handlerChain.addUnderstoodHeaders(getUnderstoodHeaders());");
            p.pOln("}");
        }
        p.pOln("}");
    }

    protected void writePeekFirstBodyElementMethod(IndentingWriter p) throws IOException {
        boolean useSoapActionDispatching;
        boolean useOperationNameDispatching = this.hasUniqueOperationNames;
        boolean bl = useSoapActionDispatching = !useOperationNameDispatching && this.hasUniqueSoapActions;
        if (!useOperationNameDispatching && !useSoapActionDispatching) {
            throw new GeneratorException("generator.tie.port.cannot.dispatch", this.port.getName().getLocalPart());
        }
        p.pln("/*");
        p.pln(" * This method must determine the opcode of the operation that has been invoked.");
        p.pln(" */");
        p.plnI("protected void peekFirstBodyElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, StreamingHandlerState state) throws Exception {");
        if (useSoapActionDispatching) {
            p.pln("String soapaction = null;");
            p.pln("String[] soapactionheaders = state.getMessageContext().getMessage().getMimeHeaders().getHeader(\"SOAPAction\");");
            p.plnI("if (soapactionheaders.length > 0) {");
            p.pln("soapaction = soapactionheaders[0];");
            p.pOlnI("} else {");
            p.pln("throw new SOAPProtocolViolationException(\"soap.request.missing.soapaction.cannot.dispatch\");");
            p.pOln("}");
        }
        Iterator operationsIter = this.operations.iterator();
        int j = 0;
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            if (j++ > 0) {
                p.p("else ");
            }
            if (useOperationNameDispatching) {
                Request message = operation.getRequest();
                if (message.getBodyBlockCount() != 1) {
                    GeneratorBase.fail("generator.tie.cannot.dispatch", operation.getName().getLocalPart());
                }
                Block bodyBlock = (Block)message.getBodyBlocks().next();
                p.plnI("if (bodyReader.getName().equals(" + this.env.getNames().getBlockQNameName(operation, bodyBlock) + ")) {");
                if (operation.isOverloaded()) {
                    p.pln("throw new SOAPProtocolViolationException(\"soap.operation.cannot.dispatch\", \"" + operation.getName().getLocalPart() + "\");");
                } else {
                    p.pln("state.getRequest().setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
                }
                p.pOln("}");
                continue;
            }
            if (!useSoapActionDispatching) continue;
            p.plnI("if (soapaction.equals(\"\\\"" + operation.getSOAPAction() + "\\\"\")) {");
            p.pln("state.getRequest().setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
            p.pOln("}");
        }
        if (j > 0) {
            p.plnI("else {");
        }
        p.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", bodyReader.getName().toString());");
        if (j > 0) {
            p.pOln("}");
        }
        p.pOln("}");
    }

    protected void writeProcessingHookMethod(IndentingWriter p) throws IOException {
        p.pln("/*");
        p.pln(" * This method must invoke the correct method on the servant based on the opcode.");
        p.pln(" */");
        p.plnI("protected void processingHook(StreamingHandlerState state) throws Exception {");
        Iterator operationsIter = this.operations.iterator();
        p.plnI("switch (state.getRequest().getOperationCode()) {");
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            p.pln("invoke_" + operation.getUniqueName() + "(state);");
            p.pln("break;");
            p.pO();
        }
        p.plnI("default:");
        p.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", Integer.toString(state.getRequest().getOperationCode()));");
        p.pO();
        p.pOln("}");
        p.pOln("}");
    }

    protected void writeRpcOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException {
        String messageName = operation.getName().getLocalPart();
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        String requestObjType = null;
        String requestObjName = null;
        SOAPType requestBlockType = null;
        boolean hasFaults = operation.getFaults().hasNext();
        Request message = operation.getRequest();
        Iterator iterator = message.getBodyBlocks();
        Block requestBlock = null;
        while (iterator.hasNext()) {
            requestBlock = (Block)iterator.next();
            if (!requestBlock.getName().getLocalPart().equals(messageName)) continue;
            requestBlockType = (SOAPType)requestBlock.getType();
            requestObjType = requestBlockType.getJavaType().getRealName();
            requestObjName = this.env.getNames().getTypeMemberName(requestBlockType.getJavaType());
            break;
        }
        this.writeInvokeMethodDecl(p, operation);
        this.declareRequestObjects(p, requestObjType, requestObjName);
        this.declareHolderHeaderObjects(p, requestBlock, operation);
        boolean hasRequestHeaders = false;
        iterator = operation.getRequest().getHeaderBlocks();
        hasRequestHeaders = iterator.hasNext();
        if (hasRequestHeaders) {
            this.writeRequestHeaders(p, operation);
        }
        if (hasFaults) {
            p.plnI("try {");
        }
        this.declareRpcReturnType(p, operation, resultType);
        p.p("((" + remoteClassName + ") getTarget())." + operation.getJavaMethod().getName() + "(");
        if (resultType != null && !resultType.getName().equals(ModelerConstants.VOID_CLASSNAME)) {
            p.pO();
        }
        iterator = javaMethod.getParameters();
        message = operation.getRequest();
        int i = 0;
        while (iterator.hasNext()) {
            JavaParameter javaParameter;
            Parameter parameter;
            Block paramBlock;
            if (i > 0) {
                p.p(", ");
            }
            if ((paramBlock = (parameter = (javaParameter = (JavaParameter)iterator.next()).getParameter()).getBlock()).getLocation() != 1) {
                if (javaParameter.isHolder()) {
                    if (javaParameter.getType().getHolderName() != null) {
                        p.p(javaParameter.getParameter().getName());
                    } else {
                        p.p(javaParameter.getParameter().getName() + "_holder");
                    }
                } else {
                    p.p(parameter.getName());
                }
            } else {
                JavaType javaObjType = paramBlock.getType().getJavaType();
                String javaObjName = this.env.getNames().getTypeMemberName(javaObjType);
                JavaStructureMember javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                if (javaParameter.isHolder()) {
                    p.p(javaParameter.getParameter().getName() + "_holder");
                } else if (javaMember.isPublic()) {
                    p.p(javaObjName + "." + parameter.getName());
                } else {
                    p.p(javaObjName + "." + javaMember.getReadMethod() + "()");
                }
            }
            ++i;
        }
        p.pln(");");
        this.declareRpcResponseObject(p, operation);
        TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
        faultSet.addAll(operation.getFaultsSet());
        Iterator faults = faultSet.iterator();
        while (faults.hasNext()) {
            Fault fault = (Fault)faults.next();
            p.pOlnI("} catch (" + this.env.getNames().customExceptionClassName(fault) + " e) {");
            p.plnI("SOAPFaultInfo fault = new SOAPFaultInfo(com.sun.xml.rpc.encoding.soap.SOAPConstants.FAULT_CODE_SERVER,");
            p.pln("\"" + this.env.getNames().customExceptionClassName(fault) + "\", null, e);");
            p.pO();
            p.pln("SOAPBlockInfo faultBlock = new SOAPBlockInfo(com.sun.xml.rpc.encoding.soap.SOAPConstants.QNAME_SOAP_FAULT);");
            p.pln("faultBlock.setValue(fault);");
            p.pln("faultBlock.setSerializer(" + this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.port, operation)) + ");");
            p.pln("state.getResponse().setBody(faultBlock);");
        }
        if (hasFaults) {
            p.pOln("}");
        }
        p.pOln("}");
    }

    private void writeInvokeMethodDecl(IndentingWriter p, Operation operation) throws IOException {
        String messageName = operation.getName().getLocalPart();
        p.pln("/*");
        p.pln(" * This method does the actual method invocation for operation: " + messageName);
        p.pln(" */");
        p.plnI("private void invoke_" + operation.getUniqueName() + "(StreamingHandlerState state) throws Exception {");
        p.pln();
    }

    private void declareRequestObjects(IndentingWriter p, String requestObjType, String requestObjName) throws IOException {
        String requestObjMemberName = requestObjName + "Obj";
        p.pln(requestObjType + " " + requestObjName + " = null;");
        p.plnI("Object " + requestObjMemberName + " =");
        p.pln("state.getRequest().getBody().getValue();");
        p.pO();
        p.pln();
        p.plnI("if (" + requestObjMemberName + " instanceof SOAPDeserializationState) {");
        p.p(requestObjName + " =");
        p.pln("(" + requestObjType + ")((SOAPDeserializationState)" + requestObjMemberName + ").getInstance();");
        p.pOlnI("} else {");
        p.p(requestObjName + " =");
        p.pln("(" + requestObjType + ")" + requestObjMemberName + ";");
        p.pOln("}");
        p.pln();
    }

    private void declareHolderHeaderObjects(IndentingWriter p, Block requestBlock, Operation operation) throws IOException {
        SOAPType requestBlockType = (SOAPType)requestBlock.getType();
        String requestObjType = requestBlockType.getJavaType().getRealName();
        String requestObjName = this.env.getNames().getTypeMemberName(requestBlockType.getJavaType());
        String requestObjMemberName = requestObjName + "Obj";
        JavaMethod javaMethod = operation.getJavaMethod();
        Iterator iterator = javaMethod.getParameters();
        boolean declaredHeaderObj = false;
        boolean i = false;
        while (iterator.hasNext()) {
            JavaParameter javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                String holderClassName = this.env.getNames().holderClassName(this.port, javaParameter.getType());
                p.plnI(holderClassName + " " + javaParameter.getParameter().getName() + "_holder =");
                p.pln("new " + holderClassName + "();");
                p.pO();
                if (javaParameter.getParameter().getLinkedParameter() == null) continue;
                JavaStructureMember javaMember = StubTieGeneratorBase.getJavaMember(javaParameter.getParameter());
                p.pln(" " + javaParameter.getParameter().getName() + "_holder.value = " + requestObjName + "." + javaMember.getReadMethod() + "();");
                continue;
            }
            if (javaParameter.getParameter().getBlock().getLocation() != 2) continue;
            if (!declaredHeaderObj) {
                p.pln("Object _headerObj;");
                declaredHeaderObj = true;
            }
            AbstractType paramType = javaParameter.getParameter().getType();
            String initValue = javaParameter.getType().getInitString();
            p.pln(paramType.getJavaType().getRealName() + " " + javaParameter.getParameter().getName() + " = " + initValue + ";");
        }
    }

    private void declareRpcReturnType(IndentingWriter p, Operation operation, JavaType resultType) throws IOException {
        Response message = operation.getResponse();
        Iterator iterator = message.getBodyBlocks();
        if (resultType != null && !resultType.getName().equals(ModelerConstants.VOID_CLASSNAME) && (iterator = message.getParameters()).hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            p.plnI(parameter.getType().getJavaType().getRealName() + " " + parameter.getName() + " = ");
        }
    }

    private void writeRequestHeaders(IndentingWriter p, Operation operation) throws IOException {
        p.pln("Iterator headers = state.getRequest().headers();");
        p.pln("SOAPHeaderBlockInfo curHeader;");
        p.plnI("while (headers.hasNext()) {");
        p.pln("curHeader = (SOAPHeaderBlockInfo)headers.next();");
        Iterator iterator = operation.getRequest().getParameters();
        boolean startedHeaders = false;
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getBlock().getLocation() != 2) continue;
            if (startedHeaders) {
                p.p(" else ");
            }
            startedHeaders = true;
            String paramName = parameter.getName();
            String paramType = parameter.getType().getJavaType().getRealName();
            String qname = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
            p.plnI("if (curHeader.getName().equals(" + qname + ")) {");
            p.pln("_headerObj = (" + paramType + ")curHeader.getValue();");
            p.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
            p.pln(paramName + " = (" + paramType + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
            p.pOlnI("} else {");
            p.pln(paramName + " = (" + paramType + ")_headerObj;");
            p.pOln("}");
            p.pO("}");
        }
        if (startedHeaders) {
            p.pln();
        }
        p.pOln("}");
        p.pln();
    }

    private void declareRpcResponseObject(IndentingWriter p, Operation operation) throws IOException {
        String messageName = operation.getName().getLocalPart();
        Response message = operation.getResponse();
        Iterator iterator = message.getBodyBlocks();
        Block responseBlock = null;
        SOAPType responseBlockType = null;
        String responseObjType = null;
        String responseObjName = null;
        while (iterator.hasNext()) {
            responseBlock = (Block)iterator.next();
            if (responseBlock.getName().getLocalPart().equals(messageName + "Response")) {
                responseBlockType = (SOAPType)responseBlock.getType();
                responseObjType = responseBlockType.getJavaType().getRealName();
                responseObjName = this.env.getNames().getTypeMemberName(responseBlockType.getJavaType());
                break;
            }
            responseBlock = null;
        }
        p.plnI(responseObjType + " " + responseObjName + " =");
        p.pln("new " + responseObjType + "();");
        p.pO();
        message = operation.getResponse();
        Iterator iterator2 = message.getParameters();
        p.pln("SOAPHeaderBlockInfo headerInfo;");
        int i = 0;
        while (iterator2.hasNext()) {
            String memberName;
            JavaParameter javaParameter;
            Parameter parameter = (Parameter)iterator2.next();
            Block block = parameter.getBlock();
            if (block.getLocation() == 1) {
                JavaStructureMember javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                javaParameter = parameter.getJavaParameter();
                memberName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                if (javaMember != null) {
                    if (javaMember.isPublic()) {
                        p.pln(responseObjName + "." + javaMember.getName() + " = " + memberName + ";");
                    } else {
                        p.pln(responseObjName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
                    }
                }
            } else {
                javaParameter = parameter.getJavaParameter();
                String qname = this.env.getNames().getBlockQNameName(null, block);
                memberName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + "_holder.value" : parameter.getName();
                p.pln("headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
                p.pln("headerInfo.setValue(" + memberName + ");");
                p.pln("headerInfo.setSerializer(" + this.writerFactory.createWriter((SOAPType)block.getType()).serializerMemberName() + ");");
                p.pln("state.getResponse().add(headerInfo);");
            }
            ++i;
        }
        p.pln();
        p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, responseBlock) + ");");
        p.pln("bodyBlock.setValue(" + responseObjName + ");");
        p.pln("bodyBlock.setSerializer(" + this.writerFactory.createWriter(responseBlockType).serializerMemberName() + ");");
        p.pln("state.getResponse().setBody(bodyBlock);");
    }

    protected void writeDocumentOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException {
        Parameter parameter;
        String messageName = operation.getName().getLocalPart();
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        String requestObjType = null;
        String requestObjName = null;
        String responseObjType = null;
        String responseObjName = null;
        LiteralType responseBlockType = null;
        LiteralType requestBlockType = null;
        Block responseBlock = null;
        Request requestMessage = operation.getRequest();
        int embeddedParameterCount = 0;
        int nonEmbeddedParameterCount = 0;
        Iterator iterator = requestMessage.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            Block paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() == 1) {
                if (parameter.isEmbedded()) {
                    ++embeddedParameterCount;
                    continue;
                }
                ++nonEmbeddedParameterCount;
                continue;
            }
            throw new GeneratorException("generator.internal.error.should.not.happen", "stub.generator.001");
        }
        if (nonEmbeddedParameterCount > 1 || nonEmbeddedParameterCount > 0 && embeddedParameterCount > 0) {
            throw new GeneratorException("generator.internal.error.should.not.happen", "stub.generator.002");
        }
        iterator = requestMessage.getBodyBlocks();
        Block requestBlock = null;
        if (iterator.hasNext()) {
            requestBlock = (Block)iterator.next();
            requestBlockType = (LiteralType)requestBlock.getType();
            requestObjType = requestBlockType.getJavaType().getRealName();
            requestObjName = this.env.getNames().getTypeMemberName(requestBlockType.getJavaType());
        }
        this.writeInvokeMethodDecl(p, operation);
        this.declareRequestObjects(p, requestObjType, requestObjName);
        Response message = operation.getResponse();
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            responseBlock = (Block)iterator.next();
            responseBlockType = (LiteralType)responseBlock.getType();
            responseObjType = responseBlockType.getJavaType().getRealName();
            responseObjName = "_response";
        }
        boolean resultIsEmbedded = false;
        if (resultType != null && !resultType.getName().equals(ModelerConstants.VOID_CLASSNAME) && (iterator = message.getParameters()).hasNext()) {
            parameter = (Parameter)iterator.next();
            if (parameter.isEmbedded()) {
                resultIsEmbedded = true;
                p.p(resultType.getRealName() + " _result = ");
            } else {
                p.p(responseObjType + " " + responseObjName + " = ");
            }
        }
        p.p("((" + remoteClassName + ") getTarget())." + operation.getJavaMethod().getName() + "(");
        if (nonEmbeddedParameterCount > 0) {
            p.p(requestObjName);
        } else {
            int count = 0;
            iterator = requestMessage.getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                JavaStructureMember javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                if (count > 0) {
                    p.p(", ");
                }
                if (javaMember.isPublic()) {
                    p.p(requestObjName + "." + parameter.getName());
                } else {
                    p.p(requestObjName + "." + javaMember.getReadMethod() + "()");
                }
                ++count;
            }
        }
        p.pln(");");
        p.pln();
        if (resultIsEmbedded) {
            p.pln(responseObjType + " " + responseObjName + " = new " + responseObjType + "();");
            iterator = message.getParameters();
            parameter = (Parameter)iterator.next();
            JavaStructureMember javaMember = StubTieGeneratorBase.getJavaMember(parameter);
            if (javaMember.isPublic()) {
                p.pln(responseObjName + "." + parameter.getName() + " = _result;");
            } else {
                p.pln(responseObjName + "." + javaMember.getWriteMethod() + "(_result);");
            }
        }
        p.pln();
        p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, responseBlock) + ");");
        p.pln("bodyBlock.setValue(" + responseObjName + ");");
        String serializer = this.writerFactory.createWriter(responseBlockType).serializerMemberName();
        p.pln("bodyBlock.setSerializer(" + serializer + ");");
        p.pln("state.getResponse().setBody(bodyBlock);");
        p.pOln("}");
    }

    protected void writeReadFirstBodyElementDefault(IndentingWriter p, String opCode) throws IOException {
        p.pln("throw new SOAPProtocolViolationException(\"soap.operation.unrecognized\", Integer.toString(" + opCode + "));");
    }

    protected void writeStaticMembers(IndentingWriter p, Map headerMap) throws IOException {
        super.writeStaticMembers(p, headerMap);
    }

    protected void writeUnderstoodHeadersMember(IndentingWriter p, Map headerMap) throws IOException {
        p.p("private static final QName[] understoodHeaderNames = new QName[] { ");
        boolean first = true;
        Iterator operationsIter = this.operations.iterator();
        int i = 0;
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            Iterator blocks = operation.getRequest().getHeaderBlocks();
            while (blocks.hasNext()) {
                Block block = (Block)blocks.next();
                String qname = this.env.getNames().getBlockQNameName(operation, block);
                if (!first) {
                    p.p(", ");
                }
                p.p(qname);
                first = false;
            }
            ++i;
        }
        p.pln(" };");
    }
}

