/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiModeler;
import com.sun.xml.rpc.processor.util.BatchEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class ExceptionModeler
implements RmiConstants {
    private RmiModeler modeler;
    private ClassDefinition defRuntimeException;
    private BatchEnvironment env;
    private static final String THROWABLE_CLASSNAME = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionModeler.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName();
    private static final String OBJECT_CLASSNAME = (class$java$lang$Object == null ? (class$java$lang$Object = ExceptionModeler.class$("java.lang.Object")) : class$java$lang$Object).getName();
    private static final int MESSAGE_FLAG = 2;
    private static final int LOCALIZED_MESSAGE_FLAG = 4;
    private Map faultMap;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;

    public ExceptionModeler(RmiModeler modeler) {
        this.modeler = modeler;
        this.env = modeler.getBatchEnvironment();
        this.faultMap = new HashMap();
        try {
            this.defRuntimeException = this.env.getClassDeclaration(Identifier.lookup((String)RmiConstants.RUNTIME_EXCEPTION_CLASSNAME)).getClassDefinition((Environment)this.env);
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
    }

    public Fault modelException(String typeUri, String wsdlUri, ClassDeclaration exceptionCDec) {
        try {
            ClassDefinition classDef = exceptionCDec.getClassDefinition((Environment)this.env);
            return this.createFault(typeUri, wsdlUri, classDef);
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.class.not.found", exceptionCDec.getName().toString());
        }
    }

    public Fault createFault(String typeUri, String wsdlUri, ClassDefinition classDef) {
        String exceptionName = classDef.getName().toString();
        Fault fault = (Fault)this.faultMap.get(exceptionName);
        if (fault != null) {
            return fault;
        }
        HashMap members = new HashMap();
        this.collectMembers(classDef, members);
        int getMessageFlags = 0;
        if (members.containsKey("getMessage")) {
            Iterator iterator = members.entrySet().iterator();
            while (iterator.hasNext()) {
                MemberDefinition member = (MemberDefinition)iterator.next().getValue();
                if (!member.getType().getReturnType().toString().equals(ModelerConstants.STRING_CLASSNAME) || member.getName().toString().equals("getMessage")) continue;
                members.remove("getMessage");
                break;
            }
        }
        if (members.containsKey("getMessage")) {
            getMessageFlags = 2;
        }
        boolean hasDuplicates = false;
        Set duplicateMembers = ExceptionModeler.getDuplicateMembers(members);
        if (duplicateMembers.size() > 0) {
            hasDuplicates = true;
        }
        if (members.size() > 0 && !hasDuplicates) {
            TreeSet<MemberDefinition> constructors = new TreeSet<MemberDefinition>(new ConstructorComparator());
            MemberDefinition cstr = classDef.getFirstMember();
            while (cstr != null && fault == null) {
                if (cstr.isPublic() && !cstr.isStatic() && cstr.isConstructor()) {
                    constructors.add(cstr);
                }
                cstr = cstr.getNextMember();
            }
            Iterator iter = constructors.iterator();
            while (iter.hasNext() && fault == null) {
                MemberDefinition cstr2 = (MemberDefinition)iter.next();
                SOAPStructureMember[] soapMembers = this.constructorMatches(typeUri, wsdlUri, classDef, cstr2, members, getMessageFlags);
                if (soapMembers == null) continue;
                fault = this.createFault(typeUri, wsdlUri, classDef, soapMembers);
            }
        }
        if (fault == null) {
            ArrayList<String> newMembers = new ArrayList<String>();
            if (!members.containsKey("getMessage")) {
                newMembers.add("getMessage");
            }
            if (!members.containsKey("getLocalizedMessage")) {
                newMembers.add("getLocalizedMessage");
            }
            fault = this.createFault(typeUri, wsdlUri, classDef, this.addMessage(typeUri, wsdlUri, classDef, members, newMembers));
        }
        this.faultMap.put(classDef.getName().toString(), fault);
        return fault;
    }

    private static Set getDuplicateMembers(Map members) {
        HashSet<Type> types = new HashSet<Type>();
        HashSet<MemberDefinition> duplicateMembers = new HashSet<MemberDefinition>();
        Iterator iter = members.entrySet().iterator();
        while (iter.hasNext()) {
            MemberDefinition member = (MemberDefinition)iter.next().getValue();
            Type type = member.getType().getReturnType();
            String memberName = member.getName().toString();
            if (types.contains(type)) {
                duplicateMembers.add(member);
                continue;
            }
            types.add(type);
        }
        return duplicateMembers;
    }

    private SOAPStructureMember[] constructorMatches(String typeUri, String wsdlUri, ClassDefinition classDef, MemberDefinition cstr, Map members, int getMessageFlags) {
        Object[] memberArray;
        boolean memberCountMatch;
        Type[] args = cstr.getType().getArgumentTypes();
        boolean bl = memberCountMatch = args.length == (memberArray = members.values().toArray()).length;
        if (!(memberCountMatch || getMessageFlags != 0 && args.length == memberArray.length - 1)) {
            return null;
        }
        SOAPStructureMember[] soapMembers = new SOAPStructureMember[args.length];
        int i = 0;
        while (i < args.length) {
            int j = 0;
            while (j < memberArray.length && soapMembers[i] == null) {
                block9: {
                    block8: {
                        if (memberCountMatch) break block8;
                        String memberName = ((MemberDefinition)memberArray[j]).getName().toString();
                        if (getMessageFlags == 2 && memberName.equals("getMessage")) break block9;
                    }
                    if (args[i].equals(((MemberDefinition)memberArray[j]).getType().getReturnType())) {
                        soapMembers[i] = this.createSOAPMember(typeUri, wsdlUri, classDef, (MemberDefinition)memberArray[j], i);
                    }
                }
                ++j;
            }
            if (soapMembers[i] == null) {
                return null;
            }
            ++i;
        }
        return soapMembers;
    }

    public SOAPStructureMember createSOAPMember(String typeUri, String wsdlUri, ClassDefinition classDef, MemberDefinition member, int cstrPos) {
        String packageName = this.env.getNames().getPackageName(classDef.getName().toString());
        Type memberType = member.getType().getReturnType();
        String readMethod = member.getName().toString();
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        String propertyName = StringUtils.decapitalize(readMethod.substring(3));
        QName propertyQName = new QName("", propertyName);
        SOAPType propertyType = this.modeler.modelTypeSOAP(typeUri, memberType);
        SOAPStructureMember soapMember = new SOAPStructureMember(propertyQName, propertyType, null);
        JavaStructureMember javaMember = new JavaStructureMember(propertyName, propertyType.getJavaType(), soapMember);
        soapMember.setJavaStructureMember(javaMember);
        javaMember.setConstructorPos(cstrPos);
        javaMember.setReadMethod(readMethod);
        soapMember.setJavaStructureMember(javaMember);
        return soapMember;
    }

    public SOAPStructureMember[] addMessage(String typeUri, String wsdlUri, ClassDefinition classDef, Map members, List newMembers) {
        String packageName = this.env.getNames().getPackageName(classDef.getName().toString());
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        SOAPStructureMember[] soapMembers = new SOAPStructureMember[members.size() + newMembers.size()];
        Iterator iter = members.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            MemberDefinition argMember = (MemberDefinition)iter.next().getValue();
            soapMembers[i] = this.createSOAPMember(typeUri, wsdlUri, classDef, argMember, -1);
            ++i;
        }
        iter = newMembers.iterator();
        int i2 = members.size();
        while (iter.hasNext()) {
            String propertyName = StringUtils.decapitalize(((String)((Object)iter.next())).substring(3));
            QName propertyQName = new QName("", propertyName);
            SOAPSimpleType propertyType = this.modeler.getSOAPTypes().XSD_STRING_SOAPTYPE;
            SOAPStructureMember soapMember = new SOAPStructureMember(propertyQName, propertyType, null);
            JavaStructureMember javaMember = new JavaStructureMember(propertyName, propertyType.getJavaType(), soapMember);
            soapMember.setJavaStructureMember(javaMember);
            javaMember.setReadMethod("get" + StringUtils.capitalize(propertyName));
            soapMember.setJavaStructureMember(javaMember);
            soapMembers[i2] = soapMember;
            ++i2;
        }
        return soapMembers;
    }

    public Fault createFault(String typeUri, String wsdlUri, ClassDefinition classDef, SOAPStructureMember[] soapMembers) {
        String packageName = this.env.getNames().getPackageName(classDef.getName().toString());
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = typeUri;
        }
        this.env.getNames();
        Fault fault = new Fault(Names.stripQualifier(classDef.getName().toString()));
        SOAPOrderedStructureType soapStruct = new SOAPOrderedStructureType(new QName(namespaceURI, fault.getName()));
        namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = wsdlUri;
        }
        QName faultQName = new QName(namespaceURI, fault.getName());
        JavaException javaException = new JavaException(classDef.getName().toString(), true, soapStruct);
        int i = 0;
        while (i < soapMembers.length) {
            soapStruct.add(soapMembers[i]);
            javaException.add(soapMembers[i].getJavaStructureMember());
            ++i;
        }
        Block faultBlock = soapMembers.length == 1 ? new Block(faultQName, soapMembers[0].getType()) : new Block(faultQName, soapStruct);
        fault.setBlock(faultBlock);
        soapStruct.setJavaType(javaException);
        fault.setJavaException(javaException);
        return fault;
    }

    public void collectMembers(ClassDefinition classDef, Map members) {
        try {
            ClassDeclaration superDec = classDef.getSuperClass();
            if (!superDec.getName().toString().equals(THROWABLE_CLASSNAME)) {
                ClassDefinition superDef = superDec.getClassDefinition((Environment)this.env);
                this.collectMembers(superDef, members);
            }
            if (this.defRuntimeException.implementedBy((Environment)this.env, classDef.getClassDeclaration())) {
                throw new ModelerException("rmimodeler.must.not.extend.runtimeexception", classDef.getName().toString());
            }
            MemberDefinition member = classDef.getFirstMember();
            while (member != null) {
                String memberName;
                if (member.isMethod() && member.isPublic() && !member.isStatic() && !member.isConstructor() && !member.isInitializer() && (memberName = member.getName().toString()).startsWith("get") && member.getArguments() == null && !members.containsKey(memberName) && !memberName.equals("getLocalizedMessage")) {
                    members.put(memberName, member);
                }
                member = member.getNextMember();
            }
        }
        catch (Exception e) {
            throw new ModelerException(new LocalizableExceptionAdapter(e));
        }
    }

    private Fault getMappedFault(String className) {
        return (Fault)this.faultMap.get(className);
    }

    private static void log(BatchEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[ExceptionIntrospector: " + msg + "]");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ConstructorComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            MemberDefinition cstr1 = (MemberDefinition)o1;
            MemberDefinition cstr2 = (MemberDefinition)o2;
            if (cstr1.getType().getArgumentTypes() == null) {
                return 1;
            }
            if (cstr2.getType().getArgumentTypes() == null) {
                return -1;
            }
            return cstr2.getType().getArgumentTypes().length - cstr1.getType().getArgumentTypes().length;
        }
    }
}

