/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiModeler;
import com.sun.xml.rpc.processor.util.BatchEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class JavaBean
implements RmiConstants,
Constants {
    private HashMap members;
    private Class remoteBean;
    private ClassDefinition remoteClass;
    BatchEnvironment env;

    private static JavaBean forType(BatchEnvironment env, Type type) {
        JavaBean bean = null;
        try {
            String implClassName = RmiModeler.getRealName(type.getClassName().toString(), env);
            ClassDeclaration cDec = env.getClassDeclaration(Identifier.lookup((String)implClassName));
            ClassDefinition classDef = cDec.getClassDefinition((Environment)env);
            URLClassLoader classLoader = env.getClassLoader();
            Class<?> beanClass = classLoader.loadClass(implClassName);
            bean = new JavaBean(env, beanClass, classDef);
            bean.initialize();
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.class.not.found", type.getClassName().toString());
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", type.getClassName().toString());
        }
        return bean;
    }

    public static Map modelTypeSOAP(BatchEnvironment env, Type type) {
        JavaBean bean = JavaBean.forType(env, type);
        if (bean == null) {
            return null;
        }
        return bean.getMembers();
    }

    private HashMap getMembers() {
        return (HashMap)this.members.clone();
    }

    private JavaBean(BatchEnvironment env, Class remoteBean, ClassDefinition classDef) {
        this.env = env;
        this.remoteBean = remoteBean;
        this.remoteClass = classDef;
    }

    private void initialize() {
        BeanInfo beanInfo;
        this.members = new HashMap();
        try {
            beanInfo = Introspector.getBeanInfo(this.remoteBean);
        }
        catch (IntrospectionException e) {
            throw new ModelerException("rmimodeler.invalid.rmi.type:", this.remoteBean.getName().toString());
        }
        PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < properties.length) {
            if (!(properties[i] instanceof IndexedPropertyDescriptor)) {
                Class<?> propertyType = properties[i].getPropertyType();
                Method readMethod = properties[i].getReadMethod();
                Method writeMethod = properties[i].getWriteMethod();
                if (propertyType != null && readMethod != null && writeMethod != null) {
                    String propertyName = StringUtils.decapitalize(writeMethod.getName().substring(3));
                    Type type = this.findType(this.remoteClass, readMethod.getName());
                    if (type == null) {
                        throw new ModelerException("rmimodeler.could.not.resolve.property.type", this.remoteClass.getName().toString() + ":" + propertyName);
                    }
                    this.verifyProperty(this.remoteClass, type, writeMethod.getName());
                    MemberInfo memInfo = new MemberInfo(propertyName, type, false);
                    memInfo.setReadMethod(readMethod.getName());
                    memInfo.setWriteMethod(writeMethod.getName());
                    this.members.put(propertyName, memInfo);
                }
            }
            ++i;
        }
    }

    private boolean verifyProperty(ClassDefinition cDef, Type type, String writeMethod) {
        if ((type.getTypeMask() & 0xFE) == 0) {
            return true;
        }
        MemberDefinition member = cDef.getFirstMember();
        while (member != null) {
            Type methodType;
            Type[] args;
            if (member.isMethod() && !member.isConstructor() && !member.isInitializer() && member.isPublic() && writeMethod.equals(member.getName().toString()) && (args = (methodType = member.getType()).getArgumentTypes()).length == 1 && !args[0].equals(type)) {
                throw new ModelerException("rmimodeler.property.setter.method.cant.be.overloaded", new Object[]{writeMethod, type.toString(), cDef.getName().toString()});
            }
            member = member.getNextMember();
        }
        try {
            ClassDefinition superDef;
            ClassDeclaration superClass = cDef.getSuperClass();
            if (superClass != null) {
                superDef = superClass.getClassDefinition((Environment)this.env);
                this.verifyProperty(superDef, type, writeMethod);
            }
            ClassDeclaration[] superDefs = cDef.getInterfaces();
            int i = 0;
            while (i < superDefs.length) {
                superDef = superDefs[i].getClassDefinition((Environment)this.env);
                this.verifyProperty(superDef, type, writeMethod);
                ++i;
            }
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.class.not.found", cDef.getName().toString());
        }
        return true;
    }

    private Type findType(ClassDefinition cDef, String readMethod) {
        Type type = null;
        MemberDefinition member = cDef.getFirstMember();
        while (member != null) {
            if (member.isMethod() && !member.isConstructor() && !member.isInitializer() && member.isPublic() && readMethod.equals(member.getName().toString())) {
                type = member.getType().getReturnType();
                return type;
            }
            member = member.getNextMember();
        }
        try {
            ClassDefinition superDef;
            ClassDeclaration superClass = cDef.getSuperClass();
            if (superClass != null && (type = this.findType(superDef = superClass.getClassDefinition((Environment)this.env), readMethod)) != null) {
                return type;
            }
            ClassDeclaration[] superDefs = cDef.getInterfaces();
            int i = 0;
            while (i < superDefs.length) {
                superDef = superDefs[i].getClassDefinition((Environment)this.env);
                type = this.findType(superDef, readMethod);
                if (type != null) {
                    return type;
                }
                ++i;
            }
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.class.not.found", cDef.getName().toString());
        }
        return null;
    }

    private static void log(BatchEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[JavaBean: " + msg + "]");
        }
    }
}

