/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.util.BatchEnvironment;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class RmiStructure
implements RmiConstants {
    private BatchEnvironment env;
    private ClassDefinition implClassDef;
    private HashMap members;
    private ClassDefinition defRemote;

    private static RmiStructure forClass(BatchEnvironment env, ClassDefinition implClassDef) {
        RmiStructure sc = new RmiStructure(env, implClassDef);
        sc.initialize();
        return sc;
    }

    public static Map modelTypeSOAP(BatchEnvironment env, Type type) {
        ClassDefinition classDef;
        try {
            ClassDeclaration cDec = env.getClassDeclaration(type.getClassName());
            classDef = cDec.getClassDefinition((Environment)env);
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.class.not.found", type.getClassName().toString());
        }
        RmiStructure rt = RmiStructure.forClass(env, classDef);
        if (rt == null) {
            return null;
        }
        return rt.getMembers();
    }

    private HashMap getMembers() {
        return (HashMap)this.members.clone();
    }

    private RmiStructure(BatchEnvironment env, ClassDefinition implClassDef) {
        this.env = env;
        this.implClassDef = implClassDef;
    }

    private void initialize() {
        try {
            this.defRemote = this.env.getClassDeclaration(Identifier.lookup((String)RmiConstants.REMOTE_CLASSNAME)).getClassDefinition((Environment)this.env);
            if (!this.implClassDef.isInterface() && !this.implClassDef.isAbstract()) {
                String tmp1 = this.implClassDef.getName().getQualifier().toString();
                String tmp2 = this.implClassDef.getName().toString();
                boolean hasDefaultConstructor = false;
                MemberDefinition method = this.implClassDef.getFirstMatch(Constants.idInit);
                while (!hasDefaultConstructor && method != null) {
                    if (method.isPublic() && this.env.isApplicable(method, Type.noArgs)) {
                        hasDefaultConstructor = true;
                    }
                    method = method.getNextMatch();
                }
                if (!hasDefaultConstructor) {
                    throw new ModelerException("rmimodeler.no.empty.constructor", this.implClassDef.getName().toString());
                }
            }
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.class.not.found", e.name.toString());
        }
        this.members = new HashMap();
        Vector<ClassDefinition> interfacesImplemented = new Vector<ClassDefinition>();
        interfacesImplemented.addElement(this.implClassDef);
        try {
            if (this.defRemote.implementedBy((Environment)this.env, this.implClassDef.getClassDeclaration())) {
                RmiStructure.log(this.env, "remote interface implemented by: " + this.implClassDef.getName());
                throw new ModelerException("rmimodeler.type.cannot.implement.remote", this.implClassDef.toString());
            }
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.class.not.found", e.name.toString());
        }
        if (!this.collectMembers(this.implClassDef, this.members)) {
            this.members = new HashMap();
        }
    }

    private boolean collectMembers(ClassDefinition interfaceDef, HashMap map) {
        MemberDefinition member = interfaceDef.getFirstMember();
        while (member != null) {
            if (!(!member.isVariable() || member.isFinal() && member.isStatic() || !member.isPublic() || member.isTransient() || map.get(member.getName().toString()) != null)) {
                map.put(member.getName().toString(), new MemberInfo(member.getName().toString(), member.getType(), true));
            }
            member = member.getNextMember();
        }
        try {
            ClassDeclaration[] superDefs = interfaceDef.getInterfaces();
            ClassDeclaration superClass = interfaceDef.getSuperClass();
            if (superClass != null) {
                ClassDefinition superDef = superClass.getClassDefinition((Environment)this.env);
                return this.collectMembers(superDef, map);
            }
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.class.not.found", interfaceDef.getName().toString());
        }
        return true;
    }

    private static void log(BatchEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[RmiStructure: " + msg + "]");
        }
    }
}

