/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaCustomType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.JavaBean;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiStructure;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreator;
import com.sun.xml.rpc.processor.util.BatchEnvironment;
import com.sun.xml.rpc.util.ClassNameInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class RmiTypeModeler
implements RmiConstants,
Constants {
    private Map soapTypeMap;
    private Set typeNames = new HashSet();
    private RmiModeler modeler;
    private BatchEnvironment env;
    private TypeMappingRegistryInfo typeMappingRegistry;
    private SOAPSimpleTypeCreator soapTypes;

    public SOAPType modelTypeSOAP(String typeUri, Type type) {
        TypeMappingInfo typeMapping;
        SOAPType typeNode = this.getMappedSoapType(type);
        if (typeNode != null) {
            return typeNode;
        }
        if (this.typeMappingRegistry != null && (typeMapping = this.typeMappingRegistry.getTypeMappingInfo("http://schemas.xmlsoap.org/soap/encoding/", type.toString())) != null) {
            return this.processTypeMapping(this.env, typeMapping);
        }
        int typeCode = type.getTypeCode();
        String packageName = ClassNameInfo.getQualifier(type.toString());
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = typeUri;
        }
        switch (typeCode) {
            case 11: {
                return null;
            }
            case 9: {
                QName arrName = new QName(namespaceURI, "tmp");
                String typeName = type.toString();
                int idx = typeName.indexOf(91);
                String save = typeName.substring(idx);
                typeName = typeName.substring(0, idx);
                String fixedupClassName = RmiModeler.getRealName(typeName.toString(), this.env);
                fixedupClassName = fixedupClassName + save;
                JavaArrayType javaArType = new JavaArrayType(fixedupClassName);
                javaArType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME.getLocalPart());
                SOAPArrayType arrType = new SOAPArrayType(arrName);
                arrType.setJavaType(javaArType);
                arrType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
                this.mapSOAPType(type, (SOAPType)arrType);
                SOAPType elemType = this.modelTypeSOAP(typeUri, type.getElementType());
                String tmp = elemType.getName().getLocalPart();
                arrName = new QName(namespaceURI, "ArrayOf" + tmp);
                SOAPType tmpSOAPType = elemType;
                while (tmpSOAPType instanceof SOAPArrayType) {
                    tmpSOAPType = ((SOAPArrayType)tmpSOAPType).getElementType();
                }
                if (!(tmpSOAPType instanceof SOAPSimpleType)) {
                    this.addTypeName(arrName, fixedupClassName);
                }
                arrType.setName(arrName);
                arrType.setElementType(elemType);
                if (elemType instanceof SOAPArrayType) {
                    arrType.setRank(((SOAPArrayType)elemType).getRank() + 1);
                } else {
                    arrType.setRank(1);
                }
                javaArType.setElementType(elemType.getJavaType());
                return arrType;
            }
            case 10: {
                Class typeClass;
                SOAPType holderType = this.modelHolder(this.modeler, this.env, typeUri, type);
                if (holderType != null) {
                    this.mapSOAPType(type, holderType);
                    return holderType;
                }
                QName structName = new QName(namespaceURI, ClassNameInfo.replaceInnerClassSym(type.typeString("", true, true)));
                SOAPOrderedStructureType struct = new SOAPOrderedStructureType(structName);
                String fixedupClassName = RmiModeler.getRealName(type.getClassName().toString(), this.env);
                this.addTypeName(structName, fixedupClassName);
                this.mapSOAPType(type, (SOAPType)struct);
                JavaStructureType javaStruct = new JavaStructureType(fixedupClassName, true, struct);
                struct.setJavaType(javaStruct);
                Map members = RmiStructure.modelTypeSOAP(this.env, type);
                Map members2 = JavaBean.modelTypeSOAP(this.env, type);
                if (members.size() != 0 && members2.size() != 0) {
                    Iterator keys = members.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (!members2.containsKey(key)) continue;
                        throw new ModelerException("rmimodeler.javabean.property.has.public.member", new Object[]{type.toString(), key});
                    }
                }
                members.putAll(members2);
                if (members.size() == 0) {
                    throw new ModelerException("rmimodeler.invalid.rmi.type", type.toString());
                }
                try {
                    typeClass = RmiUtils.getClassForName(RmiModeler.getRealName(type.toString(), this.env), this.env.getClassLoader());
                    if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
                        ((JavaStructureType)struct.getJavaType()).setAbstract(true);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ModelerException("rmimodeler.class.not.found", type.toString());
                }
                ArrayList sortedMembers = new ArrayList(members.size());
                RmiTypeModeler.sortMembers(typeClass, members, sortedMembers);
                Iterator iter = members.entrySet().iterator();
                while (iter.hasNext()) {
                    sortedMembers.add(iter.next().getValue());
                }
                this.fillInStructure(typeUri, struct, javaStruct, sortedMembers, type);
                return struct;
            }
        }
        throw new ModelerException("rmimodeler.unexpected.type", type.toString());
    }

    public SOAPSimpleTypeCreator getSOAPTypes() {
        return this.soapTypes;
    }

    private SOAPType modelHolder(RmiModeler modeler, BatchEnvironment env, String typeUri, Type type) {
        Type holderValueType = RmiTypeModeler.getHolderValueType(env, modeler.getDefHolder(), type);
        if (holderValueType == null) {
            return null;
        }
        SOAPType holderSOAPType = this.modelTypeSOAP(typeUri, holderValueType);
        JavaType javaType = holderSOAPType.getJavaType();
        javaType.setHolder(true);
        javaType.setHolderPresent(true);
        javaType.setHolderName(type.toString());
        return holderSOAPType;
    }

    private void modelSubclasses(String typeUri, JavaStructureType type) {
        try {
            Class typeClass = RmiUtils.getClassForName(type.getRealName(), this.env.getClassLoader());
            if (!typeClass.isInterface() && !Modifier.isAbstract(typeClass.getModifiers())) {
                return;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", type.getRealName());
        }
        int startSize = this.soapTypeMap.size();
        int curSize = 0;
        block2: while (curSize != startSize) {
            curSize = startSize;
            Iterator iterator = this.soapTypeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                JavaStructureType javaType;
                SOAPType extraType = (SOAPType)iterator.next().getValue();
                if (!(extraType instanceof SOAPStructureType) || type.equals(javaType = (JavaStructureType)extraType.getJavaType()) || !RmiTypeModeler.isSubclass(javaType.getRealName(), type.getRealName(), this.env.getClassLoader())) continue;
                this.modelHierarchy(typeUri, javaType, type);
                curSize = this.soapTypeMap.size();
                if (curSize == startSize) continue;
                startSize = curSize;
                curSize = 0;
                continue block2;
            }
        }
    }

    public boolean modelHierarchy(String typeUri, JavaStructureType subclass, JavaStructureType superclassType) {
        String superClassName = superclassType.getRealName();
        SOAPStructureType superSOAPType = (SOAPStructureType)superclassType.getOwner();
        SOAPStructureType soapType = (SOAPStructureType)subclass.getOwner();
        if (soapType.getParentType() != null) {
            if (soapType.getParentType().equals(superSOAPType)) {
                return true;
            }
            if (RmiTypeModeler.isSubclass(soapType.getParentType().getJavaType().getRealName(), superClassName, this.env.getClassLoader())) {
                SOAPStructureType tmpType = soapType;
                while (tmpType.getParentType() != null) {
                    if ((tmpType = tmpType.getParentType()).getJavaType().getRealName().equals(superClassName)) {
                        return true;
                    }
                    if (RmiTypeModeler.isSubclass(tmpType.getJavaType().getRealName(), superClassName, this.env.getClassLoader())) continue;
                    throw new ModelerException("rmimodeler.type.is.used.as.two.types", new Object[]{subclass.getRealName(), tmpType.getJavaType().getRealName(), superClassName});
                }
                return this.modelHierarchy(typeUri, (JavaStructureType)tmpType.getJavaType(), superclassType);
            }
            if (!RmiTypeModeler.isSubclass(superClassName, soapType.getParentType().getJavaType().getRealName(), this.env.getClassLoader())) {
                if (soapType.getParentType().getJavaType().getRealName().equals(superClassName)) {
                    return true;
                }
                throw new ModelerException("rmimodeler.type.is.used.as.two.types", new Object[]{subclass.getRealName(), soapType.getParentType().getJavaType().getRealName(), superClassName});
            }
        }
        try {
            Class subclassClass = RmiUtils.getClassForName(subclass.getRealName(), this.env.getClassLoader());
            Class superclass = subclassClass.getSuperclass();
            if (superclass == null || !superclass.getName().equals(superClassName) && !RmiTypeModeler.isSubclass(superclass.getName(), superClassName, this.env.getClassLoader())) {
                Class<?>[] interfaces = subclassClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (interfaces[i].getName().equals(superClassName)) {
                        superSOAPType.addSubtype((SOAPStructureType)subclass.getOwner());
                        ((JavaStructureType)superSOAPType.getJavaType()).addSubclass(subclass);
                        return true;
                    }
                    if (RmiTypeModeler.isSubclass(interfaces[i].getName(), superClassName, this.env.getClassLoader())) {
                        String classSig = RmiUtils.getTypeSig(interfaces[i].getName());
                        Type type = Type.tType((String)classSig);
                        SOAPStructureType superType = (SOAPStructureType)this.modelTypeSOAP(typeUri, type);
                        superType.addSubtype((SOAPStructureType)subclass.getOwner());
                        ((JavaStructureType)superType.getJavaType()).addSubclass(subclass);
                        return this.modelHierarchy(typeUri, (JavaStructureType)superType.getJavaType(), superclassType);
                    }
                    ++i;
                }
            }
            String classSig = RmiUtils.getTypeSig(superclass.getName());
            Type type = Type.tType((String)classSig);
            SOAPStructureType superType = (SOAPStructureType)this.modelTypeSOAP(typeUri, type);
            superType.addSubtype((SOAPStructureType)subclass.getOwner());
            ((JavaStructureType)superType.getJavaType()).addSubclass(subclass);
            if (!superclass.getName().equals(superClassName)) {
                return this.modelHierarchy(typeUri, (JavaStructureType)superType.getJavaType(), superclassType);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", subclass.getRealName());
        }
    }

    public static boolean isSubclass(String subtypeName, String supertypeName, ClassLoader classLoader) {
        String className = subtypeName;
        if (subtypeName.equals(supertypeName)) {
            return false;
        }
        try {
            Class subClass = RmiUtils.getClassForName(className, classLoader);
            className = supertypeName;
            Class<?> supertypeClass = Class.forName(className, true, classLoader);
            return supertypeClass.isAssignableFrom(subClass);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", className);
        }
    }

    public static Type getHolderValueType(BatchEnvironment env, ClassDefinition defHolder, Type type) {
        ClassDefinition def;
        if (type.getTypeCode() != 10) {
            return null;
        }
        ClassDeclaration decl = env.getClassDeclaration(type);
        try {
            def = decl.getClassDefinition((Environment)env);
        }
        catch (ClassNotFound ex) {
            throw new ModelerException("rmimodeler.class.not.found", type.toString());
        }
        ClassDeclaration[] interfaces = def.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            try {
                ClassDefinition interfaceDef = interfaces[i].getClassDefinition((Environment)env);
                if (defHolder.implementedBy((Environment)env, interfaces[i])) {
                    MemberDefinition member = RmiTypeModeler.getValueMember(env, def);
                    return member != null ? member.getType() : null;
                }
            }
            catch (ClassNotFound ex) {
                throw new ModelerException("rmimodeler.class.not.found", interfaces[i].getName().toString());
            }
            ++i;
        }
        return null;
    }

    public static MemberDefinition getValueMember(BatchEnvironment env, ClassDefinition classDef) {
        MemberDefinition member = classDef.getFirstMatch(Identifier.lookup((String)"value"));
        if (member == null) {
            ClassDeclaration superDec = classDef.getSuperClass();
            try {
                member = RmiTypeModeler.getValueMember(env, superDec.getClassDefinition((Environment)env));
            }
            catch (ClassNotFound ex) {
                throw new ModelerException("rmimodeler.class.not.found", superDec.getName().toString());
            }
        }
        return member;
    }

    private SOAPType processTypeMapping(BatchEnvironment env, TypeMappingInfo typeMapping) {
        RmiTypeModeler.log(env, "creating custom type for: " + typeMapping.getJavaTypeName());
        SOAPCustomType soapType = new SOAPCustomType(typeMapping.getXMLType());
        JavaCustomType javaType = new JavaCustomType(typeMapping.getJavaTypeName(), typeMapping);
        soapType.setJavaType(javaType);
        this.mapSOAPType(javaType.getRealName(), (SOAPType)soapType);
        return soapType;
    }

    private void fillInStructure(String typeUri, SOAPStructureType struct, JavaStructureType javaStruct, List sortedMembers, Type type) {
        BatchEnvironment env = this.modeler.getBatchEnvironment();
        Iterator iter = sortedMembers.iterator();
        while (iter.hasNext()) {
            MemberInfo memInfo = (MemberInfo)iter.next();
            SOAPStructureMember member = new SOAPStructureMember(new QName(null, memInfo.getName()), this.modelTypeSOAP(typeUri, memInfo.getType()));
            JavaStructureMember javaMember = new JavaStructureMember(memInfo.getName(), member.getType().getJavaType(), member, memInfo.isPublic());
            member.setJavaStructureMember(javaMember);
            javaMember.setReadMethod(memInfo.getReadMethod());
            javaMember.setWriteMethod(memInfo.getWriteMethod());
            javaStruct.add(javaMember);
            struct.add(member);
        }
        RmiTypeModeler.markInheritedMembers(env, struct);
    }

    public static void sortMembers(Class typeClass, Map members, List sortedMembers) {
        if (typeClass.getSuperclass() != null) {
            RmiTypeModeler.sortMembers(typeClass.getSuperclass(), members, sortedMembers);
        }
        Class<?>[] interfaces = typeClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            RmiTypeModeler.sortMembers(interfaces[i], members, sortedMembers);
            ++i;
        }
        Iterator iter = members.entrySet().iterator();
        while (iter.hasNext()) {
            MemberInfo memInfo = (MemberInfo)iter.next().getValue();
            if (!RmiTypeModeler.memberOfClass(memInfo, typeClass)) continue;
            sortedMembers.add(memInfo);
            iter.remove();
        }
    }

    public static boolean memberOfClass(MemberInfo memInfo, Class typeClass) {
        block5: {
            if (memInfo.isPublic()) {
                try {
                    Field field = typeClass.getDeclaredField(memInfo.getName());
                    if (field.getDeclaringClass().equals(typeClass)) {
                        return true;
                    }
                    break block5;
                }
                catch (NoSuchFieldException e) {
                    return false;
                }
            }
            String methodName = memInfo.getReadMethod();
            Class[] args = new Class[]{};
            boolean isInherited = RmiTypeModeler.isMethodInherited(methodName, args, typeClass);
            methodName = memInfo.getWriteMethod();
            if (methodName != null) {
                isInherited = isInherited ? RmiTypeModeler.isMethodInherited(methodName, args, typeClass) : false;
            }
            return !isInherited;
        }
        return true;
    }

    public static void markInheritedMembers(BatchEnvironment env, SOAPStructureType struct) {
        String className = struct.getJavaType().getRealName();
        try {
            Iterator members = struct.getMembers();
            Class javaClass = RmiUtils.getClassForName(className, env.getClassLoader());
            if (javaClass.isInterface() || Modifier.isAbstract(javaClass.getModifiers())) {
                ((JavaStructureType)struct.getJavaType()).setAbstract(true);
            }
            Class superclass = javaClass.getSuperclass();
            while (members.hasNext()) {
                SOAPStructureMember soapMember = (SOAPStructureMember)members.next();
                JavaStructureMember javaMember = soapMember.getJavaStructureMember();
                if (javaMember.isPublic()) {
                    try {
                        Field field = javaClass.getDeclaredField(javaMember.getName());
                        if (field.getDeclaringClass().equals(javaClass)) continue;
                        javaMember.setInherited(true);
                        soapMember.setInherited(true);
                    }
                    catch (NoSuchFieldException e) {
                        javaMember.setInherited(true);
                        soapMember.setInherited(true);
                    }
                    continue;
                }
                String methodName = javaMember.getReadMethod();
                Class[] args = new Class[]{};
                boolean isInherited = RmiTypeModeler.isMethodInherited(methodName, args, javaClass);
                methodName = javaMember.getWriteMethod();
                if (methodName != null) {
                    boolean bl = isInherited = isInherited ? RmiTypeModeler.isMethodInherited(methodName, args, javaClass) : false;
                }
                if (!isInherited) continue;
                javaMember.setInherited(true);
                soapMember.setInherited(true);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", className);
        }
    }

    private static boolean isMethodInherited(String methodName, Class[] args, Class javaClass) {
        Method method;
        try {
            method = javaClass.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        Class superclass = javaClass.getSuperclass();
        if (superclass != null) {
            try {
                method = superclass.getDeclaredMethod(methodName, args);
                return true;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Class<?>[] interfaces = javaClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            try {
                method = interfaces[i].getDeclaredMethod(methodName, args);
                return true;
            }
            catch (NoSuchMethodException e) {
                ++i;
            }
        }
        return false;
    }

    public void modelSubclasses(String typeUri) {
        SOAPType type;
        HashSet<SOAPType> abstractTypes = new HashSet<SOAPType>();
        int startSize = this.soapTypeMap.size();
        Iterator iter = this.soapTypeMap.entrySet().iterator();
        while (iter.hasNext()) {
            type = (SOAPType)iter.next().getValue();
            if (!(type instanceof SOAPStructureType) || !((JavaStructureType)type.getJavaType()).isAbstract()) continue;
            abstractTypes.add(type);
        }
        iter = abstractTypes.iterator();
        while (iter.hasNext()) {
            type = (SOAPType)((Object)iter.next());
            this.modelSubclasses(typeUri, (JavaStructureType)type.getJavaType());
        }
        if (startSize != this.soapTypeMap.size()) {
            iter = this.soapTypeMap.entrySet().iterator();
            while (iter.hasNext()) {
                type = (SOAPType)iter.next().getValue();
                if (!(type instanceof SOAPStructureType) || !((JavaStructureType)type.getJavaType()).isAbstract() || abstractTypes.contains(type)) continue;
                this.modelSubclasses(typeUri, (JavaStructureType)type.getJavaType());
            }
        }
    }

    private SOAPType getMappedSoapType(Type type) {
        String name = type.toString();
        return (SOAPType)this.soapTypeMap.get(name);
    }

    private void mapSOAPType(Type type, SOAPType soapType) {
        this.mapSOAPType(type.toString(), soapType);
    }

    private void mapSOAPType(String name, SOAPType soapType) {
        this.soapTypeMap.put(name, soapType);
    }

    private void addTypeName(QName typeName, String javaType) {
        if (this.typeNames.contains(typeName)) {
            throw new ModelerException("rmimodeler.duplicate.type.name", new Object[]{typeName.toString(), javaType});
        }
        this.typeNames.add(typeName);
    }

    private static void log(BatchEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[RmiTypeModeler: " + msg + "]");
        }
    }

    public void initializeTypeMap(Map typeMap) {
        typeMap.put(ModelerConstants.BOXED_BOOLEAN_CLASSNAME, this.soapTypes.SOAP_BOXED_BOOLEAN_SOAPTYPE);
        typeMap.put(ModelerConstants.BOOLEAN_CLASSNAME, this.soapTypes.XSD_BOOLEAN_SOAPTYPE);
        typeMap.put(ModelerConstants.BOXED_BYTE_CLASSNAME, this.soapTypes.SOAP_BOXED_BYTE_SOAPTYPE);
        typeMap.put(ModelerConstants.BYTE_CLASSNAME, this.soapTypes.XSD_BYTE_SOAPTYPE);
        typeMap.put(ModelerConstants.BYTE_ARRAY_CLASSNAME, this.soapTypes.XSD_BYTE_ARRAY_SOAPTYPE);
        typeMap.put(ModelerConstants.BOXED_DOUBLE_CLASSNAME, this.soapTypes.SOAP_BOXED_DOUBLE_SOAPTYPE);
        typeMap.put(ModelerConstants.DOUBLE_CLASSNAME, this.soapTypes.XSD_DOUBLE_SOAPTYPE);
        typeMap.put(ModelerConstants.BOXED_FLOAT_CLASSNAME, this.soapTypes.SOAP_BOXED_FLOAT_SOAPTYPE);
        typeMap.put(ModelerConstants.FLOAT_CLASSNAME, this.soapTypes.XSD_FLOAT_SOAPTYPE);
        typeMap.put(ModelerConstants.BOXED_INTEGER_CLASSNAME, this.soapTypes.SOAP_BOXED_INTEGER_SOAPTYPE);
        typeMap.put(ModelerConstants.INT_CLASSNAME, this.soapTypes.XSD_INT_SOAPTYPE);
        typeMap.put(ModelerConstants.BOXED_LONG_CLASSNAME, this.soapTypes.SOAP_BOXED_LONG_SOAPTYPE);
        typeMap.put(ModelerConstants.LONG_CLASSNAME, this.soapTypes.XSD_LONG_SOAPTYPE);
        typeMap.put(ModelerConstants.BOXED_SHORT_CLASSNAME, this.soapTypes.SOAP_BOXED_SHORT_SOAPTYPE);
        typeMap.put(ModelerConstants.SHORT_CLASSNAME, this.soapTypes.XSD_SHORT_SOAPTYPE);
        typeMap.put(ModelerConstants.STRING_CLASSNAME, this.soapTypes.XSD_STRING_SOAPTYPE);
        typeMap.put(ModelerConstants.BIGDECIMAL_CLASSNAME, this.soapTypes.XSD_DECIMAL_SOAPTYPE);
        typeMap.put(ModelerConstants.BIGINTEGER_CLASSNAME, this.soapTypes.XSD_INTEGER_SOAPTYPE);
        typeMap.put(ModelerConstants.DATE_CLASSNAME, this.soapTypes.XSD_DATE_TIME_SOAPTYPE);
        typeMap.put(ModelerConstants.CALENDAR_CLASSNAME, this.soapTypes.XSD_DATE_TIME_CALENDAR_SOAPTYPE);
        typeMap.put(ModelerConstants.QNAME_CLASSNAME, this.soapTypes.XSD_QNAME_SOAPTYPE);
        typeMap.put(ModelerConstants.VOID_CLASSNAME, this.soapTypes.XSD_VOID_SOAPTYPE);
        typeMap.put(ModelerConstants.OBJECT_CLASSNAME, this.soapTypes.XSD_ANYTYPE_SOAPTYPE);
        typeMap.put(ModelerConstants.COLLECTION_CLASSNAME, this.soapTypes.COLLECTION_SOAPTYPE);
        typeMap.put(ModelerConstants.LIST_CLASSNAME, this.soapTypes.LIST_SOAPTYPE);
        typeMap.put(ModelerConstants.SET_CLASSNAME, this.soapTypes.SET_SOAPTYPE);
        typeMap.put(ModelerConstants.VECTOR_CLASSNAME, this.soapTypes.VECTOR_SOAPTYPE);
        typeMap.put(ModelerConstants.STACK_CLASSNAME, this.soapTypes.STACK_SOAPTYPE);
        typeMap.put(ModelerConstants.LINKED_LIST_CLASSNAME, this.soapTypes.LINKED_LIST_SOAPTYPE);
        typeMap.put(ModelerConstants.ARRAY_LIST_CLASSNAME, this.soapTypes.ARRAY_LIST_SOAPTYPE);
        typeMap.put(ModelerConstants.HASH_SET_CLASSNAME, this.soapTypes.HASH_SET_SOAPTYPE);
        typeMap.put(ModelerConstants.TREE_SET_CLASSNAME, this.soapTypes.TREE_SET_SOAPTYPE);
        typeMap.put(ModelerConstants.MAP_CLASSNAME, this.soapTypes.MAP_SOAPTYPE);
        typeMap.put(ModelerConstants.HASH_MAP_CLASSNAME, this.soapTypes.HASH_MAP_SOAPTYPE);
        typeMap.put(ModelerConstants.TREE_MAP_CLASSNAME, this.soapTypes.TREE_MAP_SOAPTYPE);
        typeMap.put(ModelerConstants.HASHTABLE_CLASSNAME, this.soapTypes.HASHTABLE_SOAPTYPE);
        typeMap.put(ModelerConstants.PROPERTIES_CLASSNAME, this.soapTypes.PROPERTIES_SOAPTYPE);
        typeMap.put(ModelerConstants.IMAGE_CLASSNAME, this.soapTypes.IMAGE_SOAPTYPE);
        typeMap.put(ModelerConstants.MIME_MULTIPART_CLASSNAME, this.soapTypes.MIME_MULTIPART_SOAPTYPE);
        typeMap.put(ModelerConstants.SOURCE_CLASSNAME, this.soapTypes.SOURCE_SOAPTYPE);
        typeMap.put(ModelerConstants.DATA_HANDLER_CLASSNAME, this.soapTypes.DATA_HANDLER_SOAPTYPE);
        typeMap.put(ModelerConstants.JAX_RPC_MAP_ENTRY_CLASSNAME, this.soapTypes.JAX_RPC_MAP_ENTRY_SOAPTYPE);
    }

    private RmiTypeModeler() {
        this.typeNames = new HashSet();
        this.soapTypeMap = new HashMap();
        this.soapTypes = new SOAPSimpleTypeCreator();
        this.initializeTypeMap(this.soapTypeMap);
    }

    RmiTypeModeler(RmiModeler modeler, BatchEnvironment env) {
        this.modeler = modeler;
        this.env = env;
        this.typeMappingRegistry = modeler.getTypeMappingRegistryInfo();
        this.typeNames = new HashSet();
        this.soapTypeMap = new HashMap();
        this.soapTypes = new SOAPSimpleTypeCreator();
        this.initializeTypeMap(this.soapTypeMap);
    }
}

