/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.ProcessorEnvironmentBase;
import com.sun.xml.rpc.util.ClassNameInfo;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Identifier;

public class BatchEnvironment
extends sun.tools.javac.BatchEnvironment
implements ProcessorEnvironment {
    private URLClassLoader classLoader;
    private ProcessorNotificationListener _listener;
    private Names _names;
    private Vector generatedFiles = new Vector();
    private Map realNames = new HashMap();

    public static ClassPath createClassPath(String classPathString) {
        ClassPath[] paths = sun.tools.javac.BatchEnvironment.classPaths(null, (String)classPathString, null, null);
        return paths[1];
    }

    public BatchEnvironment(OutputStream out, ClassPath path, ProcessorNotificationListener listener) {
        super(out, path);
        this._listener = listener;
        this._names = new Names();
    }

    public BatchEnvironment(OutputStream out, ClassPath sourcePath, ClassPath path, ProcessorNotificationListener listener) {
        super(out, sourcePath, path);
        this._listener = listener;
        this._names = new Names();
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getClassPath() {
        return this.binaryPath.toString();
    }

    public void addGeneratedFile(File file) {
        this.generatedFiles.addElement(file);
    }

    public Iterator getGeneratedFiles() {
        return ((AbstractList)this.generatedFiles).iterator();
    }

    public void parseFile(File file) {
        try {
            this.parseFile(new ClassFile(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void deleteGeneratedFiles() {
        Vector vector = this.generatedFiles;
        synchronized (vector) {
            Enumeration enumeration = this.generatedFiles.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                file.delete();
            }
            this.generatedFiles.removeAllElements();
        }
    }

    public URLClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(ProcessorEnvironmentBase.pathToURLs(this.getClassPath().toString()));
        }
        return this.classLoader;
    }

    public void shutdown() {
        this._listener = null;
        this.generatedFiles = null;
        super.shutdown();
    }

    public void error(Localizable msg) {
        if (this._listener != null) {
            this._listener.onError(msg);
        }
        ++this.nerrors;
        this.flags |= 0x10000;
    }

    public void warn(Localizable msg) {
        if (this.warnings()) {
            ++this.nwarnings;
            if (this._listener != null) {
                this._listener.onWarning(msg);
            }
        }
    }

    public void info(Localizable msg) {
        if (this._listener != null) {
            this._listener.onInfo(msg);
        }
    }

    public void printStackTrace(Throwable t) {
        t.printStackTrace(System.err);
    }

    public Names getNames() {
        return this._names;
    }

    public String getRealName(String name) {
        String tmpName = (String)this.realNames.get(name);
        if (tmpName != null) {
            return tmpName;
        }
        String orig = name;
        tmpName = "";
        while (!tmpName.equals(name)) {
            tmpName = name;
            name = this.resolvePackageQualifiedName(Identifier.lookup((String)name)).toString();
            name = ClassNameInfo.mangleClass(name);
        }
        this.realNames.put(orig, name);
        return name;
    }
}

