/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ModelFileModelInfo;
import com.sun.xml.rpc.processor.config.RmiInterfaceInfo;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.XMLModelWriter;
import com.sun.xml.rpc.tools.wscompile.CompileTool;
import com.sun.xml.rpc.tools.wsdeploy.EndpointInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class EndpointCompileTool
extends CompileTool {
    protected EndpointInfo endpointInfo;
    protected WebServicesInfo webServicesInfo;
    protected File targetDirectory;
    protected boolean useModel;
    protected String additionalClasspath;
    private static final String PS = System.getProperty("path.separator");
    private static final char PSCHAR = System.getProperty("path.separator").charAt(0);
    private static final String FS = System.getProperty("file.separator");
    private static final char FSCHAR = System.getProperty("file.separator").charAt(0);

    public EndpointCompileTool(OutputStream out, String program, EndpointInfo ei, WebServicesInfo wsi, File dir, String classpath, ProcessorNotificationListener l) {
        super(out, program);
        this.endpointInfo = ei;
        this.webServicesInfo = wsi;
        this.targetDirectory = dir;
        this.additionalClasspath = classpath;
        this.listener = l;
        this.useModel = this.endpointInfo.getModel() != null;
    }

    protected void beforeHook() {
        String targetPath = this.targetDirectory.getAbsolutePath();
        this.userClasspath = targetPath + FS + "WEB-INF" + FS + "classes";
        if (this.additionalClasspath != null && this.additionalClasspath.length() > 0) {
            this.userClasspath = this.userClasspath + PS + this.additionalClasspath;
        }
        this.destDir = new File(this.userClasspath);
        this.nonclassDestDir = new File(targetPath + FS + "WEB-INF");
        if (!this.useModel) {
            this.modelFile = new File(this.makeModelFileName());
        }
        this.serializerInfix = "_" + this.endpointInfo.getName() + "_";
        this.keepGenerated = true;
        this.compilerDebug = false;
        this.compilerOptimize = true;
        super.beforeHook();
    }

    protected void withModelHook() {
        Iterator services;
        if ((this.endpointInfo.getClientHandlerChainInfo() != null || this.endpointInfo.getServerHandlerChainInfo() != null) && (services = this.processor.getModel().getServices()).hasNext()) {
            Service service = (Service)services.next();
            this.endpointInfo.setRuntimeServiceName(service.getName());
            Iterator ports = service.getPorts();
            if (ports.hasNext()) {
                Port port = (Port)ports.next();
                port.setClientHandlerChainInfo(this.endpointInfo.getClientHandlerChainInfo());
                port.setServerHandlerChainInfo(this.endpointInfo.getServerHandlerChainInfo());
            }
        }
    }

    protected void afterHook() {
        if (this.environment.nerrors == 0) {
            this.endpointInfo.setRuntimeModel(this.useModel ? this.endpointInfo.getModel() : this.makeAppRelative(this.modelFile));
            this.endpointInfo.setRuntimeWSDL(this.makeAppRelative(this.findGeneratedFileEndingWith(".wsdl")));
            Iterator services = this.processor.getModel().getServices();
            if (services.hasNext()) {
                Service service = (Service)services.next();
                this.endpointInfo.setRuntimeServiceName(service.getName());
                Iterator ports = service.getPorts();
                if (ports.hasNext()) {
                    Port port = (Port)ports.next();
                    QName portName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
                    if (portName == null) {
                        portName = port.getName();
                    }
                    this.endpointInfo.setRuntimePortName(portName);
                    JavaInterface intf = port.getJavaInterface();
                    this.endpointInfo.setRuntimeTie(this.environment.getNames().tieFor(intf));
                }
            }
        }
    }

    protected Configuration createConfiguration() throws Exception {
        Configuration config = new Configuration(this.environment);
        if (this.useModel) {
            ModelFileModelInfo modelInfo = new ModelFileModelInfo();
            modelInfo.setLocation(this.makeAbsolute(this.endpointInfo.getModel()));
            config.setModelInfo(modelInfo);
        } else {
            RmiModelInfo modelInfo = new RmiModelInfo();
            modelInfo.setName(this.endpointInfo.getName());
            modelInfo.setTargetNamespaceURI(this.makeTargetNamespaceURI());
            modelInfo.setTypeNamespaceURI(this.makeTypeNamespaceURI());
            modelInfo.setJavaPackageName(this.makeJavaPackageName());
            RmiInterfaceInfo interfaceInfo = new RmiInterfaceInfo();
            interfaceInfo.setName(this.endpointInfo.getInterface());
            interfaceInfo.setServantName(this.endpointInfo.getImplementation());
            interfaceInfo.setServerHandlerChainInfo(this.endpointInfo.getServerHandlerChainInfo());
            modelInfo.add(interfaceInfo);
            config.setModelInfo(modelInfo);
        }
        return config;
    }

    protected String makeTargetNamespaceURI() {
        String base = this.webServicesInfo.getTargetNamespaceBase();
        if (base.endsWith("/") || base.startsWith("urn:")) {
            return base + this.endpointInfo.getName();
        }
        return base + "/" + this.endpointInfo.getName();
    }

    protected String makeTypeNamespaceURI() {
        String base = this.webServicesInfo.getTypeNamespaceBase();
        if (base.endsWith("/") || base.startsWith("urn:")) {
            return base + this.endpointInfo.getName();
        }
        return base + "/" + this.endpointInfo.getName();
    }

    protected String makeModelFileName() {
        return this.targetDirectory.getAbsolutePath() + FS + "WEB-INF" + FS + this.endpointInfo.getName() + "_model.xml.gz";
    }

    protected String makeJavaPackageName() {
        return "jaxrpc.generated." + this.environment.getNames().validJavaPackageName(this.endpointInfo.getName());
    }

    protected String makeAbsolute(String s) {
        if (s == null) {
            return null;
        }
        return new File(this.targetDirectory.getAbsolutePath() + s).getAbsolutePath();
    }

    protected String makeAppRelative(File f) {
        String target;
        if (f == null) {
            return null;
        }
        String s = f.getAbsolutePath();
        if (s.startsWith(target = this.targetDirectory.getAbsolutePath())) {
            return s.substring(target.length()).replace(FSCHAR, '/');
        }
        return null;
    }

    protected File findGeneratedFileEndingWith(String s) {
        Iterator iter = this.environment.getGeneratedFiles();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            if (!file.getAbsolutePath().endsWith(s)) continue;
            return file;
        }
        return null;
    }

    protected void registerProcessorActions(Processor processor) {
        if (!this.useModel) {
            try {
                processor.add(new XMLModelWriter(this.modelFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        processor.add(this.getAction("enumeration.generator"));
        processor.add(this.getAction("enumeration.encoder.generator"));
        processor.add(this.getAction("holder.generator"));
        processor.add(this.getAction("custom.class.generator"));
        processor.add(this.getAction("soap.object.serializer.generator"));
        processor.add(this.getAction("interface.serializer.generator"));
        processor.add(this.getAction("soap.object.builder.generator"));
        processor.add(this.getAction("literal.object.serializer.generator"));
        processor.add(this.getAction("custom.exception.generator"));
        processor.add(this.getAction("soap.fault.serializer.generator"));
        processor.add(this.getAction("fault.exception.builder.generator"));
        processor.add(this.getAction("serializer.registry.generator"));
        processor.add(this.getAction("tie.generator"));
        processor.add(this.getAction("wsdl.generator"));
    }

    public void onError(Localizable msg) {
    }

    public void onWarning(Localizable msg) {
    }

    public void onInfo(Localizable msg) {
    }
}

