/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.tags;

import com.sun.xml.messaging.saaj.tags.JaxmEndpoint;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;

public class JaxmContext {
    Hashtable attributes = new Hashtable();
    PrintWriter out = null;
    String outType = null;
    int dL = 0;
    static Hashtable contexts = new Hashtable();
    String name;
    String jaxmJndiFactory;
    AttributeLiaison attributeLiaison = null;
    private static int id = 0;
    Vector providers = new Vector();
    String listenerURI = "";
    SOAPConnection con;
    String thisEndpoint;

    public static JaxmContext getJaxmContext() {
        return JaxmContext.getJaxmContext("default");
    }

    public static JaxmContext getJaxmContext(String name) {
        JaxmContext g;
        if (name == null) {
            name = "default";
        }
        if ((g = (JaxmContext)contexts.get(name)) == null) {
            g = new JaxmContext();
            contexts.put(name, g);
        }
        return g;
    }

    public static void addJaxmContext(String name, JaxmContext gctx) {
        if (gctx.dL > 0) {
            gctx.debug("Added JaxmContext " + name);
        }
        if (name == null) {
            name = "default";
        }
        contexts.put(name, gctx);
    }

    public void setWriter(PrintWriter pw) {
        this.out = pw;
    }

    public void setName(String s) {
        this.name = s;
        JaxmContext.addJaxmContext(this.name, this);
    }

    public void setDebug(int i) {
        this.dL = i;
    }

    public void setJndiLookup(String s) {
        this.jaxmJndiFactory = s;
    }

    public String getJndiLookup() {
        return this.jaxmJndiFactory;
    }

    public void setAttributeLiaison(AttributeLiaison aL) {
        this.attributeLiaison = aL;
    }

    public AttributeLiaison getAttributeLiaison() {
        if (this.attributeLiaison == null) {
            this.attributeLiaison = new SimpleAttributes();
        }
        return this.attributeLiaison;
    }

    public Object getAttribute(String name) {
        return this.getAttributeLiaison().getAttribute(name);
    }

    public void setAttribute(String s, Object v) {
        this.getAttributeLiaison().setAttribute(s, v);
    }

    public Enumeration getAttributes() {
        return this.getAttributeLiaison().getAttributes();
    }

    public void reset() {
        this.getAttributeLiaison().reset();
    }

    public synchronized int getId() {
        return id++;
    }

    public void execute() throws Exception {
        final JaxmContext jctx = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                jctx.setAttributes();
                return null;
            }
        });
    }

    public void setAttributes() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
            SOAPConnection conn = factory.createConnection();
            MessageFactory mf = MessageFactory.newInstance();
            this.setAttribute("jaxmConnection", conn);
            this.setAttribute("jaxmMessageFactory", mf);
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Exception ex) {
            this.dumpException(ex);
        }
    }

    public void addJaxmEndpoint(JaxmEndpoint p) {
        this.providers.addElement(p);
    }

    public void addURIMapping(String endpointS, URL url) {
        if (this.dL > 0) {
            this.debug("Adding mapping " + endpointS + " " + url);
        }
    }

    public void debug(String s) {
        System.out.println("JaxmContext: " + s);
    }

    public void dumpException(Throwable e) {
        e.printStackTrace();
        while (e instanceof SOAPException) {
            if ((e = ((SOAPException)e).getCause()) == null) continue;
            e.printStackTrace();
        }
    }

    public static class SimpleAttributes
    implements AttributeLiaison {
        Hashtable attributes = new Hashtable();

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void setAttribute(String s, Object v) {
            if (v == null) {
                this.attributes.remove(s);
            } else {
                this.attributes.put(s, v);
            }
        }

        public Enumeration getAttributes() {
            return this.attributes.keys();
        }

        public void reset() {
            this.attributes.clear();
        }
    }

    public static interface AttributeLiaison {
        public Object getAttribute(String var1);

        public void setAttribute(String var1, Object var2);

        public Enumeration getAttributes();

        public void reset();
    }
}

