/**
 * Copyright @ 2002 Lars Rwekamp (lars.roewekamp@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.wstutorial.currencyconverter;

import java.rmi.Remote;
import java.rmi.RemoteException;


/**
 * Das Interface CurrencyConverter bildet einen einfachen
 * Waehrungsrechner nach.
 *
 */
public interface CurrencyConverter extends Remote {

   /** Umrechnung eines Wertes einer Originalwaehrung in den entsprechenden
     * Wert einer angegebenen Zielwaehrung.
     *
     * @param value             Umzurechnender Wert
     * @param fromCurrency      Original Waehrung
     * @param toCurrency        Zielwaehrung
     * @return                  Umgerechneter Wert in neuer Zielwaehrung
     * @throws RemoteException  Remote Exception
     */
    public double convertCurrency(float value, String fromCurrency, String toCurrency) throws RemoteException;

}
