
/**
 *  Copyright @ 2002 Lars Rwekamp (lars.roewekamp@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.wstutorial.currencyconverter;


/* imports */


import javax.servlet.http.*;
import javax.servlet.*;

import de.ix.wstutorial.currencyconverter.generated.client.*;

import java.text.NumberFormat;
import java.util.Locale;

/**
 * Einfaches Servlet zum Umrechner einer Ursprungswaehrung in
 * eine Zielwaehrung mittels SOAP Call.
 *
 * Das Servlet baut die Anfrage zunaechst auf und setzt sie
 * anschliessend ab. Es nutzt dabei generierte Stubs, die
 * durch das Tool xrpcc erzeugt worden.
 *
 */
public class CurrencyConverterServlet extends HttpServlet {


    /* private */

    /*
     *  Zielseite, die nach erfolgreicher Abarbeitung angezeigt werden soll.
     */
    private static final String TARGET_VIEW = "/jsp/de/currencyconverter.jsp";


    /*
     * Parameter, die als Eingabe erwartet werden
     */
    private final static String PARAM_FROM_CURRENCY = "fromCurrency";
    private final static String PARAM_TO_CURRENCY = "toCurrency";
    private final static String PARAM_FROM_VALUE = "fromValue";

    /*
     * Standardwert, der bei fehlender Eingabe gesetzt wird.
     */
    private final static String DEFAULT_FROM_CURRENCY = "DEM";
    private final static String DEFAULT_TO_CURRENCY = "EUR";
    private final static String DEFAULT_FROM_VALUE = "0.00";

    /*
     * Attribute, die nach der Abarbeitung im Request Objekt gesetzt
     * und innerhalb der JSP ausgewertet werden.
     */
    private final static String ATTR_FROM_CURRENCY = "fromCurrency";
    private final static String ATTR_TO_CURRENCY = "toCurrency";
    private final static String ATTR_FROM_CURRENCY_VALUE = "fromCurrencyValue";
    private final static String ATTR_TO_CURRENCY_VALUE = "toCurrencyValue";
    private final static String ATTR_CURRENCY_CONVERTER_FLAG = "currencyConverterFlag";
    private final static String DEFAULT_CURRENCY_CONVERTER_FLAG = "TRUE";

    /*
    *  Fehlermeldungen
    */
    private final static String ATTR_CURRENCY_CONVERTER_ERROR_FLAG = "currencyConverterErrorFlag";
    private final static String DEFAULT_CURRENCY_CONVERTER_ERROR_FLAG = "TRUE";
    private final static String ATTR_ERROR_TEXT = "errorText";
    private final static String ATTR_ERROR_NUMBER_FORMAT = "Kein gltiger Betrag.";
    private final static String ATTR_ERROR_UNKNOWN_CURRENCY = "Keine gltige Whrung.";

    /**
     * Initialisierung des Servlets.
     *
     * @param servletConfig       Aktuelle Konfiguration des Servlets
     * @throws javax.servlet.ServletException   Servlet spezifische Exception
     */

    public void init(ServletConfig servletConfig) throws
            ServletException {
        super.init(servletConfig);
    }


    /**
     * Verabeitung eines HTTP Get Aufrufs.
     *
     * Diese Methode ruft mit Hilfe des JAX-RPC API einen
     * Web Service auf und stellt das Ergebins zur Verfuegung.
     *
     * @param request              HTTP Servlet Request Objekt
     * @param response             HTTP Servlet Response Objekt
     * @throws javax.servlet.ServletException    Servlet spezifische Exception
     */

    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException {


        try {

            /* Auslesen der Parameter aus dem HTTP Request.
               Ist kein Parameter vorhanden wird ein
               Standardwert gesetzt.
            */

            String fromCurrency = request.getParameter(PARAM_FROM_CURRENCY);
            String toCurrency = request.getParameter(PARAM_TO_CURRENCY);
            String fromValue = request.getParameter(PARAM_FROM_VALUE);

            double unconvertedValue = 0.00;
            double convertedValue = 0.00;

            if (fromCurrency == null || fromCurrency.equals("")) {
                fromCurrency = DEFAULT_FROM_CURRENCY;
            }

            if (toCurrency == null || toCurrency.equals("")) {
                toCurrency = DEFAULT_TO_CURRENCY;
            }

            if (fromValue == null || fromValue.equals("")) {
                fromValue = DEFAULT_FROM_VALUE;
            }

            try {

                CurrencyObject fromCurrencyObject = CurrencyMap.getCurrencyObject(fromCurrency);
                CurrencyObject toCurrencyObject   = CurrencyMap.getCurrencyObject(toCurrency);

                unconvertedValue = Double.parseDouble(fromValue);
                Double myDouble = new Double(fromValue);

                /* Aufruf des eigentlichen Web Services mit Hilfe
                   der generierten Klassen und dem uebergebenen
                   Parameter.
                 */

                CurrencyConverter_Service service = new CurrencyConverter_Service_Impl();
                CurrencyConverter_PortType stub = (CurrencyConverter_PortType_Stub) service.getCurrencyConverterPort();
                convertedValue = stub.convertCurrency(myDouble.floatValue(), fromCurrency, toCurrency);

                /* Werte fuer spaetere Darstellung in der JSP setzen  */

                request.setAttribute(ATTR_CURRENCY_CONVERTER_FLAG, DEFAULT_CURRENCY_CONVERTER_FLAG);
                request.setAttribute(ATTR_FROM_CURRENCY, fromCurrency);
                request.setAttribute(ATTR_TO_CURRENCY, toCurrency);


                /* genau zwei Stellen hinter dem Komma anzeigen */
                NumberFormat fromNumberValue = NumberFormat.getInstance();
                fromNumberValue.setMinimumFractionDigits(2);
                fromNumberValue.setMaximumFractionDigits(2);

                NumberFormat toNumberValue = NumberFormat.getInstance();
                toNumberValue.setMinimumFractionDigits(2);
                toNumberValue.setMaximumFractionDigits(2);

                /* Waehrung und Waehrungsbeschreibung setzen */
                request.setAttribute(ATTR_FROM_CURRENCY_VALUE, fromNumberValue.format(unconvertedValue));
                request.setAttribute(ATTR_TO_CURRENCY_VALUE,   toNumberValue.format(convertedValue));

                if (fromCurrencyObject != null) {
                    request.setAttribute(ATTR_FROM_CURRENCY, fromCurrencyObject.getCode() + " (" +
                                                             fromCurrencyObject.getDescription() + ")" );
                } else {
                    request.setAttribute(ATTR_FROM_CURRENCY, fromCurrency);
                }

                if (toCurrencyObject != null) {
                    request.setAttribute(ATTR_TO_CURRENCY, toCurrencyObject.getCode() + " (" +
                                                           toCurrencyObject.getDescription() + ")" );
                } else {
                    request.setAttribute(ATTR_TO_CURRENCY, toCurrency);
                }

                /* konvertierten und unkonvertierten Wert setzen */
                request.setAttribute(ATTR_FROM_CURRENCY_VALUE, fromNumberValue.format(unconvertedValue));
                request.setAttribute(ATTR_TO_CURRENCY_VALUE,   toNumberValue.format(convertedValue));


            } catch (NumberFormatException ex) {

                /* Fehlernachricht fuer die spaetere Anzeige in der JSP setzen */
                request.setAttribute(ATTR_CURRENCY_CONVERTER_ERROR_FLAG, DEFAULT_CURRENCY_CONVERTER_ERROR_FLAG);
                request.setAttribute(ATTR_ERROR_TEXT, ATTR_ERROR_NUMBER_FORMAT);
            } catch (Exception ex) {

                /* Fehlernachricht fuer die spaetere Anzeige in der JSP setzen */
                request.setAttribute(ATTR_CURRENCY_CONVERTER_ERROR_FLAG, DEFAULT_CURRENCY_CONVERTER_ERROR_FLAG);
                request.setAttribute(ATTR_ERROR_TEXT, ATTR_ERROR_UNKNOWN_CURRENCY);
            }

            /* Ziel JSP zur Anzeige des Ergebnisses aufrufen */

            request.getRequestDispatcher(TARGET_VIEW).forward(request, response);

        } catch (Exception e) {

            /* generelles, rudimentares Exception Handling */

            e.printStackTrace();
            e.getMessage();

        }

    }


}

