package com.iternum.micro.midlet;

import com.iternum.micro.translator.*;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

import java.util.Vector;
/**
 * <p>Title: SOAP Demo fr Java MIDP 1.0 und kSoap</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: iternum GmbH</p>
 * @author Karl F. Banke
 * @version 1.0
 */

public class TranslatorMidlet extends MIDlet implements CommandListener {

  static TranslatorMidlet instance;

  /**
   * The list where all results are listed
   */
  ResultList      resultList;

  /**
   * The panel used to enter the term to translate
   */
  TranslatorEntry entryPane = new TranslatorEntry();

  /**
   * The result item used to display a single result
   */
  ResultItem      resultItem = new ResultItem();

  /**
   * The proxy to call for the translation service
   */
  TranslatorService service = new TranslatorService();

  /**
   * Current translation result Vector.
   */
  Vector results;

  /** Constructor */
  public TranslatorMidlet() {
    instance = this;
  }

  /** Main method */
  public void startApp() {
    entryPane.setCommandListener(this);
    resultItem.setCommandListener(this);
    Display.getDisplay(this).setCurrent(entryPane);
  }

  /** Handle pausing the MIDlet */
  public void pauseApp() {
  }

  /** Handle destroying the MIDlet */
  public void destroyApp(boolean unconditional) {
  }

  public void commandAction(Command command, Displayable source) {
    if (source == entryPane && command.getCommandType() == Command.EXIT) {
      this.quitApp();
    } else if (source == entryPane && command.getCommandType() == Command.OK) {
      if (entryPane.getString() != null && entryPane.getString().trim().length() != 0) {
        int numResults = getTranslations(entryPane.getString().trim());
        if (numResults > 0) {
          showResultList();
        } else {
        }
      }
    } else if (source == resultList && command.getCommandType() == Command.EXIT) {
      entryPane.setString("");
      Display.getDisplay(this).setCurrent(entryPane);
    } else if (source == resultList && command.getCommandType() == Command.OK) {
      int selected = resultList.getSelectedIndex();
      resultItem.setStrings((String)results.elementAt(2*selected+1)
        ,(String)results.elementAt(2*selected));
      Display.getDisplay(this).setCurrent(resultItem);
    } else if (source == resultItem && command.getCommandType() == Command.EXIT) {
      showResultList();
    }
  }

  /**
   * Call the Webservice passing term as the term to be translated
   */
  public int getTranslations(String term) {
    results = service.retrieveTranslations(term,"de","en");
    if (results != null && results.size() > 0) {
      for (int i=0;i<results.size();i++) {
        try {
          results.setElementAt(new String(((String)results.elementAt(i)).getBytes(),"UTF_8"),i);
        } catch (Exception exc) {
        }
      }
    }
    return results.size();
  }

  protected void showResultList() {
    resultList = new ResultList();
    resultList.setCommandListener(this);
    for (int i=1;i<results.size();i+=2) {
      resultList.append((String)results.elementAt(i),null);
    }
    Display.getDisplay(this).setCurrent(resultList);
  }

  /** Quit the MIDlet */
  public static void quitApp() {
    instance.destroyApp(true);
    instance.notifyDestroyed();
    instance = null;
  }

}
