/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.services;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.services.Event;
import org.apache.commons.services.EventFactory;
import org.apache.commons.services.EventRegistration;
import org.apache.commons.services.Module;

public class EventModule
extends Module {
    protected EventRegistration defaultEventRegistration = null;
    protected Map eventRegistrations = new HashMap();
    protected GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)this.createEventFactory());

    public void releaseEvent(Event event) {
        try {
            this.pool.returnObject((Object)event.getEventRegistration().getName(), (Object)event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EventModule() {
        this.defaultEventRegistration = this.createDefaultEventRegistration();
    }

    protected EventFactory createEventFactory() {
        EventFactory eventFactory = new EventFactory();
        eventFactory.setEventModule(this);
        return eventFactory;
    }

    protected EventRegistration createDefaultEventRegistration() {
        EventRegistration registration = new EventRegistration();
        registration.setType("org.apache.commons.services.Event");
        return registration;
    }

    public void addEventRegistration(EventRegistration eventRegistration) {
        this.eventRegistrations.put(eventRegistration.getName(), eventRegistration);
    }

    public void init() {
        this.eventRegistrations.clear();
        this.pool.clear();
    }

    public void destroy() {
        this.eventRegistrations.clear();
        this.pool.clear();
        try {
            this.pool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EventRegistration getDefaultEventRegistration() {
        return this.defaultEventRegistration;
    }

    public EventRegistration getEventRegistration(String key) {
        EventRegistration eventRegistration = (EventRegistration)this.eventRegistrations.get(key);
        if (eventRegistration == null) {
            eventRegistration = this.defaultEventRegistration;
        }
        return eventRegistration;
    }

    public Event getEvent(String name) {
        Event event = null;
        try {
            event = (Event)this.pool.borrowObject((Object)name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return event;
    }

    public Event getDefaultEvent() {
        Event event = null;
        try {
            event = (Event)this.pool.borrowObject((Object)this.defaultEventRegistration.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return event;
    }

    public Digester initDigester(Digester digester, String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Module can not be used alone. The path argument is mandatory.");
        }
        String eventPath = path + "/event";
        digester.addObjectCreate(eventPath, "org.apache.commons.services.EventRegistration", "type");
        digester.addSetNext(eventPath, "addEventRegistration", "org.apache.commons.services.EventRegistration");
        digester.addSetProperties(eventPath);
        digester.addSetProperty(eventPath + "/set-property", "property", "value");
        return digester;
    }
}

