/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class StackObjectPool
implements ObjectPool {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    protected Stack _pool = null;
    protected PoolableObjectFactory _factory = null;
    protected int _maxSleeping = 8;
    protected int _numActive = 0;

    public StackObjectPool() {
        this(null, 8, 4);
    }

    public StackObjectPool(int n) {
        this(null, n, 4);
    }

    public StackObjectPool(int n, int n2) {
        this(null, n, n2);
    }

    public StackObjectPool(PoolableObjectFactory poolableObjectFactory) {
        this(poolableObjectFactory, 8, 4);
    }

    public StackObjectPool(PoolableObjectFactory poolableObjectFactory, int n) {
        this(poolableObjectFactory, n, 4);
    }

    public StackObjectPool(PoolableObjectFactory poolableObjectFactory, int n, int n2) {
        this._factory = poolableObjectFactory;
        this._maxSleeping = n < 0 ? 8 : n;
        int n3 = n2 < 1 ? 4 : n2;
        this._pool = new Stack();
        this._pool.ensureCapacity(n3 > this._maxSleeping ? this._maxSleeping : n3);
    }

    public synchronized Object borrowObject() throws Exception {
        Object object = null;
        try {
            object = this._pool.pop();
        }
        catch (Exception exception) {
            if (null == this._factory) {
                throw new NoSuchElementException();
            }
            object = this._factory.makeObject();
        }
        if (null != this._factory && null != object) {
            this._factory.activateObject(object);
        }
        ++this._numActive;
        return object;
    }

    public synchronized void returnObject(Object object) throws Exception {
        --this._numActive;
        if (null == this._factory || this._factory.validateObject(object)) {
            if (null != this._factory) {
                try {
                    this._factory.passivateObject(object);
                }
                catch (Exception exception) {
                    this._factory.destroyObject(object);
                    return;
                }
            }
            if (this._pool.size() < this._maxSleeping) {
                this._pool.push(object);
            } else if (null != this._factory) {
                this._factory.destroyObject(object);
            }
        } else if (null != this._factory) {
            this._factory.destroyObject(object);
        }
    }

    public int numIdle() {
        return this._pool.size();
    }

    public int numActive() {
        return this._numActive;
    }

    public synchronized void clear() {
        if (null != this._factory) {
            Enumeration enumeration = this._pool.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    this._factory.destroyObject(enumeration.nextElement());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this._pool.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
    }

    public synchronized void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException {
        if (0 < this.numActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = poolableObjectFactory;
    }
}

