/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Constant;
import org.apache.commons.validator.Form;

public class FormSet
implements Serializable {
    private boolean bProcessed = false;
    private String language = null;
    private String country = null;
    private String variant = null;
    private FastHashMap hForms = new FastHashMap();
    private FastHashMap hConstants = new FastHashMap();

    public boolean isProcessed() {
        return this.bProcessed;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String string) {
        this.country = string;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String string) {
        this.variant = string;
    }

    public void addConstant(Constant constant) {
        if (constant.getName() != null && constant.getName().length() > 0 && constant.getValue() != null && constant.getValue().length() > 0) {
            this.hConstants.put((Object)constant.getName(), (Object)constant.getValue());
        }
    }

    public void addConstantParam(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            this.hConstants.put((Object)string, (Object)string2);
        }
    }

    public void addForm(Form form) {
        this.hForms.put((Object)form.getName(), (Object)form);
    }

    public Form getForm(Object object) {
        Form form = null;
        Object object2 = this.hForms.get(object);
        if (object2 != null) {
            form = (Form)object2;
        }
        return form;
    }

    public Map getForms() {
        return Collections.unmodifiableMap(this.hForms);
    }

    public synchronized void process(Map map) {
        Iterator iterator = this.hForms.values().iterator();
        while (iterator.hasNext()) {
            Form form = (Form)iterator.next();
            form.process(map, (Map)this.hConstants);
        }
        this.hForms.setFast(true);
        this.hConstants.setFast(true);
        this.bProcessed = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FormSet: language=");
        stringBuffer.append(this.language);
        stringBuffer.append("  country=");
        stringBuffer.append(this.country);
        stringBuffer.append("  variant=");
        stringBuffer.append(this.variant);
        stringBuffer.append("\n");
        Iterator iterator = this.getForms().values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("   ");
            stringBuffer.append(iterator.next());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

