/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogSource;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.ValidatorUtil;

public class Validator
implements Serializable {
    protected static Log log = LogSource.getInstance((String)(class$org$apache$commons$validator$Validator == null ? (class$org$apache$commons$validator$Validator = Validator.class$("org.apache.commons.validator.Validator")) : class$org$apache$commons$validator$Validator).getName());
    public static String BEAN_KEY = "java.lang.Object";
    public static String VALIDATOR_ACTION_KEY = "org.apache.commons.validator.ValidatorAction";
    public static String FIELD_KEY = "org.apache.commons.validator.Field";
    public static String LOCALE_KEY = "java.util.Locale";
    protected ValidatorResources resources = null;
    protected String formName = null;
    protected HashMap hResources = new HashMap();
    protected int page = 0;
    protected ClassLoader classLoader = null;
    protected boolean useContextClassLoader = false;
    static /* synthetic */ Class class$org$apache$commons$validator$Validator;

    public Validator(ValidatorResources validatorResources) {
        this.resources = validatorResources;
    }

    public Validator(ValidatorResources validatorResources, String string) {
        this.resources = validatorResources;
        this.formName = string;
    }

    public void addResource(String string, Object object) {
        this.hResources.put(string, object);
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String string) {
        this.formName = string;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public void clear() {
        this.formName = null;
        this.hResources = new HashMap();
        this.page = 0;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean bl) {
        this.useContextClassLoader = bl;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ValidatorResults validate() throws ValidatorException {
        ValidatorResults validatorResults = new ValidatorResults();
        Locale locale = null;
        if (this.hResources.containsKey(LOCALE_KEY)) {
            locale = (Locale)this.hResources.get(LOCALE_KEY);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Form form = null;
        form = this.resources.get(locale, this.formName);
        if (form != null) {
            Map map = this.resources.getValidatorActions();
            ArrayList arrayList = new ArrayList();
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            boolean bl = true;
            boolean bl2 = false;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            while (bl) {
                Serializable serializable;
                Object object;
                Object object2;
                ValidatorAction validatorAction = null;
                int n = 0;
                Collections.sort(arrayList, new DependencyComparator());
                Collections.sort(arrayList, new DependencySuccessComparator(hashMap));
                if (arrayList.size() > 0) {
                    validatorAction = (ValidatorAction)arrayList.get(0);
                }
                if (validatorAction != null && validatorAction.getDepends() != null && validatorAction.getDepends().length() > 0) {
                    object2 = new StringTokenizer(validatorAction.getDepends(), ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken().trim();
                        serializable = hashMap.get(object);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("ValidatorAction name=" + validatorAction.getName() + "  depends=" + validatorAction.getDepends()));
                        }
                        if (serializable == null) {
                            arrayList.clear();
                            validatorAction = null;
                            bl = false;
                            break;
                        }
                        boolean bl3 = (Boolean)serializable;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("ValidatorAction name=" + validatorAction.getName() + "  depend=" + (String)object + "  bContinue=" + bl3));
                        }
                        if (bl3) continue;
                        arrayList.clear();
                        validatorAction = null;
                        bl = false;
                        break;
                    }
                }
                if (log.isDebugEnabled()) {
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append("Order \n");
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        serializable = (ValidatorAction)object.next();
                        ((StringBuffer)object2).append("\t ValidatorAction name=" + ((ValidatorAction)serializable).getName() + "  depends=" + ((ValidatorAction)serializable).getDepends() + "\n");
                    }
                    log.debug((Object)((StringBuffer)object2).toString());
                }
                if (validatorAction != null) {
                    object2 = form.getFields().iterator();
                    while (object2.hasNext()) {
                        object = (Field)object2.next();
                        if (((Field)object).getPage() > this.page || ((Field)object).getDepends() == null || !((Field)object).isDependency(validatorAction.getName())) continue;
                        try {
                            Object object3;
                            this.hResources.put(VALIDATOR_ACTION_KEY, validatorAction);
                            this.hResources.put(FIELD_KEY, object);
                            serializable = this.getClassLoader().loadClass(validatorAction.getClassname());
                            List list = validatorAction.getMethodParamsList();
                            int n2 = list.size();
                            int n3 = -1;
                            int n4 = -1;
                            Class[] classArray = new Class[n2];
                            Object[] objectArray = new Object[n2];
                            int n5 = 0;
                            while (n5 < n2) {
                                object3 = (String)list.get(n5);
                                if (BEAN_KEY.equals(object3)) {
                                    n3 = n5;
                                }
                                if (FIELD_KEY.equals(object3)) {
                                    n4 = n5;
                                }
                                classArray[n5] = this.getClassLoader().loadClass((String)object3);
                                objectArray[n5] = this.hResources.get(object3);
                                ++n5;
                            }
                            object3 = ((Class)serializable).getMethod(validatorAction.getMethod(), classArray);
                            if (!Modifier.isStatic(((Method)object3).getModifiers())) {
                                try {
                                    if (validatorAction.getClassnameInstance() == null) {
                                        validatorAction.setClassnameInstance(((Class)serializable).newInstance());
                                    }
                                }
                                catch (Exception exception) {
                                    log.error((Object)("Couldn't load instance of class " + validatorAction.getClassname() + ".  " + exception.getMessage()));
                                }
                            }
                            Object object4 = null;
                            if (((Field)object).isIndexed()) {
                                Object object5 = PropertyUtils.getProperty(this.hResources.get(BEAN_KEY), (String)((Field)object).getIndexedListProperty());
                                Object[] objectArray2 = new Object[]{};
                                if (object5 instanceof Collection) {
                                    objectArray2 = ((Collection)object5).toArray();
                                } else if (object5.getClass().isArray()) {
                                    objectArray2 = (Object[])object5;
                                }
                                int n6 = 0;
                                while (n6 < objectArray2.length) {
                                    objectArray[n3] = objectArray2[n6];
                                    Field field = (Field)((Field)object).clone();
                                    field.setKey(ValidatorUtil.replace(field.getKey(), "[]", "[" + n6 + "]"));
                                    objectArray[n4] = field;
                                    object4 = ((Method)object3).invoke(validatorAction.getClassnameInstance(), objectArray);
                                    ++n6;
                                }
                            } else {
                                object4 = ((Method)object3).invoke(validatorAction.getClassnameInstance(), objectArray);
                            }
                            if (!this.isValid(object4)) {
                                ++n;
                            }
                            validatorResults.add((Field)object, validatorAction.getName(), this.isValid(object4));
                        }
                        catch (Exception exception) {
                            bl2 = true;
                            log.error((Object)("reflection: " + exception.getMessage()), (Throwable)exception);
                            validatorResults.add((Field)object, validatorAction.getName(), false);
                            if (!(exception instanceof ValidatorException)) continue;
                            throw (ValidatorException)exception;
                        }
                    }
                    if (n == 0) {
                        hashMap.put(validatorAction.getName(), new Boolean(true));
                    } else {
                        hashMap.put(validatorAction.getName(), new Boolean(false));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("name=" + validatorAction.getName() + "  size=" + arrayList.size()));
                    }
                    if (arrayList.size() > 0) {
                        arrayList.remove(0);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("after remove - name=" + validatorAction.getName() + "  size=" + arrayList.size()));
                    }
                }
                if (arrayList.size() != 0) continue;
                bl = false;
            }
        }
        return validatorResults;
    }

    private boolean isValid(Object object) {
        boolean bl = false;
        if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            bl = bl2;
        } else {
            bl = object != null;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class DependencySuccessComparator
    implements Comparator {
        Map hActionsRun = null;

        public DependencySuccessComparator(Map map) {
            this.hActionsRun = map;
        }

        public int compare(Object object, Object object2) {
            Object object3;
            Object object4;
            ValidatorAction validatorAction = (ValidatorAction)object;
            ValidatorAction validatorAction2 = (ValidatorAction)object2;
            if (!(validatorAction.getDepends() != null && validatorAction.getDepends().length() != 0 || validatorAction2.getDepends() != null && validatorAction2.getDepends().length() != 0)) {
                return 0;
            }
            if (validatorAction.getDepends() != null && validatorAction.getDepends().length() > 0 && (validatorAction2.getDepends() == null || validatorAction2.getDepends().length() == 0)) {
                return 1;
            }
            if ((validatorAction.getDepends() == null || validatorAction.getDepends().length() == 0) && validatorAction2.getDepends() != null && validatorAction2.getDepends().length() > 0) {
                return -1;
            }
            int n = 0;
            int n2 = 0;
            Iterator iterator = validatorAction.getDependencies().iterator();
            while (iterator.hasNext()) {
                object4 = ((String)iterator.next()).trim();
                object3 = this.hActionsRun.get(object4);
                if (object3 == null || !((Boolean)object3).booleanValue()) continue;
                ++n;
            }
            object4 = validatorAction2.getDependencies().iterator();
            while (object4.hasNext()) {
                object3 = ((String)object4.next()).trim();
                Object v = this.hActionsRun.get(object3);
                if (v == null || !((Boolean)v).booleanValue()) continue;
                ++n2;
            }
            return n - n2;
        }
    }

    protected class DependencyComparator
    implements Comparator {
        protected DependencyComparator() {
        }

        public int compare(Object object, Object object2) {
            ValidatorAction validatorAction = (ValidatorAction)object;
            ValidatorAction validatorAction2 = (ValidatorAction)object2;
            if (!(validatorAction.getDepends() != null && validatorAction.getDepends().length() != 0 || validatorAction2.getDepends() != null && validatorAction2.getDepends().length() != 0)) {
                return 0;
            }
            if (validatorAction.getDepends() != null && validatorAction.getDepends().length() > 0 && (validatorAction2.getDepends() == null || validatorAction2.getDepends().length() == 0)) {
                return 1;
            }
            if ((validatorAction.getDepends() == null || validatorAction.getDepends().length() == 0) && validatorAction2.getDepends() != null && validatorAction2.getDepends().length() > 0) {
                return -1;
            }
            return validatorAction.getDependencies().size() - validatorAction2.getDependencies().size();
        }
    }
}

