/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.math.BigDecimal;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class BigDecimalConverter
implements Converter {
    private Object defaultValue = null;

    public BigDecimalConverter() {
        this(null);
    }

    public BigDecimalConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        try {
            return new BigDecimal((String)value);
        }
        catch (Exception e) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

