/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.struts.taglib.tiles.ComponentConstants;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.ComponentDefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.definition.ReloadableDefinitionsFactory;

public class DefinitionsUtil
implements ComponentConstants {
    public static int userDebugLevel = 0;
    public static final int NO_DEBUG = 0;
    public static final String INSTANCES_CONFIG_USER_DEBUG_LEVEL = "instances-debug";
    public static final String DEFINITIONS_CONFIG_USER_DEBUG_LEVEL = "definitions-debug";
    public static final String DEFINITIONS_FACTORY_CLASSNAME = "definitions-factory-class";
    public static final String DEFINITIONS_FACTORY = "org.apache.struts.tiles.DEFINITIONS_FACTORY";
    public static final String ACTION_DEFINITION = "org.apache.struts.tiles.ACTION_DEFINITION";

    public static void setUserDebugLevel(int level) {
        userDebugLevel = level;
    }

    public static void initUserDebugLevel(ServletConfig servletConfig) {
        try {
            String str = servletConfig.getInitParameter(DEFINITIONS_CONFIG_USER_DEBUG_LEVEL);
            if (str == null) {
                str = servletConfig.getInitParameter(INSTANCES_CONFIG_USER_DEBUG_LEVEL);
            }
            if (str != null) {
                int level = Integer.parseInt(str);
                DefinitionsUtil.setUserDebugLevel(level);
                if (userDebugLevel > 1) {
                    System.out.println("Component Definitions debug level = " + userDebugLevel);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Set user level fail");
            ex.printStackTrace();
        }
    }

    public static ComponentDefinitionsFactory createDefinitionsFactory(ServletContext servletContext, Map properties, String classname) throws DefinitionsFactoryException {
        properties.put(DEFINITIONS_FACTORY_CLASSNAME, classname);
        return DefinitionsUtil.createDefinitionsFactory(servletContext, properties);
    }

    public static ComponentDefinitionsFactory createDefinitionsFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        ReloadableDefinitionsFactory factory = new ReloadableDefinitionsFactory(servletContext, properties);
        DefinitionsUtil.setDefinitionsFactory(factory, servletContext);
        return factory;
    }

    public static ComponentDefinitionsFactory createDefinitionsFactory(ServletContext servletContext, ServletConfig servletConfig) throws DefinitionsFactoryException {
        ComponentDefinitionsFactory factory = DefinitionsUtil.getDefinitionsFactory(servletContext);
        if (factory != null) {
            return factory;
        }
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            factory = DefinitionsUtil.getDefinitionsFactory(servletContext);
            if (factory != null) {
                ComponentDefinitionsFactory componentDefinitionsFactory = factory;
                return componentDefinitionsFactory;
            }
            DefinitionsUtil.initUserDebugLevel(servletConfig);
            factory = new ReloadableDefinitionsFactory(servletContext, servletConfig);
            DefinitionsUtil.setDefinitionsFactory(factory, servletContext);
            ComponentDefinitionsFactory componentDefinitionsFactory = factory;
            return componentDefinitionsFactory;
        }
    }

    protected static void setDefinitionsFactory(ComponentDefinitionsFactory factory, ServletContext servletContext) {
        servletContext.setAttribute(DEFINITIONS_FACTORY, (Object)factory);
    }

    public static ComponentDefinition getDefinition(String definitionName, ServletRequest request, ServletContext servletContext) throws FactoryNotFoundException, DefinitionsFactoryException {
        try {
            return DefinitionsUtil.getDefinitionsFactory(servletContext).getDefinition(definitionName, (ServletRequest)((HttpServletRequest)request), servletContext);
        }
        catch (NullPointerException ex) {
            throw new FactoryNotFoundException("Can't get definitions factory from context.");
        }
    }

    public static ComponentDefinition getDefinition(String definitionName, PageContext pageContext) throws FactoryNotFoundException, DefinitionsFactoryException {
        return DefinitionsUtil.getDefinition(definitionName, (ServletRequest)((HttpServletRequest)pageContext.getRequest()), pageContext.getServletContext());
    }

    public static ComponentDefinitionsFactory getDefinitionsFactory(ServletContext servletContext) {
        return (ComponentDefinitionsFactory)servletContext.getAttribute(DEFINITIONS_FACTORY);
    }

    public static ComponentDefinitionsFactory getDefinitionsFactory(PageContext pageContext) {
        return DefinitionsUtil.getDefinitionsFactory(pageContext.getServletContext());
    }

    public static ComponentDefinition getActionDefinition(ServletRequest request) {
        return (ComponentDefinition)request.getAttribute(ACTION_DEFINITION);
    }

    public static void setActionDefinition(ServletRequest request, ComponentDefinition definition) {
        request.setAttribute(ACTION_DEFINITION, (Object)definition);
    }

    public static void removeActionDefinition(ServletRequest request, ComponentDefinition definition) {
        request.removeAttribute(ACTION_DEFINITION);
    }
}

