/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ApplicationConfig;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.ComponentDefinitionsFactory;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;

public class TilesRequestProcessor
extends RequestProcessor {
    private ComponentDefinitionsFactory definitionsFactory;

    public void init(ActionServlet servlet, ApplicationConfig appConfig) throws ServletException {
        super.init(servlet, appConfig);
        this.initComponentDefinitionsMapping();
    }

    public void initComponentDefinitionsMapping() throws ServletException {
        try {
            this.definitionsFactory = DefinitionsUtil.createDefinitionsFactory(this.getServletContext(), this.servlet.getServletConfig());
        }
        catch (DefinitionsFactoryException ex) {
            this.log("Fail to load Tiles definition factory from processor", ex);
            throw new ServletException(ex.getMessage(), (Throwable)ex);
        }
        this.log("Tiles definition factory loaded for processor ");
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        boolean doInclude = false;
        Controller controller = null;
        ComponentContext tileContext = null;
        try {
            ComponentDefinition definition;
            tileContext = ComponentContext.getContext((ServletRequest)request);
            boolean bl = doInclude = tileContext != null;
            if (this.definitionsFactory != null && (definition = this.definitionsFactory.getDefinition(uri, (ServletRequest)request, this.getServletContext())) != null) {
                uri = definition.getPath();
                controller = definition.getOrCreateController();
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
            if ((definition = DefinitionsUtil.getActionDefinition((ServletRequest)request)) != null) {
                if (definition.getPath() != null) {
                    uri = definition.getPath();
                }
                if (definition.getOrCreateController() != null) {
                    controller = definition.getOrCreateController();
                }
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
        }
        catch (InstantiationException ex) {
            throw new ServletException("Can't create associated controller", (Throwable)ex);
        }
        catch (DefinitionsFactoryException ex) {
            throw new ServletException((Throwable)ex);
        }
        if (controller != null) {
            controller.perform(tileContext, request, response, this.getServletContext());
        }
        if ((rd = this.getServletContext().getRequestDispatcher(uri)) == null) {
            response.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)uri));
            return;
        }
        if (doInclude) {
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doForward(uri, request, response);
    }
}

