/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.xmlDefinition;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.xmlDefinition.DefinitionsFactory;
import org.apache.struts.tiles.xmlDefinition.FactorySet;
import org.apache.struts.tiles.xmlDefinition.XmlDefinitionsSet;
import org.apache.struts.tiles.xmlDefinition.XmlParser;
import org.xml.sax.SAXException;

public class I18nFactorySet
extends FactorySet {
    public static final boolean debug = false;
    public static final String INSTANCES_CONFIG_PARAMETER_NAME = "instances-config";
    public static final String DEFINITIONS_CONFIG_PARAMETER_NAME = "definitions-config";
    public static final String PARSER_DETAILS_PARAMETER_NAME = "definitions-parser-details";
    public static final String PARSER_VALIDATE_PARAMETER_NAME = "definitions-parser-validate";
    public static final String[] DEFAULT_DEFINITION_FILENAMES = new String[]{"/WEB-INF/tileDefinitions.xml", "/WEB-INF/componentDefinitions.xml", "/WEB-INF/instanceDefinitions.xml"};
    protected DefinitionsFactory defaultFactory;
    protected XmlParser xmlParser;
    protected boolean isValidatingParser = false;
    protected int parserDetailLevel = 0;
    private static final int MAX_BUNDLES_SEARCHED = 2;
    public static final String FILENAME_EXTENSION = ".xml";
    private List filenames;
    private Map loaded;

    public I18nFactorySet() {
    }

    public I18nFactorySet(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        this.initFactory(servletContext, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        String filename;
        String value = (String)properties.get(PARSER_VALIDATE_PARAMETER_NAME);
        if (value != null) {
            this.isValidatingParser = Boolean.valueOf(value);
        }
        if ((value = (String)properties.get(PARSER_DETAILS_PARAMETER_NAME)) != null) {
            try {
                this.parserDetailLevel = Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                System.out.println("Bad format for parameter 'definitions-parser-details'. Integer expected.");
                servletContext.log("Tiles factory init : Bad format for parameter 'definitions-parser-details'. Integer expected.");
            }
        }
        if ((filename = (String)properties.get(DEFINITIONS_CONFIG_PARAMETER_NAME)) != null) {
            try {
                this.initFactory(servletContext, filename);
                if (DefinitionsUtil.userDebugLevel <= 0) return;
                System.out.println("Factory initialized from file '" + filename + "'.");
                return;
            }
            catch (FileNotFoundException ex) {
                System.out.println(ex.getMessage() + " : Can't find file '" + filename + "'");
                throw new FactoryNotFoundException(ex.getMessage() + " : Can't find file '" + filename + "'");
            }
        }
        int i = 0;
        while (i < DEFAULT_DEFINITION_FILENAMES.length) {
            filename = DEFAULT_DEFINITION_FILENAMES[i];
            try {
                this.initFactory(servletContext, filename);
                if (DefinitionsUtil.userDebugLevel > 0) {
                    System.out.println("Factory initialized from file '" + filename + "'.");
                }
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            ++i;
        }
    }

    protected void initFactory(ServletContext servletContext, String proposedFilename) throws DefinitionsFactoryException, FileNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(proposedFilename, ",");
        this.filenames = new ArrayList(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            this.filenames.add(tokenizer.nextToken().trim());
        }
        this.loaded = new HashMap();
        this.defaultFactory = this.createDefaultFactory(servletContext);
    }

    protected DefinitionsFactory getDefaultFactory() {
        return this.defaultFactory;
    }

    protected DefinitionsFactory createDefaultFactory(ServletContext servletContext) throws DefinitionsFactoryException, FileNotFoundException {
        XmlDefinitionsSet rootXmlConfig = this.parseXmlFiles(servletContext, "", null);
        if (rootXmlConfig == null) {
            throw new FileNotFoundException();
        }
        rootXmlConfig.resolveInheritances();
        DefinitionsFactory factory = new DefinitionsFactory(rootXmlConfig);
        if (DefinitionsUtil.userDebugLevel > 0) {
            System.out.println("factory loaded : " + factory);
        }
        return factory;
    }

    protected Object getDefinitionsFactoryKey(String name, ServletRequest request, ServletContext servletContext) {
        Locale locale = null;
        try {
            HttpSession session = ((HttpServletRequest)request).getSession(false);
            if (session != null) {
                locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
            }
        }
        catch (ClassCastException ex) {
            System.out.println("Error - I18nFactorySet.getDefinitionsFactoryKey");
            ex.printStackTrace();
        }
        return locale;
    }

    protected DefinitionsFactory createFactory(Object key, ServletRequest request, ServletContext servletContext) throws DefinitionsFactoryException {
        if (key == null) {
            return this.getDefaultFactory();
        }
        List possiblePostfixes = I18nFactorySet.calculatePostixes("", (Locale)key);
        XmlDefinitionsSet lastXmlFile = null;
        DefinitionsFactory factory = null;
        String curPostfix = null;
        int i = possiblePostfixes.size() - 1;
        while (i >= 0) {
            curPostfix = (String)possiblePostfixes.get(i);
            factory = (DefinitionsFactory)this.loaded.get(curPostfix);
            if (factory != null) {
                return factory;
            }
            lastXmlFile = this.parseXmlFiles(servletContext, curPostfix, null);
            if (lastXmlFile != null) break;
            --i;
        }
        if (lastXmlFile == null) {
            return this.getDefaultFactory();
        }
        String lastPostfix = curPostfix;
        XmlDefinitionsSet rootXmlConfig = this.parseXmlFiles(servletContext, "", null);
        int j = 0;
        while (j < i) {
            curPostfix = (String)possiblePostfixes.get(j);
            this.parseXmlFiles(servletContext, curPostfix, rootXmlConfig);
            ++j;
        }
        rootXmlConfig.extend(lastXmlFile);
        rootXmlConfig.resolveInheritances();
        factory = new DefinitionsFactory(rootXmlConfig);
        this.loaded.put(lastPostfix, factory);
        if (DefinitionsUtil.userDebugLevel > 0) {
            System.out.println("factory loaded : " + factory);
        }
        return factory;
    }

    private static List calculatePostixes(String baseName, Locale locale) {
        String country;
        int countryLength;
        ArrayList<String> result = new ArrayList<String>(2);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        result.add(temp.toString());
        if (countryLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.add(temp.toString());
        return result;
    }

    private XmlDefinitionsSet parseXmlFiles(ServletContext servletContext, String postfix, XmlDefinitionsSet xmlDefinitions) throws DefinitionsFactoryException {
        if (postfix != null && postfix.length() == 0) {
            postfix = null;
        }
        Iterator i = this.filenames.iterator();
        while (i.hasNext()) {
            String filename = this.concatPostfix((String)i.next(), postfix);
            xmlDefinitions = this.parseXmlFile(servletContext, filename, xmlDefinitions);
        }
        return xmlDefinitions;
    }

    private XmlDefinitionsSet parseXmlFile(ServletContext servletContext, String filename, XmlDefinitionsSet xmlDefinitions) throws DefinitionsFactoryException {
        try {
            InputStream input = servletContext.getResourceAsStream(filename);
            if (input == null) {
                return xmlDefinitions;
            }
            this.xmlParser = new XmlParser();
            this.xmlParser.setValidating(this.isValidatingParser);
            this.xmlParser.setDetailLevel(this.parserDetailLevel);
            if (xmlDefinitions == null) {
                xmlDefinitions = new XmlDefinitionsSet();
            }
            this.xmlParser.parse(input, xmlDefinitions);
        }
        catch (SAXException ex) {
            throw new DefinitionsFactoryException("Error while parsing file '" + filename + "'. " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DefinitionsFactoryException("IO Error while parsing file '" + filename + "'. " + ex.getMessage(), ex);
        }
        return xmlDefinitions;
    }

    private String concatPostfix(String name, String postfix) {
        if (postfix == null) {
            return name;
        }
        int dotIndex = name.lastIndexOf(".");
        int lastNameStart = name.lastIndexOf(File.pathSeparator);
        if (dotIndex < 1 || dotIndex < lastNameStart) {
            return name + postfix;
        }
        String ext = name.substring(dotIndex);
        name = name.substring(0, dotIndex);
        return name + postfix + ext;
    }
}

