/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.xmlDefinition;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.struts.tiles.xmlDefinition.XmlDefinitionsSet;
import org.xml.sax.SAXException;

public class XmlParser {
    protected Digester digester;
    protected boolean validating = false;
    protected int digesterDebugLevel = 0;
    protected String[] registrations = new String[]{"-//Apache Software Foundation//DTD Tiles Configuration//EN", "/org/apache/struts/tiles/resources/tiles-config.dtd", "-//Apache Software Foundation//DTD Components Configuration//EN", "/org/apache/struts/tiles/resources/tiles-config.dtd"};

    public XmlParser() {
        this.digester = new Digester();
        this.digester.setDebug(this.digesterDebugLevel);
        this.digester.setValidating(this.validating);
        this.digester.setNamespaceAware(true);
        int i = 0;
        while (i < this.registrations.length) {
            URL url = this.getClass().getResource(this.registrations[i + 1]);
            if (url != null) {
                this.digester.register(this.registrations[i], url.toString());
            }
            i += 2;
        }
        this.initDigester(this.digester);
    }

    public void setValidating(boolean validating) {
        this.digester.setValidating(validating);
    }

    public void setDetailLevel(int detailLevel) {
        this.digester.setDebug(detailLevel);
    }

    private void initDigesterForComponentsDefinitionsSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.struts.tiles.xmlDefinition";
        String DEFINITION_TAG = "component-definitions/definition";
        String definitionHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = DEFINITION_TAG + "/put";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = DEFINITION_TAG + "/putList";
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = LIST_TAG + "/add";
        digester.addObjectCreate(DEFINITION_TAG, definitionHandlerClass);
        digester.addSetProperties(DEFINITION_TAG);
        digester.addSetNext(DEFINITION_TAG, "putDefinition", definitionHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addCallMethod(PUT_TAG, "setBody", 0);
        digester.addObjectCreate(LIST_TAG, listHandlerClass);
        digester.addSetProperties(LIST_TAG);
        digester.addSetNext(LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addCallMethod(ADD_LIST_ELE_TAG, "setBody", 0);
    }

    private void initDigesterForTilesDefinitionsSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.struts.tiles.xmlDefinition";
        String DEFINITION_TAG = "tiles-definitions/definition";
        String definitionHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = DEFINITION_TAG + "/put";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = DEFINITION_TAG + "/putList";
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = LIST_TAG + "/add";
        digester.addObjectCreate(DEFINITION_TAG, definitionHandlerClass);
        digester.addSetProperties(DEFINITION_TAG);
        digester.addSetNext(DEFINITION_TAG, "putDefinition", definitionHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addCallMethod(PUT_TAG, "setBody", 0);
        digester.addObjectCreate(LIST_TAG, listHandlerClass);
        digester.addSetProperties(LIST_TAG);
        digester.addSetNext(LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addCallMethod(ADD_LIST_ELE_TAG, "setBody", 0);
        String ADD_WILDCARD = "*/item";
        digester.addObjectCreate(ADD_WILDCARD, putAttributeHandlerClass, "classtype");
        digester.addSetNext(ADD_WILDCARD, "add", "java.lang.Object");
        digester.addSetProperties(ADD_WILDCARD);
    }

    private void initDigesterForInstancesSyntax(Digester digester) {
        String PACKAGE_NAME = "org.apache.struts.tiles.xmlDefinition";
        String INSTANCE_TAG = "component-instances/instance";
        String instanceHandlerClass = PACKAGE_NAME + ".XmlDefinition";
        String PUT_TAG = INSTANCE_TAG + "/put";
        String PUTATTRIBUTE_TAG = INSTANCE_TAG + "/putAttribute";
        String putAttributeHandlerClass = PACKAGE_NAME + ".XmlAttribute";
        String LIST_TAG = INSTANCE_TAG + "/putList";
        String listHandlerClass = PACKAGE_NAME + ".XmlListAttribute";
        String ADD_LIST_ELE_TAG = LIST_TAG + "/add";
        digester.addObjectCreate(INSTANCE_TAG, instanceHandlerClass);
        digester.addSetProperties(INSTANCE_TAG);
        digester.addSetNext(INSTANCE_TAG, "putDefinition", instanceHandlerClass);
        digester.addObjectCreate(PUTATTRIBUTE_TAG, putAttributeHandlerClass);
        digester.addSetProperties(PUTATTRIBUTE_TAG);
        digester.addSetNext(PUTATTRIBUTE_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(PUT_TAG, putAttributeHandlerClass);
        digester.addSetProperties(PUT_TAG);
        digester.addSetNext(PUT_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(LIST_TAG, listHandlerClass);
        digester.addSetProperties(LIST_TAG);
        digester.addSetNext(LIST_TAG, "addAttribute", putAttributeHandlerClass);
        digester.addObjectCreate(ADD_LIST_ELE_TAG, putAttributeHandlerClass);
        digester.addSetProperties(ADD_LIST_ELE_TAG);
        digester.addSetNext(ADD_LIST_ELE_TAG, "add", putAttributeHandlerClass);
    }

    protected void initDigester(Digester digester) {
        this.initDigesterForTilesDefinitionsSyntax(digester);
        this.initDigesterForComponentsDefinitionsSyntax(digester);
        this.initDigesterForInstancesSyntax(digester);
    }

    public void parse(InputStream in, XmlDefinitionsSet definitions) throws IOException, SAXException {
        this.digester.push((Object)definitions);
        this.digester.parse(in);
        in.close();
    }

    public static void main(String[] args) {
        String filename = "E:/programs/jakarta-tomcat/webapps/wtiles-struts/WEB-INF/tiles-examples-defs.xml";
        if (args.length > 1) {
            filename = args[1];
        }
        System.out.println("Read file '" + filename + "'");
        BufferedInputStream input = null;
        Object input2 = null;
        try {
            input = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (IOException ex) {
            System.out.println("can't open file '" + filename + "' : " + ex.getMessage());
        }
        try {
            XmlParser parser = new XmlParser();
            parser.setValidating(true);
            parser.setDetailLevel(0);
            XmlDefinitionsSet definitions = new XmlDefinitionsSet();
            System.out.println("  Parse file");
            parser.parse(input, definitions);
            System.out.println("  done.");
            System.out.println("  Result : " + definitions.toString());
        }
        catch (Exception ex) {
            System.out.println("Error during parsing '" + filename + "' : " + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

