/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class BasicDataSource
implements DataSource {
    protected boolean defaultAutoCommit = true;
    protected boolean defaultReadOnly = false;
    protected String driverClassName = null;
    protected int maxActive = 0;
    protected int maxIdle = 0;
    protected long maxWait = -1L;
    protected String password = null;
    protected String url = null;
    protected String username = null;
    protected String validationQuery = null;
    protected GenericObjectPool connectionPool = null;
    protected Properties connectionProperties = new Properties();
    protected DataSource dataSource = null;
    protected PrintWriter logWriter = new PrintWriter(System.out);

    public boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this.defaultAutoCommit = bl;
    }

    public boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.defaultReadOnly = bl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int n) {
        this.maxActive = n;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int n) {
        this.maxIdle = n;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long l) {
        this.maxWait = l;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public Connection getConnection() throws SQLException {
        return this.createDataSource().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.createDataSource().getConnection(string, string2);
    }

    public int getLoginTimeout() throws SQLException {
        return this.createDataSource().getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.createDataSource().setLoginTimeout(n);
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.createDataSource().setLogWriter(printWriter);
        this.logWriter = printWriter;
    }

    public void addConnectionProperty(String string, String string2) {
        ((Hashtable)this.connectionProperties).put(string, string2);
    }

    public void close() throws SQLException {
        GenericObjectPool genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            genericObjectPool.close();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.driverClassName);
        }
        catch (Throwable throwable) {
            String string = "Cannot load JDBC driver class '" + this.driverClassName + "'";
            this.getLogWriter().println(string);
            throwable.printStackTrace(this.getLogWriter());
            throw new SQLException(string);
        }
        Driver driver = null;
        try {
            driver = (Driver)clazz.newInstance();
        }
        catch (Throwable throwable) {
            String string = "Cannot create JDBC driver of class '" + this.driverClassName + "'";
            this.getLogWriter().println(string);
            throwable.printStackTrace(this.getLogWriter());
            throw new SQLException(string);
        }
        this.connectionPool = new GenericObjectPool(null);
        this.connectionPool.setMaxActive(this.maxActive);
        this.connectionPool.setMaxIdle(this.maxIdle);
        this.connectionPool.setMaxWait(this.maxWait);
        ((Hashtable)this.connectionProperties).put("user", this.username);
        ((Hashtable)this.connectionProperties).put("password", this.password);
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        PoolableConnectionFactory poolableConnectionFactory = null;
        try {
            poolableConnectionFactory = new PoolableConnectionFactory(driverConnectionFactory, (ObjectPool)this.connectionPool, null, this.validationQuery, this.defaultReadOnly, this.defaultAutoCommit);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.dataSource = new PoolingDataSource((ObjectPool)this.connectionPool);
        this.dataSource.setLogWriter(this.logWriter);
        return this.dataSource;
    }
}

