/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicDataSourceFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object == null || !(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        if (!"javax.sql.DataSource".equals(reference.getClassName())) {
            return null;
        }
        BasicDataSource basicDataSource = new BasicDataSource();
        RefAddr refAddr = null;
        refAddr = reference.get("defaultAutoCommit");
        if (refAddr != null) {
            basicDataSource.setDefaultAutoCommit(Boolean.getBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultReadOnly")) != null) {
            basicDataSource.setDefaultReadOnly(Boolean.getBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("driverClassName")) != null) {
            basicDataSource.setDriverClassName(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("maxActive")) != null) {
            basicDataSource.setMaxActive(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("maxIdle")) != null) {
            basicDataSource.setMaxIdle(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("maxWait")) != null) {
            basicDataSource.setMaxWait(Long.parseLong(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("password")) != null) {
            basicDataSource.setPassword(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("url")) != null) {
            basicDataSource.setUrl(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("username")) != null) {
            basicDataSource.setUsername(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("validationQuery")) != null) {
            basicDataSource.setValidationQuery(refAddr.getContent().toString());
        }
        return basicDataSource;
    }
}

