package at.salzburgresearch.applications.trainreservation.actionforms;

import org.apache.struts.action.*;
import javax.servlet.http.*;
import javax.servlet.*;
import java.util.*;
import at.salzburgresearch.applications.trainreservation.datamodel.*;
import at.salzburgresearch.applications.trainreservation.utils.*;

/**
 * Title: SelectSeatsForm.java
 * Description: Struts-Model for SeelctSeatsView.jsp
 * Copyright: Copyright (c) 2002
 * Company: Salzburg Research
 * @author Karl Rehrl
 * @version 1.0
 */

public class SelectSeatsForm extends org.apache.struts.action.ActionForm {

  private String coachNum = null;
  private ArrayList seats = null;
  private String action = null; // action parameter of the form

  public SelectSeatsForm() {
  }

  // property coachNum
  public void setCoachNum(String coachNum) {
    this.coachNum = coachNum;
  }
  public String getCoachNum() {
    return this.coachNum;
  }

  // property seats
  public ArrayList getSeats() {
    return seats;
  }
  public void setSeats(ArrayList seats) {
    this.seats = seats;
  }


  /**
   * Returns an ArrayList of seats, which where checked by the user
   */
  public ArrayList getCheckedSeats() {
    ArrayList checkedSeats = new ArrayList();
    Iterator it = seats.iterator();
    while (it.hasNext()) {
      Seat s = (Seat)it.next();
      if (s.getIsChecked()) checkedSeats.add(s);
    }
    return checkedSeats;
  }


  // property action
  public void setAction(String action) {
    this.action = action;
  }
  public String getAction() {
    return this.action;
  }


  /**
   * Resets the form-data for reuse of the instance
   */
  public void reset(ActionMapping mapping, HttpServletRequest request) {
    coachNum = null;
    action = null;
    seats = new ArrayList();
    setDBData(request);
  }


  /**
   * Sets data from the DB to the form
   */
  public void setDBData(HttpServletRequest request) {
    HttpSession session = request.getSession();
    Coach coach = (Coach)session.getAttribute(Keys.COACH);
    if (coach != null) {
      seats = coach.getSeats();
      Iterator it = seats.iterator();
      while (it.hasNext()) {
        Seat s = (Seat)it.next();
        s.setIsChecked(false);
      }
    }
    else seats = new ArrayList();
  }


  /**
   * Validates the input-data of the form
   */
  public ActionErrors validate(ActionMapping mapping,
                               HttpServletRequest request) {

    ActionErrors errors = new ActionErrors();

    if ((coachNum == null) || (coachNum.length() < 1))
        errors.add("coach_error", new ActionError("SelectSeatsView.errors.coach"));

    return errors;
  }
}