package at.salzburgresearch.applications.trainreservation.datamodel;

import java.util.*;

/**
 * Title: Coach.java
 * Description: Model for a Coach
 * Copyright: Copyright (c) 2002
 * Company: Salzburg Research
 * @author Karl Rehrl
 * @version 1.0
 */

public class Coach {

  private String coachNum;
  private Train train;  // for a reference to a train
  private ArrayList seats;  // for references to seats

  public Coach() {
  }

  public Coach(String coachNum, Train train) {
    this.coachNum = coachNum;
    this.train = train;
  }

  // proeprty coachNum
  public String getCoachNum() {
    return coachNum;
  }
  public void setCoachNum(String coachNum) {
    this.coachNum = coachNum;
  }

  // property train
  public void setTrain(Train train) {
    this.train = train;
  }
  public Train getTrain() {
    return train;
  }

  // property seats
  public void setSeats(ArrayList seats) {
    this.seats = seats;
  }
  public ArrayList getSeats() {
    return seats;
  }

  /**
   * Sets the seats to reserved
   * @param seatNums Numbers of the Seats to set reserved
   */
  public void setReservedSeats(Collection seatNums) {
    Iterator it = seats.iterator();
    while (it.hasNext()) {
      Seat seat = ((Seat)it.next());
      if (seatNums.contains(seat.getSeatNum())) {
        seat.setIsReserved(true);
      }
    }
  }
}